/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.refcodes.time.DateFormat;

public enum DateFormats {
    DEFAULT_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.NORM_DATE_FORMAT.getFormatter(), DateFormat.MIN_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_DATE_FORMAT.getFormatter(), DateFormat.DE_DATE_FORMAT.getFormatter(), DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter()}),
    DEFAULT_DATE_FORMATS_SHORT(new DateTimeFormatter[]{DateFormat.MIN_DATE_FORMAT.getFormatter(), DateFormat.NORM_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_DATE_FORMAT.getFormatter(), DateFormat.DE_DATE_FORMAT.getFormatter()}),
    COOKIE_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_COOKIE_DATE_FORMAT.getFormatter()});

    private DateTimeFormatter[] _dateFormats;

    private DateFormats(DateTimeFormatter[] aDateFormats) {
        this._dateFormats = aDateFormats;
    }

    public DateTimeFormatter[] getDateFormats() {
        return this._dateFormats;
    }

    public Date toDate(String aDateString) throws DateTimeException {
        DateTimeException theFirstException = null;
        for (DateTimeFormatter eDateFormat : this.getDateFormats()) {
            try {
                Instant theInstant = Instant.from(eDateFormat.parse(aDateString));
                return new Date(theInstant.toEpochMilli());
            }
            catch (DateTimeException e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            throw theFirstException;
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }
}

