/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum DateFormat {
    NETSCAPE_COOKIE_DATE_FORMAT(DateTimeFormatter.ofPattern("EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of("GMT"))),
    ALTERNATE_COOKIE_DATE_FORMAT(DateTimeFormatter.ofPattern("EEE',' dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of("GMT"))),
    RFC_1123_DATE_TIME_ALIKE(DateFormat.toRfc1123DateTimeAlike()),
    MIN_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault())),
    NORM_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(ZoneId.systemDefault())),
    MAX_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS").withZone(ZoneId.systemDefault())),
    ALTERNATE_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault())),
    DE_DATE_FORMAT(DateTimeFormatter.ofPattern("dd.mm.yyyy").withZone(ZoneId.systemDefault())),
    MIN_FILENAME_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.systemDefault())),
    NORM_FILENAME_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withZone(ZoneId.systemDefault())),
    MAX_FILENAME_DATE_FORMAT(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssSSSSSSS").withZone(ZoneId.systemDefault()));

    private DateTimeFormatter _dateFormat;

    private DateFormat(DateTimeFormatter aDateFormat) {
        this._dateFormat = aDateFormat;
    }

    private static DateTimeFormatter toRfc1123DateTimeAlike() {
        DateTimeFormatterBuilder theBuilder = new DateTimeFormatterBuilder();
        theBuilder.parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, DateFormat.getDow()).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, DateFormat.getMoy()).appendLiteral('-').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT");
        return theBuilder.toFormatter(Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateTimeFormatter getFormatter() {
        return this._dateFormat;
    }

    private static Map<Long, String> getDow() {
        HashMap<Long, String> theDow = new HashMap<Long, String>();
        theDow.put(1L, "Mon");
        theDow.put(2L, "Tue");
        theDow.put(3L, "Wed");
        theDow.put(4L, "Thu");
        theDow.put(5L, "Fri");
        theDow.put(6L, "Sat");
        theDow.put(7L, "Sun");
        return theDow;
    }

    private static Map<Long, String> getMoy() {
        HashMap<Long, String> moy = new HashMap<Long, String>();
        moy.put(1L, "Jan");
        moy.put(2L, "Feb");
        moy.put(3L, "Mar");
        moy.put(4L, "Apr");
        moy.put(5L, "May");
        moy.put(6L, "Jun");
        moy.put(7L, "Jul");
        moy.put(8L, "Aug");
        moy.put(9L, "Sep");
        moy.put(10L, "Oct");
        moy.put(11L, "Nov");
        moy.put(12L, "Dec");
        return moy;
    }
}

