/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.HashMap;
import java.util.Map;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.annotation.AnnotationInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.core.AnnotationInfoImpl;
import org.reflext.core.ReflectedObject;
import org.reflext.core.TypeResolverImpl;
import org.reflext.spi.model.AnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedDelegate<T, M, A, P, F, E>
extends ReflectedObject<T, M, A, P, F> {
    final AnnotationModel<T, E, A, P> annotationModel;
    private final E element;
    private Map<ClassTypeInfo, AnnotationInfo> annotations;

    public AnnotatedDelegate(TypeResolverImpl<T, M, A, P, F> domain, AnnotationModel<T, E, A, P> annotationModel, E element) {
        super(domain);
        this.annotationModel = annotationModel;
        this.element = element;
    }

    public <AN> AN getDeclaredAnnotation(E element, AnnotationType<AN, ?> annotationType) {
        Object type = annotationType.getType();
        if (type instanceof Class) {
            return (AN)this.annotationModel.resolveDeclaredAnnotation(element, (Class)type);
        }
        if (type instanceof ClassTypeInfo) {
            ClassTypeInfo cti = (ClassTypeInfo)type;
            if (cti.getKind() != ClassKind.ANNOTATION) {
                throw new IllegalArgumentException("The provided class type info is not an annotation");
            }
            if (this.annotations == null) {
                HashMap<ClassTypeInfo, AnnotationInfo> annotations = new HashMap<ClassTypeInfo, AnnotationInfo>();
                for (Object a : this.annotationModel.getDeclaredAnnotation(element)) {
                    Object ant = this.annotationModel.getAnnotationType(a);
                    ClassTypeInfo aaaa = (ClassTypeInfo)this.domain.resolve(ant);
                    annotations.put(aaaa, new AnnotationInfoImpl(this, aaaa, a));
                }
                this.annotations = annotations;
            }
            return (AN)this.annotations.get(cti);
        }
        throw new AssertionError();
    }
}

