/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dns;

import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.loader.ObjectFactory;
import org.restcomm.connect.commons.loader.ObjectInstantiationException;
import org.restcomm.connect.dns.DnsProvisioningManager;

public class DnsProvisioningManagerProvider {
    protected Logger logger = Logger.getLogger(DnsProvisioningManagerProvider.class);
    protected Configuration configuration;
    protected ServletContext context;

    public DnsProvisioningManagerProvider(Configuration configuration, ServletContext context) {
        this.configuration = configuration;
        this.context = context;
    }

    private DnsProvisioningManager create() {
        DnsProvisioningManager dnsProvisioningManager;
        Configuration dnsProvisioningConfiguration = this.configuration.subset("dns-provisioning");
        if (dnsProvisioningConfiguration == null || dnsProvisioningConfiguration.isEmpty()) {
            this.logger.warn((Object)"dns-provisioning configuration is null or empty");
            return null;
        }
        boolean enabled = this.configuration.getBoolean("dns-provisioning[@enabled]", false);
        if (!enabled) {
            this.logger.warn((Object)"dns-provisioning is disabled in configuration");
            return null;
        }
        String dnsProvisioningManagerClass = this.configuration.getString("dns-provisioning[@class]");
        if (dnsProvisioningManagerClass == null || dnsProvisioningManagerClass.trim().equals("")) {
            this.logger.warn((Object)"dns-provisioning is enabled but manager class is null or empty");
            return null;
        }
        try {
            dnsProvisioningManager = (DnsProvisioningManager)new ObjectFactory(this.getClass().getClassLoader()).getObjectInstance(dnsProvisioningManagerClass);
            dnsProvisioningManager.init(dnsProvisioningConfiguration);
        }
        catch (ObjectInstantiationException e) {
            throw new RuntimeException(e);
        }
        return dnsProvisioningManager;
    }

    public DnsProvisioningManager get() {
        DnsProvisioningManager manager = (DnsProvisioningManager)this.context.getAttribute("DnsProvisioningManager");
        if (manager != null) {
            return manager;
        }
        manager = this.create();
        this.context.setAttribute("DnsProvisioningManager", (Object)manager);
        return manager;
    }
}

