/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.mobicents.servlet.restcomm.dao.exceptions.AccountHierarchyDepthCrossed;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.extension.api.ApiRequest;
import org.restcomm.connect.extension.api.ExtensionResponse;
import org.restcomm.connect.extension.api.ExtensionType;
import org.restcomm.connect.extension.api.RestcommExtensionGeneric;
import org.restcomm.connect.extension.controller.ExtensionController;
import org.restcomm.connect.http.AbstractEndpoint;
import org.restcomm.connect.http.exceptions.AuthorizationException;
import org.restcomm.connect.http.exceptions.InsufficientPermission;
import org.restcomm.connect.http.exceptions.NotAuthenticated;
import org.restcomm.connect.http.exceptions.OperatedAccountMissing;
import org.restcomm.connect.identity.AuthOutcome;
import org.restcomm.connect.identity.IdentityContext;
import org.restcomm.connect.identity.UserIdentityContext;
import org.restcomm.connect.identity.shiro.RestcommRoles;

public abstract class SecuredEndpoint
extends AbstractEndpoint {
    protected Logger logger = Logger.getLogger(SecuredEndpoint.class);
    protected UserIdentityContext userIdentityContext;
    protected AccountsDao accountsDao;
    protected IdentityContext identityContext;
    @Context
    protected ServletContext context;
    @Context
    HttpServletRequest request;
    protected List<RestcommExtensionGeneric> extensions;

    public SecuredEndpoint() {
    }

    public SecuredEndpoint(ServletContext context, HttpServletRequest request) {
        this.context = context;
        this.request = request;
    }

    @Override
    protected void init(Configuration configuration) {
        super.init(configuration);
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = storage.getAccountsDao();
        this.identityContext = (IdentityContext)this.context.getAttribute(IdentityContext.class.getName());
        this.userIdentityContext = new UserIdentityContext(this.request, this.accountsDao);
        this.extensions = ExtensionController.getInstance().getExtensions(ExtensionType.RestApi);
        if (this.logger.isInfoEnabled() && this.extensions != null) {
            this.logger.info((Object)("RestAPI extensions: " + (this.extensions != null ? Integer.valueOf(this.extensions.size()) : "0")));
        }
    }

    protected void checkAuthenticatedAccount() {
        if (this.userIdentityContext.getEffectiveAccount() == null) {
            throw new NotAuthenticated();
        }
    }

    protected boolean isSuperAdmin() {
        return this.userIdentityContext.getEffectiveAccount().getParentSid() == null && this.userIdentityContext.getEffectiveAccount().getStatus().equals((Object)Account.Status.ACTIVE);
    }

    protected void checkPermission(String permission) {
        if (this.checkPermission(permission, this.userIdentityContext.getEffectiveAccountRoles()) != AuthOutcome.OK) {
            throw new InsufficientPermission();
        }
    }

    protected boolean isSecuredByPermission(String permission) {
        try {
            this.checkPermission(permission);
            return true;
        }
        catch (AuthorizationException e) {
            return false;
        }
    }

    protected void secure(Account operatedAccount, String permission) throws AuthorizationException {
        this.secure(operatedAccount, permission, SecuredType.SECURED_STANDARD);
    }

    protected void secure(Account operatedAccount, String permission, SecuredType type) throws AuthorizationException {
        this.checkAuthenticatedAccount();
        this.checkPermission(permission);
        if (operatedAccount == null) {
            throw new OperatedAccountMissing();
        }
        if (type == SecuredType.SECURED_STANDARD ? this.secureLevelControl(operatedAccount, null) != AuthOutcome.OK : (type == SecuredType.SECURED_APP ? this.secureLevelControlApplications(operatedAccount, null) != AuthOutcome.OK : type == SecuredType.SECURED_ACCOUNT && this.secureLevelControlAccounts(operatedAccount) != AuthOutcome.OK)) {
            throw new InsufficientPermission();
        }
    }

    protected void secure(Account operatedAccount, Sid resourceAccountSid, SecuredType type) throws AuthorizationException {
        String resourceAccountSidString;
        this.checkAuthenticatedAccount();
        if (operatedAccount == null) {
            throw new OperatedAccountMissing();
        }
        String string = resourceAccountSidString = resourceAccountSid == null ? null : resourceAccountSid.toString();
        if (type == SecuredType.SECURED_APP) {
            if (this.secureLevelControlApplications(operatedAccount, resourceAccountSidString) != AuthOutcome.OK) {
                throw new InsufficientPermission();
            }
        } else if (type == SecuredType.SECURED_STANDARD) {
            if (this.secureLevelControl(operatedAccount, resourceAccountSidString) != AuthOutcome.OK) {
                throw new InsufficientPermission();
            }
        } else {
            if (type == SecuredType.SECURED_ACCOUNT) {
                throw new IllegalStateException("Account security is not supported when using sub-resources");
            }
            throw new NotImplementedException();
        }
    }

    protected boolean hasAccountRole(String role) {
        if (this.userIdentityContext.getEffectiveAccount() != null) {
            return this.userIdentityContext.getEffectiveAccountRoles().contains(role);
        }
        return false;
    }

    private AuthOutcome checkPermission(String neededPermissionString, Set<String> roleNames) {
        if (roleNames.contains(this.getAdministratorRole())) {
            return AuthOutcome.OK;
        }
        WildcardPermissionResolver resolver = new WildcardPermissionResolver();
        Permission neededPermission = resolver.resolvePermission(neededPermissionString);
        RestcommRoles restcommRoles = this.identityContext.getRestcommRoles();
        for (String roleName : roleNames) {
            SimpleRole simpleRole = restcommRoles.getRole(roleName);
            if (simpleRole == null) {
                return AuthOutcome.FAILED;
            }
            Set permissions = simpleRole.getPermissions();
            for (Permission permission : permissions) {
                if (!permission.implies(neededPermission)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Granted access by permission " + permission.toString()));
                }
                return AuthOutcome.OK;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Role " + roleName + " does not allow " + neededPermissionString));
        }
        return AuthOutcome.FAILED;
    }

    private AuthOutcome secureLevelControl(Account operatedAccount, String resourceAccountSid) {
        Account operatingAccount = this.userIdentityContext.getEffectiveAccount();
        String operatingAccountSid = null;
        if (operatingAccount != null) {
            operatingAccountSid = operatingAccount.getSid().toString();
        }
        String operatedAccountSid = null;
        if (operatedAccount != null) {
            operatedAccountSid = operatedAccount.getSid().toString();
        }
        if (resourceAccountSid != null && !resourceAccountSid.equals(operatedAccountSid)) {
            return AuthOutcome.FAILED;
        }
        if (operatingAccountSid.equals(operatedAccountSid)) {
            return AuthOutcome.OK;
        }
        if (operatedAccount.getParentSid() != null) {
            if (operatedAccount.getParentSid().toString().equals(operatingAccountSid)) {
                return AuthOutcome.OK;
            }
            if (this.accountsDao.getAccountLineage(operatedAccount).contains(operatingAccountSid)) {
                return AuthOutcome.OK;
            }
        }
        return AuthOutcome.FAILED;
    }

    private AuthOutcome secureLevelControlApplications(Account operatedAccount, String applicationAccountSid) {
        return this.secureLevelControl(operatedAccount, applicationAccountSid);
    }

    private AuthOutcome secureLevelControlAccounts(Account operatedAccount) throws AccountHierarchyDepthCrossed {
        Account operatingAccount = this.userIdentityContext.getEffectiveAccount();
        String operatingAccountSid = operatingAccount.getSid().toString();
        String operatedAccountSid = operatedAccount.getSid().toString();
        if (this.getAdministratorRole().equals(operatingAccount.getRole())) {
            if (operatingAccountSid.equals(operatedAccountSid)) {
                return AuthOutcome.OK;
            }
            if (operatedAccount.getParentSid() != null) {
                if (operatedAccount.getParentSid().toString().equals(operatingAccountSid)) {
                    return AuthOutcome.OK;
                }
                if (this.accountsDao.getAccountLineage(operatedAccount).contains(operatingAccountSid)) {
                    return AuthOutcome.OK;
                }
            }
            return AuthOutcome.FAILED;
        }
        if (operatingAccountSid.equals(operatedAccountSid)) {
            return AuthOutcome.OK;
        }
        return AuthOutcome.FAILED;
    }

    protected String getAdministratorRole() {
        return "Administrator";
    }

    protected boolean executePreApiAction(ApiRequest apiRequest) {
        if (this.extensions != null && this.extensions.size() > 0) {
            for (RestcommExtensionGeneric extension : this.extensions) {
                ExtensionResponse response;
                if (!extension.isEnabled() || (response = extension.preApiAction(apiRequest)).isAllowed()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean executePostApiAction(ApiRequest apiRequest) {
        return false;
    }

    public static enum SecuredType {
        SECURED_APP,
        SECURED_ACCOUNT,
        SECURED_STANDARD;

    }
}

