/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Transcription;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.TranscriptionsEndpoint;

@Path(value="/Accounts/{accountSid}/Transcriptions")
public final class TranscriptionsXmlEndpoint
extends TranscriptionsEndpoint {
    @Path(value="/{sid}")
    @DELETE
    public Response deleteTranscription(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Delete:Transcriptions");
        Transcription transcription = this.dao.getTranscription(new Sid(sid));
        if (transcription != null) {
            this.secure(operatedAccount, String.valueOf(transcription.getAccountSid()), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        }
        this.dao.removeTranscription(new Sid(sid));
        return Response.ok().build();
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getTranscriptionAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getTranscription(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getTranscriptionAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getTranscription(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getTranscriptions(@PathParam(value="accountSid") String accountSid) {
        return this.getTranscriptions(accountSid, MediaType.APPLICATION_XML_TYPE);
    }
}

