/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.http.ApplicationsEndpoint;
import org.restcomm.connect.http.SecuredEndpoint;

@Path(value="/Accounts/{accountSid}/Applications")
@ThreadSafe
public class ApplicationsXmlEndpoint
extends ApplicationsEndpoint {
    private Response deleteApplication(String accountSid, String sid) {
        Account operatedAccount = this.accountsDao.getAccount(new Sid(accountSid));
        this.secure(operatedAccount, "RestComm:Modify:Applications", SecuredEndpoint.SecuredType.SECURED_APP);
        Application application = this.dao.getApplication(new Sid(sid));
        if (application != null) {
            this.secure(operatedAccount, application.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
        }
        this.dao.removeApplication(new Sid(sid));
        return Response.ok().build();
    }

    @GET
    public Response getApplications(@PathParam(value="accountSid") String accountSid) {
        return this.getApplications(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getApplicationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getApplication(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getApplicationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getApplication(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @POST
    public Response putApplication(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putApplication(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @POST
    public Response updateApplicationAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateApplication(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @POST
    public Response updateApplicationAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateApplication(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateApplicationAsJsonPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateApplication(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateApplicationAsXmlPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateApplication(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteApplicationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteApplication(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteApplicationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteApplication(accountSid, sid);
    }
}

