/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.OutgoingCallerIdsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.OutgoingCallerId;
import org.restcomm.connect.dao.entities.OutgoingCallerIdList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.OutgoingCallerIdConverter;
import org.restcomm.connect.http.converter.OutgoingCallerIdListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class OutgoingCallerIdsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected OutgoingCallerIdsDao dao;
    protected Gson gson;
    protected XStream xstream;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getOutgoingCallerIdsDao();
        OutgoingCallerIdConverter converter = new OutgoingCallerIdConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(OutgoingCallerId.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new OutgoingCallerIdListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private OutgoingCallerId createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        Sid sid = Sid.generate((Sid.Type)Sid.Type.PHONE_NUMBER);
        DateTime now = DateTime.now();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber phoneNumber = null;
        try {
            phoneNumber = phoneNumberUtil.parse((String)data.getFirst((Object)"PhoneNumber"), "US");
        }
        catch (NumberParseException ignored) {
            // empty catch block
        }
        String friendlyName = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(null)).append("/Accounts/").append(accountSid.toString()).append("/OutgoingCallerIds/").append(sid.toString());
        URI uri = URI.create(buffer.toString());
        return new OutgoingCallerId(sid, now, now, friendlyName, accountSid, phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164), uri);
    }

    protected Response getCallerId(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:OutgoingCallerIds");
        OutgoingCallerId outgoingCallerId = this.dao.getOutgoingCallerId(new Sid(sid));
        if (outgoingCallerId == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, outgoingCallerId.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)outgoingCallerId), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)outgoingCallerId);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getCallerIds(String accountSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:OutgoingCallerIds");
        List outgoingCallerIds = this.dao.getOutgoingCallerIds(new Sid(accountSid));
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)outgoingCallerIds), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new OutgoingCallerIdList(outgoingCallerIds));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response putOutgoingCallerId(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:OutgoingCallerIds");
        try {
            this.validate(data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        OutgoingCallerId outgoingCallerId = this.createFrom(new Sid(accountSid), data);
        this.dao.addOutgoingCallerId(outgoingCallerId);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)outgoingCallerId), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)outgoingCallerId);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response updateOutgoingCallerId(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Modify:OutgoingCallerIds");
        OutgoingCallerId outgoingCallerId = this.dao.getOutgoingCallerId(new Sid(sid));
        if (outgoingCallerId == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, outgoingCallerId.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (data.containsKey((Object)"FriendlyName")) {
            String friendlyName = (String)data.getFirst((Object)"FriendlyName");
            outgoingCallerId = outgoingCallerId.setFriendlyName(friendlyName);
        }
        this.dao.updateOutgoingCallerId(outgoingCallerId);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)outgoingCallerId), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)outgoingCallerId);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"PhoneNumber")) {
            throw new NullPointerException("Phone number can not be null.");
        }
        try {
            PhoneNumberUtil.getInstance().parse((String)data.getFirst((Object)"PhoneNumber"), "US");
        }
        catch (NumberParseException exception) {
            throw new IllegalArgumentException("Invalid phone number.");
        }
    }
}

