/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.http.ClientsEndpoint;
import org.restcomm.connect.http.SecuredEndpoint;

@Path(value="/Accounts/{accountSid}/Clients")
@ThreadSafe
public final class ClientsXmlEndpoint
extends ClientsEndpoint {
    private Response deleteClient(String accountSid, String sid) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Delete:Clients");
        Client client = this.dao.getClient(new Sid(sid));
        if (client != null) {
            this.secure(operatedAccount, client.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
            this.dao.removeClient(new Sid(sid));
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteClientAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteClient(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteClientAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteClient(accountSid, sid);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getClientAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getClient(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getClientAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getClient(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getClients(@PathParam(value="accountSid") String accountSid) {
        return this.getClients(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response putClient(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putClient(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @POST
    public Response updateClientAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateClient(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateClientAsJsonPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateClient(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @POST
    public Response updateClientAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateClient(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateClientAsXmlPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateClient(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }
}

