/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.telephony.CreateCallType;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.CallDetailRecordList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.CallDetailRecordConverter;
import org.restcomm.connect.http.converter.CallDetailRecordListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.ExecuteCallScript;
import org.restcomm.connect.telephony.api.GetCallInfo;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class UssdPushEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    private ActorRef ussdCallManager;
    private DaoManager daos;
    private Gson gson;
    private GsonBuilder builder;
    private XStream xstream;
    private CallDetailRecordListConverter listConverter;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.ussdCallManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.ussd.telephony.UssdCallManager");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        super.init(this.configuration);
        CallDetailRecordConverter converter = new CallDetailRecordConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
    }

    protected Response putCall(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Sid accountId = new Sid(accountSid);
        this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Create:Calls");
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String from = (String)data.getFirst((Object)"From");
        String to = (String)data.getFirst((Object)"To");
        String username = (String)data.getFirst((Object)"Username");
        String password = (String)data.getFirst((Object)"Password");
        Integer timeout = this.getTimeout(data);
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        CreateCall create = null;
        try {
            CallResponse callResponse;
            ActorRef call;
            CallManagerResponse managerResponse;
            create = new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCallType.USSD, accountId, null, null, null, null);
            create.setCreateCDR(false);
            Future future = Patterns.ask((ActorRef)this.ussdCallManager, (Object)create, (Timeout)expires);
            Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            Class<?> klass = object.getClass();
            if (CallManagerResponse.class.equals(klass) && (managerResponse = (CallManagerResponse)object).succeeded() && CallResponse.class.equals(klass = (object = Await.result((Awaitable)(future = Patterns.ask((ActorRef)(call = (ActorRef)managerResponse.get()), (Object)new GetCallInfo(), (Timeout)expires)), (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS))).getClass()) && (callResponse = (CallResponse)object).succeeded()) {
                CallInfo callInfo = (CallInfo)callResponse.get();
                String version = this.getApiVersion(data);
                URI url = this.getUrl("Url", data);
                String method = this.getMethod("Method", data);
                URI fallbackUrl = this.getUrl("FallbackUrl", data);
                String fallbackMethod = this.getMethod("FallbackMethod", data);
                ExecuteCallScript execute = new ExecuteCallScript(call, accountId, version, url, method, fallbackUrl, fallbackMethod);
                this.ussdCallManager.tell((Object)execute, null);
                CallDetailRecord cdr = this.daos.getCallDetailRecordsDao().getCallDetailRecord(callInfo.sid());
                if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                    return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
                }
                if (MediaType.APPLICATION_XML_TYPE == responseType) {
                    return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
                }
                return null;
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    private Integer getTimeout(MultivaluedMap<String, String> data) {
        Integer result = 60;
        if (data.containsKey((Object)"Timeout")) {
            result = Integer.parseInt((String)data.getFirst((Object)"Timeout"));
        }
        return result;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Url")) {
            throw new NullPointerException("Url can not be null.");
        }
    }
}

