/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.http.converter.AbstractConverter;
import org.restcomm.connect.telephony.api.CallInfo;

public class CallinfoConverter
extends AbstractConverter
implements JsonSerializer<CallInfo> {
    private final String apiVersion;
    private final String rootUri;

    @Override
    public boolean canConvert(Class klass) {
        return CallInfo.class.equals((Object)klass);
    }

    public CallinfoConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    public JsonElement serialize(CallInfo callInfo, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(callInfo.sid(), object);
        this.writeState(callInfo.state().name(), object);
        if (callInfo.type() != null) {
            this.writeType(callInfo.type().name(), object);
        }
        this.writeDirection(callInfo.direction(), object);
        this.writeDateCreated(callInfo.dateCreated(), object);
        this.writeForwardedFrom(callInfo.forwardedFrom(), object);
        this.writeCallerName(callInfo.fromName(), object);
        this.writeFrom(callInfo.from(), object);
        this.writeTo(callInfo.to(), object);
        if (callInfo.invite() != null) {
            this.writeInviteUri(callInfo.invite().getRequestURI(), object);
        }
        if (callInfo.lastResponse() != null) {
            this.writeLastResponseUri(callInfo.lastResponse().getStatus(), object);
        }
        return object;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        CallInfo callInfo = (CallInfo)object;
        writer.startNode("CallInfo");
        this.writeSid(callInfo.sid(), writer);
        this.writeState(callInfo.state().name(), writer);
        if (callInfo.type() != null) {
            this.writeType(callInfo.type().name(), writer);
        }
        this.writeDirection(callInfo.direction(), writer);
        this.writeDateCreated(callInfo.dateCreated(), writer);
        this.writeForwardedFrom(callInfo.forwardedFrom(), writer);
        this.writeCallerName(callInfo.fromName(), writer);
        this.writeFrom(callInfo.from(), writer);
        this.writeTo(callInfo.to(), writer);
        this.writeInviteUri(callInfo.invite().getRequestURI(), writer);
        if (callInfo.lastResponse() != null) {
            this.writeLastResponseUri(callInfo.lastResponse().getStatus(), writer);
        }
        writer.endNode();
    }

    private void writeState(String state, HierarchicalStreamWriter writer) {
        writer.startNode("State");
        writer.setValue(state);
        writer.endNode();
    }

    private void writeState(String state, JsonObject object) {
        object.addProperty("State", state);
    }

    private void writeDirection(String direction, HierarchicalStreamWriter writer) {
        writer.startNode("Direction");
        writer.setValue(direction);
        writer.endNode();
    }

    private void writeDirection(String direction, JsonObject object) {
        object.addProperty("direction", direction);
    }

    private void writeForwardedFrom(String forwardedFrom, HierarchicalStreamWriter writer) {
        writer.startNode("ForwardedFrom");
        if (forwardedFrom != null) {
            writer.setValue(forwardedFrom);
        }
        writer.endNode();
    }

    private void writeForwardedFrom(String forwardedFrom, JsonObject object) {
        object.addProperty("ForwardedFrom", forwardedFrom);
    }

    private void writeCallerName(String callerName, HierarchicalStreamWriter writer) {
        writer.startNode("CallerName");
        if (callerName != null) {
            writer.setValue(callerName);
        }
        writer.endNode();
    }

    private void writeCallerName(String callerName, JsonObject object) {
        object.addProperty("CallerName", callerName);
    }

    private void writeInviteUri(URI requestUri, HierarchicalStreamWriter writer) {
        writer.startNode("Initial Invite");
        if (requestUri != null) {
            writer.setValue(requestUri.toString());
        }
        writer.endNode();
    }

    private void writeInviteUri(URI requestUri, JsonObject object) {
        object.addProperty("Initial Invite", requestUri.toString());
    }

    private void writeLastResponseUri(int responseCode, HierarchicalStreamWriter writer) {
        writer.startNode("Last Response");
        if (responseCode > -1) {
            writer.setValue(String.valueOf(responseCode));
        }
        writer.endNode();
    }

    private void writeLastResponseUri(int responseCode, JsonObject object) {
        object.addProperty("Last Response", (Number)responseCode);
    }
}

