/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.Version;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.http.converter.AbstractConverter;
import org.restcomm.connect.monitoringservice.LiveCallsDetails;
import org.restcomm.connect.telephony.api.CallInfo;

public class MonitoringServiceConverterCallDetails
extends AbstractConverter
implements JsonSerializer<LiveCallsDetails> {
    public MonitoringServiceConverterCallDetails(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return List.class.equals((Object)klass);
    }

    public JsonElement serialize(LiveCallsDetails callDetails, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray callsArray = new JsonArray();
        result.addProperty("InstanceId", RestcommConfiguration.getInstance().getMain().getInstanceId());
        result.addProperty("Version", Version.getVersion());
        result.addProperty("Revision", Version.getRevision());
        List liveCalls = callDetails.getCallDetails();
        if (liveCalls.size() > 0) {
            for (CallInfo callInfo : liveCalls) {
                callsArray.add(context.serialize((Object)callInfo));
            }
        }
        result.add("LiveCallDetails", (JsonElement)callsArray);
        return result;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        List callDetails = (List)object;
        writer.startNode("InstanceId");
        writer.setValue(RestcommConfiguration.getInstance().getMain().getInstanceId());
        writer.endNode();
        writer.startNode("Version");
        writer.setValue(Version.getVersion());
        writer.endNode();
        writer.startNode("Revision");
        writer.setValue(Version.getRevision());
        writer.endNode();
        if (callDetails.size() > 0) {
            writer.startNode("LiveCallDetails");
            for (CallInfo callInfo : callDetails) {
                context.convertAnother((Object)callInfo);
            }
            writer.endNode();
        }
    }
}

