/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.configuration.sets.RcmlserverConfigurationSet;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.AccountList;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.IncomingPhoneNumbersEndpoint;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.client.rcmlserver.RcmlserverApi;
import org.restcomm.connect.http.client.rcmlserver.RcmlserverNotifications;
import org.restcomm.connect.http.converter.AccountConverter;
import org.restcomm.connect.http.converter.AccountListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.exceptions.AccountAlreadyClosed;
import org.restcomm.connect.http.exceptions.AuthorizationException;
import org.restcomm.connect.http.exceptions.InsufficientPermission;
import org.restcomm.connect.http.exceptions.PasswordTooWeak;
import org.restcomm.connect.http.exceptions.RcmlserverNotifyError;
import org.restcomm.connect.identity.passwords.PasswordValidator;
import org.restcomm.connect.identity.passwords.PasswordValidatorFactory;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManager;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManagerProvider;

public class AccountsEndpoint
extends SecuredEndpoint {
    protected Configuration runtimeConfiguration;
    protected Configuration rootConfiguration;
    protected Gson gson;
    protected XStream xstream;
    protected ClientsDao clientDao;

    public AccountsEndpoint() {
    }

    public AccountsEndpoint(ServletContext context, HttpServletRequest request) {
        super(context, request);
    }

    @PostConstruct
    void init() {
        this.rootConfiguration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.runtimeConfiguration = this.rootConfiguration.subset("runtime-settings");
        super.init(this.runtimeConfiguration);
        this.clientDao = ((DaoManager)this.context.getAttribute(DaoManager.class.getName())).getClientsDao();
        AccountConverter converter = new AccountConverter(this.runtimeConfiguration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Account.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new AccountListConverter(this.runtimeConfiguration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.runtimeConfiguration));
    }

    private Account createFrom(Sid accountSid, MultivaluedMap<String, String> data) throws PasswordTooWeak {
        this.validate(data);
        DateTime now = DateTime.now();
        String emailAddress = ((String)data.getFirst((Object)"EmailAddress")).toLowerCase();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.ACCOUNT, (String)emailAddress);
        String friendlyName = emailAddress;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        Account.Type type = Account.Type.FULL;
        Account.Status status = Account.Status.ACTIVE;
        if (data.containsKey((Object)"Status")) {
            status = Account.Status.getValueOf((String)((String)data.getFirst((Object)"Status")).toLowerCase());
        }
        String password = (String)data.getFirst((Object)"Password");
        PasswordValidator validator = PasswordValidatorFactory.createDefault();
        if (!validator.isStrongEnough(password)) {
            throw new PasswordTooWeak();
        }
        String authToken = new Md5Hash((Object)password).toString();
        String role = (String)data.getFirst((Object)"Role");
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.getApiVersion(null)).append("/Accounts/").append(sid.toString());
        URI uri = URI.create(buffer.toString());
        return new Account(sid, now, now, emailAddress, friendlyName, accountSid, type, status, authToken, role, uri);
    }

    protected Response getAccount(String accountSid, MediaType responseType) {
        this.checkAuthenticatedAccount();
        Account account = null;
        this.checkPermission("RestComm:Read:Accounts");
        if (Sid.pattern.matcher(accountSid).matches()) {
            try {
                account = this.accountsDao.getAccount(new Sid(accountSid));
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        try {
            account = this.accountsDao.getAccount(accountSid);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, "RestComm:Read:Accounts", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        return null;
    }

    private void removeAccoundDependencies(Sid sid) {
        DaoManager daoManager = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        daoManager.getAnnouncementsDao().removeAnnouncements(sid);
        daoManager.getNotificationsDao().removeNotifications(sid);
        daoManager.getShortCodesDao().removeShortCodes(sid);
        daoManager.getOutgoingCallerIdsDao().removeOutgoingCallerIds(sid);
        daoManager.getTranscriptionsDao().removeTranscriptions(sid);
        daoManager.getRecordingsDao().removeRecordings(sid);
        daoManager.getApplicationsDao().removeApplications(sid);
        this.removeIncomingPhoneNumbers(sid, daoManager.getIncomingPhoneNumbersDao());
        daoManager.getClientsDao().removeClients(sid);
    }

    private void removeIncomingPhoneNumbers(Sid accountSid, IncomingPhoneNumbersDao dao) {
        List numbers = dao.getIncomingPhoneNumbers(accountSid);
        if (numbers != null && numbers.size() > 0) {
            boolean managerQueried = false;
            PhoneNumberProvisioningManager manager = null;
            for (IncomingPhoneNumber number : numbers) {
                if (number.isPureSip() == null || !number.isPureSip().booleanValue()) {
                    if (!managerQueried) {
                        manager = new PhoneNumberProvisioningManagerProvider(this.rootConfiguration, this.context).get();
                    }
                    if (manager != null) {
                        try {
                            if (!manager.cancelNumber(IncomingPhoneNumbersEndpoint.convertIncomingPhoneNumbertoPhoneNumber(number))) {
                                this.logger.error((Object)("Number cancelation failed for provided number '" + number.getPhoneNumber() + "'. Number entity " + number.getSid() + " will stay in database"));
                                continue;
                            }
                            dao.removeIncomingPhoneNumber(number.getSid());
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Number cancelation failed for provided number '" + number.getPhoneNumber() + "'"), (Throwable)e);
                        }
                        continue;
                    }
                    this.logger.error((Object)("Number cancelation failed for provided number '" + number.getPhoneNumber() + "'. Provisioning Manager was null. " + "Number entity " + number.getSid() + " will stay in database"));
                    continue;
                }
                dao.removeIncomingPhoneNumber(number.getSid());
            }
        }
    }

    protected Response getAccounts(MediaType responseType) {
        this.checkAuthenticatedAccount();
        this.checkPermission("RestComm:Read:Accounts");
        Account account = this.userIdentityContext.getEffectiveAccount();
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList accounts = new ArrayList();
        accounts.addAll(this.accountsDao.getChildAccounts(account.getSid()));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new AccountList(accounts));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(accounts), (String)"application/json").build();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Response putAccount(MultivaluedMap<String, String> data, MediaType responseType) {
        this.checkAuthenticatedAccount();
        this.checkPermission("RestComm:Create:Accounts");
        List accountLineage = this.userIdentityContext.getEffectiveAccountLineage();
        if (accountLineage.size() >= 2) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.buildErrorResponseBody("This account is not allowed to have sub-accounts", responseType)).type(responseType).build();
        }
        Sid sid = this.userIdentityContext.getEffectiveAccount().getSid();
        Account account = null;
        try {
            account = this.createFrom(sid, data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        catch (PasswordTooWeak passwordTooWeak) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.buildErrorResponseBody("Password too weak", responseType)).type(responseType).build();
        }
        if (this.accountsDao.getAccount(account.getSid()) != null || account.getEmailAddress().equalsIgnoreCase("administrator@company.com")) return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"The email address used for the new account is already in use.").build();
        Account parent = this.accountsDao.getAccount(sid);
        if (!parent.getStatus().equals((Object)Account.Status.ACTIVE) || !this.isSecuredByPermission("RestComm:Create:Accounts")) throw new InsufficientPermission();
        if (!this.hasAccountRole(this.getAdministratorRole()) || !data.containsKey((Object)"Role")) {
            account = account.setRole(parent.getRole());
        }
        this.accountsDao.addAccount(account);
        MultivaluedMapImpl clientData = new MultivaluedMapImpl();
        String username = ((String)data.getFirst((Object)"EmailAddress")).split("@")[0];
        clientData.add((Object)"Login", (Object)username);
        clientData.add((Object)"Password", data.getFirst((Object)"Password"));
        clientData.add((Object)"FriendlyName", (Object)account.getFriendlyName());
        clientData.add((Object)"AccountSid", (Object)account.getSid().toString());
        Client client = this.clientDao.getClient((String)clientData.getFirst((Object)"Login"));
        if (client == null) {
            client = this.createClientFrom(account.getSid(), (MultivaluedMap<String, String>)clientData);
            this.clientDao.addClient(client);
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE != responseType) return null;
        RestCommResponse response = new RestCommResponse((Object)account);
        return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
    }

    private Client createClientFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        Client.Builder builder = Client.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.CLIENT);
        String password = (String)data.getFirst((Object)"Password");
        builder.setSid(sid);
        builder.setAccountSid(accountSid);
        builder.setApiVersion(this.getApiVersion(data));
        builder.setLogin((String)data.getFirst((Object)"Login"));
        builder.setPassword(password);
        builder.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        builder.setStatus(1);
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Clients/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    private Account prepareAccountForUpdate(Account account, MultivaluedMap<String, String> data) throws AccountAlreadyClosed, PasswordTooWeak {
        Account result;
        block13: {
            result = account;
            boolean isPasswordReset = false;
            Account.Status newStatus = null;
            try {
                if (account.getStatus() == Account.Status.CLOSED) {
                    throw new AccountAlreadyClosed();
                }
                if (data.containsKey((Object)"Status") && (newStatus = Account.Status.getValueOf((String)((String)data.getFirst((Object)"Status")).toLowerCase())) == Account.Status.CLOSED) {
                    return account.setStatus(Account.Status.CLOSED);
                }
                if (data.containsKey((Object)"FriendlyName")) {
                    result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
                }
                if (data.containsKey((Object)"Password")) {
                    if (account.getStatus() == Account.Status.UNINITIALIZED) {
                        isPasswordReset = true;
                    }
                    String password = (String)data.getFirst((Object)"Password");
                    PasswordValidator validator = PasswordValidatorFactory.createDefault();
                    if (!validator.isStrongEnough(password)) {
                        throw new PasswordTooWeak();
                    }
                    String hash = new Md5Hash(data.getFirst((Object)"Password")).toString();
                    result = result.setAuthToken(hash);
                }
                if (newStatus != null) {
                    result = result.setStatus(newStatus);
                } else if (isPasswordReset) {
                    result = result.setStatus(Account.Status.ACTIVE);
                }
                if (!data.containsKey((Object)"Role")) break block13;
                Account operatingAccount = this.userIdentityContext.getEffectiveAccount();
                if (this.userIdentityContext.getEffectiveAccountRoles().contains(this.getAdministratorRole())) {
                    result = result.setRole((String)data.getFirst((Object)"Role"));
                    break block13;
                }
                throw new AuthorizationException();
            }
            catch (AccountAlreadyClosed | AuthorizationException | PasswordTooWeak e) {
                throw e;
            }
            catch (Exception e) {
                if (!this.logger.isInfoEnabled()) break block13;
                this.logger.info((Object)("Exception during Account update: " + e.getStackTrace()));
            }
        }
        return result;
    }

    protected Response updateAccount(String identifier, MultivaluedMap<String, String> data, MediaType responseType) {
        Account modifiedAccount;
        Account account;
        block15: {
            this.checkAuthenticatedAccount();
            this.checkPermission("RestComm:Modify:Accounts");
            Sid sid = null;
            account = null;
            try {
                sid = new Sid(identifier);
                account = this.accountsDao.getAccount(sid);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block15;
                this.logger.debug((Object)"At update account, exception trying to get SID. Seems we have email as identifier");
            }
        }
        if (account == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"At update account, trying to get account using email as identifier");
            }
            account = this.accountsDao.getAccount(identifier);
        }
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, "RestComm:Modify:Accounts", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        try {
            modifiedAccount = this.prepareAccountForUpdate(account, data);
        }
        catch (AccountAlreadyClosed accountAlreadyClosed) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (PasswordTooWeak passwordTooWeak) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.buildErrorResponseBody("Password too weak", responseType)).type(responseType).build();
        }
        if (account.getStatus() != Account.Status.CLOSED && modifiedAccount.getStatus() == Account.Status.CLOSED) {
            this.closeAccountTree(modifiedAccount);
            this.accountsDao.updateAccount(modifiedAccount);
        } else {
            String username;
            Client client;
            String email = modifiedAccount.getEmailAddress();
            if (email != null && !email.equals("") && (client = this.clientDao.getClient(username = email.split("@")[0])) != null) {
                if (data.containsKey((Object)"Password")) {
                    String password = (String)data.getFirst((Object)"Password");
                    client = client.setPassword(password);
                }
                if (data.containsKey((Object)"FriendlyName")) {
                    client = client.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
                }
                this.clientDao.updateClient(client);
            }
            this.accountsDao.updateAccount(modifiedAccount);
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)modifiedAccount), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)modifiedAccount);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void closeSingleAccount(Account closedAccount, RcmlserverApi rcmlServerApi) {
        if (rcmlServerApi != null) {
            RcmlserverNotifications notifications = new RcmlserverNotifications();
            notifications.add(rcmlServerApi.buildAccountClosingNotification(closedAccount));
            Account notifier = this.userIdentityContext.getEffectiveAccount();
            try {
                rcmlServerApi.transmitNotifications(notifications, notifier.getSid().toString(), notifier.getAuthToken());
            }
            catch (RcmlserverNotifyError e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.removeAccoundDependencies(closedAccount.getSid());
        closedAccount = closedAccount.setStatus(Account.Status.CLOSED);
        this.accountsDao.updateAccount(closedAccount);
    }

    private void closeAccountTree(Account parentAccount) {
        List subAccountsToClose;
        RestcommConfiguration rcommConfiguration = RestcommConfiguration.getInstance();
        RcmlserverConfigurationSet config = rcommConfiguration.getRcmlserver();
        RcmlserverApi rcmlserverApi = null;
        if (config != null && config.getNotify().booleanValue()) {
            rcmlserverApi = new RcmlserverApi(rcommConfiguration.getMain(), rcommConfiguration.getRcmlserver());
        }
        if ((subAccountsToClose = this.accountsDao.getSubAccountSidsRecursive(parentAccount.getSid())) != null && !subAccountsToClose.isEmpty()) {
            int i = subAccountsToClose.size();
            while (i > 0) {
                String removedSid = (String)subAccountsToClose.get(--i);
                try {
                    Account subAccount = this.accountsDao.getAccount(new Sid(removedSid));
                    this.closeSingleAccount(subAccount, rcmlserverApi);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed removing (child) account '" + removedSid + "'"));
                }
            }
        }
        this.closeSingleAccount(parentAccount, rcmlserverApi);
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"EmailAddress")) {
            throw new NullPointerException("Email address can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
    }
}

