/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.UsageDao;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.dao.entities.Usage;
import org.restcomm.connect.dao.entities.UsageList;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.converter.UsageConverter;
import org.restcomm.connect.http.converter.UsageListConverter;

@ThreadSafe
public abstract class UsageEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected UsageDao dao;
    protected Gson gson;
    protected XStream xstream;
    public static final Pattern relativePattern = Pattern.compile("(\\+|\\-)(\\d+)day[s]");

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getUsageDao();
        UsageConverter converter = new UsageConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Usage.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.disableHtmlEscaping().create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new UsageListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    protected Response getUsage(String accountSid, String subresource, UriInfo info, MediaType responseType) {
        List usage;
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Usage");
        String categoryStr = (String)info.getQueryParameters().getFirst((Object)"Category");
        String startDateStr = (String)info.getQueryParameters().getFirst((Object)"StartDate");
        String endDateStr = (String)info.getQueryParameters().getFirst((Object)"EndDate");
        String reqUri = this.request.getServletPath() + "/" + info.getPath(false);
        Usage.Category category = categoryStr != null ? Usage.Category.valueOf((String)categoryStr) : null;
        DateTime startDate = new DateTime(0L).withTimeAtStartOfDay();
        if (startDateStr != null) {
            try {
                startDate = DateTimeFormat.forPattern((String)"yyyyy-MM-dd").parseDateTime(startDateStr);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        DateTime endDate = new DateTime();
        if (endDateStr != null) {
            try {
                endDate = DateTimeFormat.forPattern((String)"yyyyy-MM-dd").parseDateTime(endDateStr);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if ((usage = subresource.toLowerCase().equals("daily") ? this.dao.getUsageDaily(new Sid(accountSid), category, startDate, endDate, reqUri) : (subresource.toLowerCase().equals("monthly") ? this.dao.getUsageMonthly(new Sid(accountSid), category, startDate, endDate, reqUri) : (subresource.toLowerCase().equals("yearly") ? this.dao.getUsageYearly(new Sid(accountSid), category, startDate, endDate, reqUri) : (subresource.toLowerCase().equals("alltime") ? this.dao.getUsageAllTime(new Sid(accountSid), category, startDate, endDate, reqUri) : (subresource.toLowerCase().equals("today") ? this.dao.getUsageAllTime(new Sid(accountSid), category, DateTime.now(), DateTime.now(), reqUri) : (subresource.toLowerCase().equals("yesterday") ? this.dao.getUsageAllTime(new Sid(accountSid), category, DateTime.now().minusDays(1), DateTime.now().minusDays(1), reqUri) : (subresource.toLowerCase().equals("thismonth") ? this.dao.getUsageAllTime(new Sid(accountSid), category, DateTime.now().dayOfMonth().withMinimumValue(), DateTime.now().dayOfMonth().withMaximumValue(), reqUri) : (subresource.toLowerCase().equals("lastmonth") ? this.dao.getUsageAllTime(new Sid(accountSid), category, DateTime.now().minusMonths(1).dayOfMonth().withMinimumValue(), DateTime.now().minusMonths(1).dayOfMonth().withMaximumValue(), reqUri) : this.dao.getUsageAllTime(new Sid(accountSid), category, startDate, endDate, reqUri))))))))) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)usage), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new UsageList(usage));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }
}

