/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.email.api.Mail;
import org.restcomm.connect.http.converter.AbstractConverter;

public class EmailMessageConverter
extends AbstractConverter
implements JsonSerializer<Mail> {
    public EmailMessageConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Mail.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Mail mailMessage = (Mail)object;
        writer.startNode("EmailMessage");
        this.writeDateSent(mailMessage.dateSent(), writer);
        this.writeAccountSid(new Sid(mailMessage.accountSid()), writer);
        this.writeFrom(mailMessage.from(), writer);
        this.writeTo(mailMessage.to(), writer);
        this.writeBody(mailMessage.body(), writer);
        this.writeSubject(mailMessage.subject().toString(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Mail mailMessage, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeDateSent(mailMessage.dateSent(), object);
        this.writeAccountSid(new Sid(mailMessage.accountSid()), object);
        this.writeFrom(mailMessage.from(), object);
        this.writeTo(mailMessage.to(), object);
        this.writeBody(mailMessage.body(), object);
        this.writeSubject(mailMessage.subject().toString(), object);
        return object;
    }

    private void writeBody(String body, HierarchicalStreamWriter writer) {
        writer.startNode("Body");
        if (body != null) {
            writer.setValue(body);
        }
        writer.endNode();
    }

    private void writeBody(String body, JsonObject object) {
        if (body != null) {
            object.addProperty("body", body);
        } else {
            object.add("body", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeDateSent(DateTime dateSent, HierarchicalStreamWriter writer) {
        writer.startNode("DateSent");
        if (dateSent != null) {
            writer.setValue(dateSent.toString());
        }
        writer.endNode();
    }

    private void writeDateSent(DateTime dateSent, JsonObject object) {
        object.addProperty("date_sent", dateSent != null ? dateSent.toString() : null);
    }

    private void writeSubject(String subject, HierarchicalStreamWriter writer) {
        writer.startNode("Subject");
        writer.setValue(subject);
        writer.endNode();
    }

    private void writeSubject(String subject, JsonObject object) {
        object.addProperty("subject", subject);
    }
}

