/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.RecordingList;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class RecordingListConverter
extends AbstractConverter
implements JsonSerializer<RecordingList> {
    Integer page;
    Integer pageSize;
    Integer total;
    String pathUri;

    public RecordingListConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return RecordingList.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        RecordingList list = (RecordingList)object;
        writer.startNode("Recordings");
        for (Recording recording : list.getRecordings()) {
            context.convertAnother((Object)recording);
        }
        writer.endNode();
    }

    public JsonObject serialize(RecordingList recList, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray array = new JsonArray();
        for (Recording cdr : recList.getRecordings()) {
            array.add(context.serialize((Object)cdr));
        }
        if (this.total != null && this.pageSize != null && this.page != null) {
            result.addProperty("page", (Number)this.page);
            result.addProperty("num_pages", (Number)this.getTotalPages());
            result.addProperty("page_size", (Number)this.pageSize);
            result.addProperty("total", (Number)this.total);
            result.addProperty("start", this.getFirstIndex());
            result.addProperty("end", this.getLastIndex(recList));
            result.addProperty("uri", this.pathUri);
            result.addProperty("first_page_uri", this.getFirstPageUri());
            result.addProperty("previous_page_uri", this.getPreviousPageUri());
            result.addProperty("next_page_uri", this.getNextPageUri(recList));
            result.addProperty("last_page_uri", this.getLastPageUri());
        }
        result.add("recordings", (JsonElement)array);
        return result;
    }

    private int getTotalPages() {
        return this.total / this.pageSize;
    }

    private String getFirstIndex() {
        return String.valueOf(this.page * this.pageSize);
    }

    private String getLastIndex(RecordingList list) {
        return String.valueOf(this.page.intValue() == this.getTotalPages() ? this.page * this.pageSize + list.getRecordings().size() : this.pageSize - 1 + this.page * this.pageSize);
    }

    private String getFirstPageUri() {
        return this.pathUri + "?Page=0&PageSize=" + this.pageSize;
    }

    private String getPreviousPageUri() {
        return this.page == 0 ? "null" : this.pathUri + "?Page=" + (this.page - 1) + "&PageSize=" + this.pageSize;
    }

    private String getNextPageUri(RecordingList list) {
        String lastSid = this.page.intValue() == this.getTotalPages() ? "null" : ((Recording)list.getRecordings().get(this.pageSize - 1)).getSid().toString();
        return this.page.intValue() == this.getTotalPages() ? "null" : this.pathUri + "?Page=" + (this.page + 1) + "&PageSize=" + this.pageSize + "&AfterSid=" + lastSid;
    }

    private String getLastPageUri() {
        return this.pathUri + "?Page=" + this.getTotalPages() + "&PageSize=" + this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        this.total = count;
    }

    public void setPathUri(String pathUri) {
        this.pathUri = pathUri;
    }
}

