/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.GeolocationDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Geolocation;
import org.restcomm.connect.dao.entities.GeolocationList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.ClientListConverter;
import org.restcomm.connect.http.converter.GeolocationConverter;
import org.restcomm.connect.http.converter.GeolocationListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class GeolocationEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected GeolocationDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    private static final Logger logger = Logger.getLogger(GeolocationEndpoint.class);
    private static final String ImmediateGT = Geolocation.GeolocationType.Immediate.toString();
    private static final String NotificationGT = Geolocation.GeolocationType.Notification.toString();
    private String cause;
    private String rStatus;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.dao = storage.getGeolocationDao();
        this.accountsDao = storage.getAccountsDao();
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        GeolocationConverter converter = new GeolocationConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Geolocation.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new ClientListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new GeolocationListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    protected Response getGeolocation(String accountSid, String sid, MediaType responseType) {
        Account account;
        try {
            account = this.accountsDao.getAccount(accountSid);
            this.secure(account, "RestComm:Read:Geolocation");
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Geolocation geolocation = null;
        if (Sid.pattern.matcher(sid).matches()) {
            geolocation = this.dao.getGeolocation(new Sid(sid));
        }
        if (geolocation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.secure(account, geolocation.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)geolocation);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)geolocation), (String)"application/json").build();
        }
        return null;
    }

    protected Response getGeolocations(String accountSid, MediaType responseType) {
        try {
            Account account = this.accountsDao.getAccount(accountSid);
            this.secure(account, "RestComm:Read:Geolocation", SecuredEndpoint.SecuredType.SECURED_APP);
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List geolocations = this.dao.getGeolocations(new Sid(accountSid));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new GeolocationList(geolocations));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)geolocations), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteGeolocation(String accountSid, String sid) {
        try {
            Account account = this.accountsDao.getAccount(accountSid);
            this.secure(account, "RestComm:Delete:Geolocation");
            Geolocation geolocation = this.dao.getGeolocation(new Sid(sid));
            if (geolocation != null) {
                this.secure(account, geolocation.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
            }
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dao.removeGeolocation(new Sid(sid));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response putGeolocation(String accountSid, MultivaluedMap<String, String> data, Geolocation.GeolocationType geolocationType, MediaType responseType) {
        RestCommResponse response;
        block29: {
            try {
                Account account = this.accountsDao.getAccount(accountSid);
                this.secure(account, "RestComm:Create:Geolocation", SecuredEndpoint.SecuredType.SECURED_APP);
            }
            catch (Exception exception) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            try {
                this.validate(data, geolocationType);
            }
            catch (NullPointerException nullPointerException) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)nullPointerException.getMessage()).build();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.cause = illegalArgumentException.getMessage();
                this.rStatus = responseStatus.Failed.toString();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unsupportedOperationException.getMessage()).build();
            }
            try {
                String targetMSISDN = (String)data.getFirst((Object)"DeviceIdentifier");
                Configuration gmlcConf = this.configuration.subset("gmlc");
                String gmlcURI = gmlcConf.getString("gmlc-uri");
                String gmlcUser = gmlcConf.getString("gmlc-user");
                String gmlcPassword = gmlcConf.getString("gmlc-password");
                URL url = new URL(gmlcURI + targetMSISDN);
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpGet request = new HttpGet(String.valueOf(url));
                request.addHeader("User-Agent", gmlcUser);
                request.addHeader("User-Password", gmlcPassword);
                HttpResponse response2 = client.execute((HttpUriRequest)request);
                HttpEntity entity = response2.getEntity();
                if (entity == null) break block29;
                try (InputStream stream = entity.getContent();){
                    BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                    String gmlcResponse = null;
                    while (null != (gmlcResponse = br.readLine())) {
                        List<String> items = Arrays.asList(gmlcResponse.split("\\s*,\\s*"));
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Data retrieved from GMLC: " + items.toString()));
                        }
                        for (String item : items) {
                            for (int i = 0; i < items.size(); ++i) {
                                String token;
                                if (item.contains("mcc")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"MobileCountryCode", (Object)token);
                                }
                                if (item.contains("mnc")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"MobileNetworkCode", (Object)token);
                                }
                                if (item.contains("lac")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"LocationAreaCode", (Object)token);
                                }
                                if (item.contains("cellid")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"CellId", (Object)token);
                                }
                                if (item.contains("aol")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"LocationAge", (Object)token);
                                }
                                if (item.contains("vlrNumber")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"NetworkEntityAddress", (Object)token);
                                }
                                if (item.contains("latitude")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"DeviceLatitude", (Object)token);
                                }
                                if (item.contains("longitude")) {
                                    token = item.substring(item.lastIndexOf("=") + 1);
                                    data.putSingle((Object)"DeviceLongitude", (Object)token);
                                }
                                if (!item.contains("civicAddress")) continue;
                                token = item.substring(item.lastIndexOf("=") + 1);
                                data.putSingle((Object)"FormattedAddress", (Object)token);
                            }
                        }
                        if (gmlcURI == null || gmlcResponse == null || !logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Geolocation data of " + targetMSISDN + " retrieved from GMCL at: " + gmlcURI));
                        logger.debug((Object)("MCC (Mobile Country Code) = " + this.getInteger("MobileCountryCode", data)));
                        logger.debug((Object)("MNC (Mobile Network Code) = " + (String)data.getFirst((Object)"MobileNetworkCode")));
                        logger.debug((Object)("LAC (Location Area Code) = " + (String)data.getFirst((Object)"LocationAreaCode")));
                        logger.debug((Object)("CI (Cell ID) = " + (String)data.getFirst((Object)"CellId")));
                        logger.debug((Object)("AOL (Age of Location) = " + this.getInteger("LocationAge", data)));
                        logger.debug((Object)("NNN (Network Node Number/Address) = " + this.getLong("NetworkEntityAddress", data)));
                        logger.debug((Object)("Devide Latitude = " + (String)data.getFirst((Object)"DeviceLatitude")));
                        logger.debug((Object)("Devide Longitude = " + (String)data.getFirst((Object)"DeviceLongitude")));
                        logger.debug((Object)("Civic Address = " + (String)data.getFirst((Object)"FormattedAddress")));
                    }
                }
            }
            catch (Exception ex) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Problem while trying to retrieve data from GMLC");
                }
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
            }
        }
        Geolocation geolocation = this.createFrom(new Sid(accountSid), data, geolocationType);
        if (geolocation.getResponseStatus() != null && geolocation.getResponseStatus().equals(responseStatus.Rejected.toString())) {
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                response = new RestCommResponse((Object)geolocation);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                return Response.ok((Object)this.gson.toJson((Object)geolocation), (String)"application/json").build();
            }
            return null;
        }
        this.dao.addGeolocation(geolocation);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            response = new RestCommResponse((Object)geolocation);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)geolocation), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data, Geolocation.GeolocationType glType) throws RuntimeException {
        String eventGeofenceLong;
        String eventGeofenceLat;
        Boolean eventGeofenceLongWGS84;
        String geofenceEvent;
        String deviceLong;
        Boolean devLongWGS84;
        String deviceLat;
        Boolean devLatWGS84;
        String desiredAccuracy;
        if (!glType.toString().equals(ImmediateGT) && !glType.toString().equals(NotificationGT)) {
            throw new NullPointerException("Geolocation Type can not be null, but either \"Immediate\" or \"Notification\".");
        }
        if (!data.containsKey((Object)"DeviceIdentifier")) {
            throw new NullPointerException("DeviceIdentifier value can not be null");
        }
        if (!data.containsKey((Object)"StatusCallback")) {
            throw new NullPointerException("StatusCallback value can not be null");
        }
        if (data.containsKey((Object)"DesiredAccuracy") && !(desiredAccuracy = (String)data.getFirst((Object)"DesiredAccuracy")).equalsIgnoreCase("High") && !desiredAccuracy.equalsIgnoreCase("Average") && !desiredAccuracy.equalsIgnoreCase("Low")) {
            throw new IllegalArgumentException("DesiredAccuracy value not API compliant");
        }
        if (data.containsKey((Object)"DeviceLatitude") && !(devLatWGS84 = Boolean.valueOf(this.validateGeoCoordinatesFormat(deviceLat = (String)data.getFirst((Object)"DeviceLatitude")))).booleanValue()) {
            throw new IllegalArgumentException("DeviceLatitude not API compliant");
        }
        if (data.containsKey((Object)"DeviceLongitude") && !(devLongWGS84 = Boolean.valueOf(this.validateGeoCoordinatesFormat(deviceLong = (String)data.getFirst((Object)"DeviceLongitude")))).booleanValue()) {
            throw new IllegalArgumentException("DeviceLongitude not API compliant");
        }
        if (!data.containsKey((Object)"GeofenceEvent") && glType.toString().equals(NotificationGT)) {
            throw new NullPointerException("GeofenceEvent value con not be null for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"GeofenceEvent") && !glType.toString().equals(NotificationGT)) {
            throw new UnsupportedOperationException("GeofenceEvent only applies for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"GeofenceEvent") && glType.toString().equals(NotificationGT) && !(geofenceEvent = (String)data.getFirst((Object)"GeofenceEvent")).equalsIgnoreCase("in") && !geofenceEvent.equalsIgnoreCase("out") && !geofenceEvent.equalsIgnoreCase("in-out")) {
            throw new IllegalArgumentException("GeofenceEvent value not API compliant");
        }
        if (!data.containsKey((Object)"EventGeofenceLatitude") && glType.toString().equals(NotificationGT)) {
            throw new NullPointerException("EventGeofenceLatitude value con not be null for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"EventGeofenceLatitude") && !glType.toString().equals(NotificationGT)) {
            throw new UnsupportedOperationException("EventGeofenceLatitude only applies for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"EventGeofenceLatitude") && glType.toString().equals(NotificationGT) && !(eventGeofenceLongWGS84 = Boolean.valueOf(this.validateGeoCoordinatesFormat(eventGeofenceLat = (String)data.getFirst((Object)"EventGeofenceLatitude")))).booleanValue()) {
            throw new IllegalArgumentException("EventGeofenceLatitude format not API compliant");
        }
        if (!data.containsKey((Object)"EventGeofenceLongitude") && glType.toString().equals(NotificationGT)) {
            throw new NullPointerException("EventGeofenceLongitude value con not be null for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"EventGeofenceLongitude") && !glType.toString().equals(NotificationGT)) {
            throw new UnsupportedOperationException("EventGeofenceLongitude only applies for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"EventGeofenceLongitude") && glType.toString().equals(NotificationGT) && !(eventGeofenceLongWGS84 = Boolean.valueOf(this.validateGeoCoordinatesFormat(eventGeofenceLong = (String)data.getFirst((Object)"EventGeofenceLongitude")))).booleanValue()) {
            throw new IllegalArgumentException("EventGeofenceLongitude format not API compliant");
        }
        if (!data.containsKey((Object)"GeofenceRange") && glType.toString().equals(NotificationGT)) {
            throw new NullPointerException("GeofenceRange value con not be null for Notification type of Geolocation");
        }
        if (data.containsKey((Object)"GeofenceRange") && !glType.toString().equals(NotificationGT)) {
            throw new UnsupportedOperationException("GeofenceRange only applies for Notification type of Geolocation");
        }
        try {
            if (data.containsKey((Object)"LocationTimestamp")) {
                DateTime locationTimestamp = this.getDateTime("LocationTimestamp", data);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("LocationTimestamp value is not API compliant");
        }
    }

    private Geolocation createFrom(Sid accountSid, MultivaluedMap<String, String> data, Geolocation.GeolocationType glType) {
        if (this.rStatus != null && this.rStatus.equals(responseStatus.Failed.toString())) {
            Geolocation gl = this.buildFailedGeolocation(accountSid, data, glType);
            return gl;
        }
        Geolocation gl = this.buildGeolocation(accountSid, data, glType);
        return gl;
    }

    private Geolocation buildGeolocation(Sid accountSid, MultivaluedMap<String, String> data, Geolocation.GeolocationType glType) {
        Geolocation.Builder builder = Geolocation.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.GEOLOCATION);
        String geoloctype = glType.toString();
        builder.setSid(sid);
        DateTime currentDateTime = DateTime.now();
        builder.setDateUpdated(currentDateTime);
        builder.setAccountSid(accountSid);
        builder.setSource((String)data.getFirst((Object)"Source"));
        builder.setDeviceIdentifier((String)data.getFirst((Object)"DeviceIdentifier"));
        builder.setGeolocationType(glType);
        builder.setResponseStatus((String)data.getFirst((Object)"ResponseStatus"));
        builder.setCause((String)data.getFirst((Object)"Cause"));
        builder.setCellId((String)data.getFirst((Object)"CellId"));
        builder.setLocationAreaCode((String)data.getFirst((Object)"LocationAreaCode"));
        builder.setMobileCountryCode(this.getInteger("MobileCountryCode", data));
        builder.setMobileNetworkCode((String)data.getFirst((Object)"MobileNetworkCode"));
        builder.setNetworkEntityAddress(this.getLong("NetworkEntityAddress", data));
        builder.setAgeOfLocationInfo(this.getInteger("LocationAge", data));
        builder.setDeviceLatitude((String)data.getFirst((Object)"DeviceLatitude"));
        builder.setDeviceLongitude((String)data.getFirst((Object)"DeviceLongitude"));
        builder.setAccuracy(this.getLong("Accuracy", data));
        builder.setPhysicalAddress((String)data.getFirst((Object)"PhysicalAddress"));
        builder.setInternetAddress((String)data.getFirst((Object)"InternetAddress"));
        builder.setFormattedAddress((String)data.getFirst((Object)"FormattedAddress"));
        builder.setLocationTimestamp(this.getDateTime("LocationTimestamp", data));
        builder.setEventGeofenceLatitude((String)data.getFirst((Object)"EventGeofenceLatitude"));
        builder.setEventGeofenceLongitude((String)data.getFirst((Object)"EventGeofenceLongitude"));
        builder.setRadius(this.getLong("Radius", data));
        builder.setGeolocationPositioningType((String)data.getFirst((Object)"GeolocationPositioningType"));
        builder.setLastGeolocationResponse((String)data.getFirst((Object)"LastGeolocationResponse"));
        builder.setApiVersion(this.getApiVersion(data));
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Geolocation/" + geoloctype + "/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    private Geolocation buildFailedGeolocation(Sid accountSid, MultivaluedMap<String, String> data, Geolocation.GeolocationType glType) {
        Geolocation.Builder builder = Geolocation.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.GEOLOCATION);
        String geoloctype = glType.toString();
        builder.setSid(sid);
        DateTime currentDateTime = DateTime.now();
        builder.setDateUpdated(currentDateTime);
        builder.setAccountSid(accountSid);
        builder.setSource((String)data.getFirst((Object)"Source"));
        builder.setDeviceIdentifier((String)data.getFirst((Object)"DeviceIdentifier"));
        builder.setResponseStatus(this.rStatus);
        builder.setGeolocationType(glType);
        builder.setCause(this.cause);
        builder.setApiVersion(this.getApiVersion(data));
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Geolocation/" + geoloctype + "/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    protected Response updateGeolocation(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account account;
        try {
            account = this.accountsDao.getAccount(accountSid);
            this.secure(account, "RestComm:Modify:Geolocation");
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Geolocation geolocation = this.dao.getGeolocation(new Sid(sid));
        if (geolocation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.secure(account, geolocation.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        geolocation = this.update(geolocation, data);
        this.dao.updateGeolocation(geolocation);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)geolocation);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)geolocation), (String)"application/json").build();
        }
        return null;
    }

    private Geolocation update(Geolocation geolocation, MultivaluedMap<String, String> data) {
        Geolocation updatedGeolocation = geolocation;
        if (data.containsKey((Object)"Source")) {
            updatedGeolocation = updatedGeolocation.setSource((String)data.getFirst((Object)"Source"));
        }
        if (data.containsKey((Object)"DeviceIdentifier")) {
            updatedGeolocation = updatedGeolocation.setDeviceIdentifier((String)data.getFirst((Object)"DeviceIdentifier"));
        }
        if (data.containsKey((Object)"ResponseStatus")) {
            updatedGeolocation = updatedGeolocation.setResponseStatus((String)data.getFirst((Object)"ResponseStatus"));
            updatedGeolocation = updatedGeolocation.setDateUpdated(DateTime.now());
            if (data.containsKey((Object)"Cause") && (updatedGeolocation.getResponseStatus().equals(responseStatus.Rejected.toString()) || updatedGeolocation.getResponseStatus().equals(responseStatus.Unauthorized.toString()) || updatedGeolocation.getResponseStatus().equals(responseStatus.Failed.toString()))) {
                updatedGeolocation = updatedGeolocation.setCause((String)data.getFirst((Object)"Cause"));
            }
            if (!(updatedGeolocation.getResponseStatus().equals(responseStatus.Rejected.toString()) && updatedGeolocation.getResponseStatus().equals(responseStatus.Unauthorized.toString()) && updatedGeolocation.getResponseStatus().equals(responseStatus.Failed.toString()))) {
                updatedGeolocation = updatedGeolocation.setCause(null);
            }
        }
        if (!(updatedGeolocation.getResponseStatus() == null || updatedGeolocation.getResponseStatus().equals(responseStatus.Unauthorized.toString()) && updatedGeolocation.getResponseStatus().equals(responseStatus.Failed.toString()))) {
            updatedGeolocation = updatedGeolocation.setCause(null);
        }
        if (data.containsKey((Object)"CellId")) {
            updatedGeolocation = updatedGeolocation.setCellId((String)data.getFirst((Object)"CellId"));
        }
        if (data.containsKey((Object)"LocationAreaCode")) {
            updatedGeolocation = updatedGeolocation.setLocationAreaCode((String)data.getFirst((Object)"LocationAreaCode"));
        }
        if (data.containsKey((Object)"MobileCountryCode")) {
            updatedGeolocation = updatedGeolocation.setMobileCountryCode(this.getInteger("MobileCountryCode", data));
        }
        if (data.containsKey((Object)"MobileNetworkCode")) {
            updatedGeolocation = updatedGeolocation.setMobileNetworkCode((String)data.getFirst((Object)"MobileNetworkCode"));
        }
        if (data.containsKey((Object)"NetworkEntityAddress")) {
            updatedGeolocation = updatedGeolocation.setNetworkEntityAddress(this.getLong("NetworkEntityAddress", data));
        }
        if (data.containsKey((Object)"LocationAge")) {
            updatedGeolocation = updatedGeolocation.setAgeOfLocationInfo(this.getInteger("LocationAge", data));
        }
        if (data.containsKey((Object)"DeviceLatitude")) {
            String deviceLat = (String)data.getFirst((Object)"DeviceLatitude");
            Boolean deviceLatWGS84 = this.validateGeoCoordinatesFormat(deviceLat);
            if (!deviceLatWGS84.booleanValue()) {
                return this.buildFailedGeolocationUpdate(geolocation, data, geolocation.getGeolocationType(), responseStatus.Failed.toString(), "DeviceLatitude format not API compliant");
            }
            updatedGeolocation = updatedGeolocation.setDeviceLatitude(deviceLat);
        }
        if (data.containsKey((Object)"DeviceLongitude")) {
            updatedGeolocation = updatedGeolocation.setDeviceLongitude((String)data.getFirst((Object)"DeviceLongitude"));
            String deviceLong = (String)data.getFirst((Object)"DeviceLongitude");
            Boolean deviceLongGS84 = this.validateGeoCoordinatesFormat(deviceLong);
            if (!deviceLongGS84.booleanValue()) {
                return this.buildFailedGeolocationUpdate(geolocation, data, geolocation.getGeolocationType(), responseStatus.Failed.toString(), "DeviceLongitude format not API compliant");
            }
            updatedGeolocation = updatedGeolocation.setDeviceLongitude(deviceLong);
        }
        if (data.containsKey((Object)"Accuracy")) {
            updatedGeolocation = updatedGeolocation.setAccuracy(this.getLong("Accuracy", data));
        }
        if (data.containsKey((Object)"PhysicalAddress")) {
            updatedGeolocation = updatedGeolocation.setPhysicalAddress((String)data.getFirst((Object)"PhysicalAddress"));
        }
        if (data.containsKey((Object)"InternetAddress")) {
            updatedGeolocation = updatedGeolocation.setInternetAddress((String)data.getFirst((Object)"InternetAddress"));
        }
        if (data.containsKey((Object)"FormattedAddress")) {
            updatedGeolocation = updatedGeolocation.setFormattedAddress((String)data.getFirst((Object)"FormattedAddress"));
        }
        if (data.containsKey((Object)"LocationTimestamp")) {
            updatedGeolocation = updatedGeolocation.setLocationTimestamp(this.getDateTime("LocationTimestamp", data));
        }
        if (data.containsKey((Object)"EventGeofenceLatitude") && geolocation.getGeolocationType().toString().equals(NotificationGT)) {
            String eventGeofenceLat = (String)data.getFirst((Object)"EventGeofenceLatitude");
            Boolean eventGeofenceLatWGS84 = this.validateGeoCoordinatesFormat(eventGeofenceLat);
            if (!eventGeofenceLatWGS84.booleanValue()) {
                return this.buildFailedGeolocationUpdate(geolocation, data, geolocation.getGeolocationType(), responseStatus.Failed.toString(), "EventGeofenceLatitude format not API compliant");
            }
            updatedGeolocation = updatedGeolocation.setEventGeofenceLatitude(eventGeofenceLat);
        }
        if (data.containsKey((Object)"EventGeofenceLongitude") && geolocation.getGeolocationType().toString().equals(NotificationGT)) {
            String eventGeofenceLong = (String)data.getFirst((Object)"EventGeofenceLongitude");
            Boolean eventGeofenceLongWGS84 = this.validateGeoCoordinatesFormat(eventGeofenceLong);
            if (!eventGeofenceLongWGS84.booleanValue()) {
                return this.buildFailedGeolocationUpdate(geolocation, data, geolocation.getGeolocationType(), responseStatus.Failed.toString(), "EventGeofenceLongitude format not API compliant");
            }
            updatedGeolocation = updatedGeolocation.setEventGeofenceLongitude(eventGeofenceLong);
        }
        if (data.containsKey((Object)"Radius") && geolocation.getGeolocationType().toString().equals(NotificationGT)) {
            updatedGeolocation = updatedGeolocation.setRadius(this.getLong("Radius", data));
        }
        if (data.containsKey((Object)"GeolocationPositioningType")) {
            updatedGeolocation = updatedGeolocation.setGeolocationPositioningType((String)data.getFirst((Object)"GeolocationPositioningType"));
        }
        if (data.containsKey((Object)"LastGeolocationResponse")) {
            updatedGeolocation = updatedGeolocation.setLastGeolocationResponse((String)data.getFirst((Object)"LastGeolocationResponse"));
        }
        DateTime thisDateTime = DateTime.now();
        updatedGeolocation = updatedGeolocation.setDateUpdated(thisDateTime);
        return updatedGeolocation;
    }

    private Geolocation buildFailedGeolocationUpdate(Geolocation geolocation, MultivaluedMap<String, String> data, Geolocation.GeolocationType glType, String responseStatus2, String wrongUpdateCause) {
        Sid accountSid = geolocation.getAccountSid();
        Sid sid = geolocation.getSid();
        Geolocation.Builder builder = Geolocation.builder();
        String geoloctype = glType.toString();
        DateTime currentDateTime = DateTime.now();
        builder.setSid(sid);
        builder.setDateUpdated(currentDateTime);
        builder.setAccountSid(accountSid);
        builder.setResponseStatus(responseStatus2);
        builder.setCause(wrongUpdateCause);
        builder.setSource((String)data.getFirst((Object)"Source"));
        builder.setDeviceIdentifier((String)data.getFirst((Object)"DeviceIdentifier"));
        builder.setGeolocationType(glType);
        builder.setApiVersion(this.getApiVersion(data));
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Geolocation/" + geoloctype + "/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    private boolean validateGeoCoordinatesFormat(String coordinates) {
        String degrees = "\\u00b0";
        String minutes = "'";
        Boolean pattern1 = coordinates.matches("[NWSE]{1}\\d{1,3}\\s\\d{1,2}\\s\\d{1,2}\\.\\d{1,2}$");
        Boolean pattern2 = coordinates.matches("\\d{1,3}\\s\\d{1,2}\\s\\d{1,2}\\.\\d{1,2}[NWSE]{1}$");
        Boolean pattern3 = coordinates.matches("\\d{1,3}[" + degrees + "]\\d{1,3}[" + minutes + "]\\d{1,2}\\.\\d{1,2}[" + minutes + "][" + minutes + "][NWSE]{1}$");
        Boolean pattern4 = coordinates.matches("[NWSE]{1}\\d{1,3}[" + degrees + "]\\d{1,3}[" + minutes + "]\\d{1,2}\\.\\d{1,2}[" + minutes + "][" + minutes + "]$");
        Boolean pattern5 = coordinates.matches("\\d{1,3}\\s\\d{1,2}\\s\\d{1,2}\\.\\d{1,2}$");
        Boolean pattern6 = coordinates.matches("-?\\d{1,3}\\s\\d{1,2}\\s\\d{1,2}\\.\\d{1,2}$");
        Boolean pattern7 = coordinates.matches("-?\\d+(\\.\\d+)?");
        if (pattern1.booleanValue() || pattern2.booleanValue() || pattern3.booleanValue() || pattern4.booleanValue() || pattern5.booleanValue() || pattern6.booleanValue() || pattern7.booleanValue()) {
            Boolean WGS84_validation = true;
            return WGS84_validation;
        }
        Boolean WGS84_validation = false;
        return WGS84_validation;
    }

    private static enum responseStatus {
        Queued("queued"),
        Sent("sent"),
        Processing("processing"),
        Successful("successful"),
        PartiallySuccessful("partially-successful"),
        LastKnown("last-known"),
        Failed("failed"),
        Unauthorized("unauthorized"),
        Rejected("rejected");

        private final String rs;

        private responseStatus(String rs) {
            this.rs = rs;
        }

        public String toString() {
            return this.rs;
        }
    }
}

