/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.math.BigDecimal;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.dao.entities.SmsMessage;
import org.restcomm.connect.dao.entities.SmsMessageFilter;
import org.restcomm.connect.dao.entities.SmsMessageList;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.converter.SmsMessageConverter;
import org.restcomm.connect.http.converter.SmsMessageListConverter;
import org.restcomm.connect.sms.api.CreateSmsSession;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionAttribute;
import org.restcomm.connect.sms.api.SmsSessionInfo;
import org.restcomm.connect.sms.api.SmsSessionRequest;
import org.restcomm.connect.sms.api.SmsSessionResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class SmsMessagesEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected ActorSystem system;
    protected Configuration configuration;
    protected ActorRef aggregator;
    protected SmsMessagesDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected SmsMessageListConverter listConverter;
    protected String instanceId;
    private boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.dao = storage.getSmsMessagesDao();
        this.aggregator = (ActorRef)this.context.getAttribute("org.restcomm.connect.sms.SmsService");
        this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
        super.init(this.configuration);
        SmsMessageConverter converter = new SmsMessageConverter(this.configuration);
        this.listConverter = new SmsMessageListConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SmsMessage.class, (Object)converter);
        builder.registerTypeAdapter(SmsMessageList.class, (Object)this.listConverter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new SmsMessageListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
    }

    protected Response getSmsMessage(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:SmsMessages");
        SmsMessage smsMessage = this.dao.getSmsMessage(new Sid(sid));
        if (smsMessage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, smsMessage.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)smsMessage), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)smsMessage);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getSmsMessages(String accountSid, UriInfo info, MediaType responseType) {
        SmsMessageFilter filter;
        SmsMessageFilter filterForTotal;
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:SmsMessages");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean querySubAccounts = false;
        String querySubAccountsParam = (String)info.getQueryParameters().getFirst((Object)"SubAccounts");
        if (querySubAccountsParam != null && querySubAccountsParam.equalsIgnoreCase("true")) {
            querySubAccounts = true;
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String recipient = (String)info.getQueryParameters().getFirst((Object)"To");
        String sender = (String)info.getQueryParameters().getFirst((Object)"From");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String endTime = (String)info.getQueryParameters().getFirst((Object)"EndTime");
        String body = (String)info.getQueryParameters().getFirst((Object)"Body");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page.equals("0") ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        ArrayList<String> ownerAccounts = null;
        if (querySubAccounts) {
            ownerAccounts = new ArrayList<String>();
            ownerAccounts.add(accountSid);
            ownerAccounts.addAll(this.accountsDao.getSubAccountSidsRecursive(new Sid(accountSid)));
        }
        try {
            filterForTotal = localInstanceOnly ? new SmsMessageFilter(accountSid, ownerAccounts, recipient, sender, startTime, endTime, body, null, null) : new SmsMessageFilter(accountSid, ownerAccounts, recipient, sender, startTime, endTime, body, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = this.dao.getTotalSmsMessage(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new SmsMessageFilter(accountSid, ownerAccounts, recipient, sender, startTime, endTime, body, Integer.valueOf(limit), Integer.valueOf(offset)) : new SmsMessageFilter(accountSid, ownerAccounts, recipient, sender, startTime, endTime, body, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = this.dao.getSmsMessages(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new SmsMessageList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new SmsMessageList(cdrs)), (String)"application/json").build();
        }
        return null;
    }

    private void normalize(MultivaluedMap<String, String> data) throws IllegalArgumentException {
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String from = (String)data.getFirst((Object)"From");
        data.remove((Object)"From");
        try {
            data.putSingle((Object)"From", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(from, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
        }
        catch (NumberParseException exception) {
            throw new IllegalArgumentException(exception);
        }
        String to = (String)data.getFirst((Object)"To");
        data.remove((Object)"To");
        try {
            data.putSingle((Object)"To", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
        }
        catch (NumberParseException exception) {
            throw new IllegalArgumentException(exception);
        }
        String body = (String)data.getFirst((Object)"Body");
        if (body.getBytes().length > 160) {
            data.remove((Object)"Body");
            data.putSingle((Object)"Body", (Object)body.substring(0, 159));
        }
    }

    protected Response putSmsMessage(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:SmsMessages");
        try {
            this.validate(data);
            if (this.normalizePhoneNumbers) {
                this.normalize(data);
            }
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String sender = (String)data.getFirst((Object)"From");
        String recipient = (String)data.getFirst((Object)"To");
        String body = (String)data.getFirst((Object)"Body");
        SmsSessionRequest.Encoding encoding = !data.containsKey((Object)"Encoding") ? SmsSessionRequest.Encoding.UCS_2 : SmsSessionRequest.Encoding.valueOf((String)((String)data.getFirst((Object)"Encoding")).replace('-', '_'));
        ConcurrentHashMap<String, Object> customRestOutgoingHeaderMap = new ConcurrentHashMap<String, Object>();
        for (String name : data.keySet()) {
            if (!name.startsWith("X-")) continue;
            customRestOutgoingHeaderMap.put(name, data.getFirst((Object)name));
        }
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        try {
            Future future = Patterns.ask((ActorRef)this.aggregator, (Object)new CreateSmsSession(sender, recipient, accountSid, true), (Timeout)expires);
            Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            Class<?> klass = object.getClass();
            if (SmsServiceResponse.class.equals(klass)) {
                SmsServiceResponse smsServiceResponse = (SmsServiceResponse)object;
                if (smsServiceResponse.succeeded()) {
                    SmsMessage record = this.sms(new Sid(accountSid), this.getApiVersion(data), sender, recipient, body, SmsMessage.Status.SENDING, SmsMessage.Direction.OUTBOUND_API);
                    this.dao.addSmsMessage(record);
                    ActorRef session = (ActorRef)smsServiceResponse.get();
                    ActorRef observer = this.observer();
                    session.tell((Object)new Observe(observer), observer);
                    session.tell((Object)new SmsSessionAttribute("record", (Object)record), null);
                    SmsSessionRequest request = new SmsSessionRequest(sender, recipient, body, encoding, customRestOutgoingHeaderMap);
                    session.tell((Object)request, null);
                    if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                        return Response.ok((Object)this.gson.toJson((Object)record), (String)"application/json").build();
                    }
                    if (MediaType.APPLICATION_XML_TYPE == responseType) {
                        RestCommResponse response = new RestCommResponse((Object)record);
                        return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
                    }
                    return null;
                }
                String msg = smsServiceResponse.cause().getMessage();
                String error = "SMS_LIMIT_EXCEEDED";
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.buildErrorResponseBody(msg, error, responseType)).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    private SmsMessage sms(Sid accountSid, String apiVersion, String sender, String recipient, String body, SmsMessage.Status status, SmsMessage.Direction direction) {
        SmsMessage.Builder builder = SmsMessage.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
        builder.setSid(sid);
        builder.setAccountSid(accountSid);
        builder.setSender(sender);
        builder.setRecipient(recipient);
        builder.setBody(body);
        builder.setStatus(status);
        builder.setDirection(direction);
        builder.setPrice(new BigDecimal(0.0));
        builder.setPriceUnit(Currency.getInstance("USD"));
        builder.setApiVersion(apiVersion);
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(apiVersion).append("/Accounts/");
        buffer.append(accountSid.toString()).append("/SMS/Messages/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Body")) {
            throw new NullPointerException("Body can not be null.");
        }
    }

    private ActorRef observer() {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsSessionObserver();
            }
        });
        return this.system.actorOf(props);
    }

    private final class SmsSessionObserver
    extends UntypedActor {
        public void onReceive(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (SmsSessionResponse.class.equals(klass)) {
                SmsSessionResponse response = (SmsSessionResponse)message;
                SmsSessionInfo info = response.info();
                SmsMessage record = (SmsMessage)info.attributes().get("record");
                if (response.succeeded()) {
                    DateTime now = DateTime.now();
                    record = record.setDateSent(now);
                    record = record.setStatus(SmsMessage.Status.SENT);
                } else {
                    record = record.setStatus(SmsMessage.Status.FAILED);
                }
                SmsMessagesEndpoint.this.dao.updateSmsMessage(record);
                UntypedActorContext context = this.getContext();
                ActorRef self = this.self();
                context.stop(self);
            }
        }
    }
}

