/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.cache.DiskCacheFactory;
import org.restcomm.connect.commons.cache.DiskCacheRequest;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Announcement;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.AnnouncementConverter;
import org.restcomm.connect.http.converter.AnnouncementListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.tts.api.SpeechSynthesizerRequest;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public abstract class AnnouncementsEndpoint
extends SecuredEndpoint {
    private static Logger logger = Logger.getLogger(AnnouncementsEndpoint.class);
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected Configuration runtime;
    protected ActorRef synthesizer;
    protected ActorRef cache;
    protected Gson gson;
    protected XStream xstream;
    private URI uri;
    private ActorSystem system;

    @PostConstruct
    public void init() {
        this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        Configuration ttsConfiguration = this.configuration.subset("speech-synthesizer");
        this.runtime = this.configuration.subset("runtime-settings");
        this.synthesizer = this.tts(ttsConfiguration);
        super.init(this.runtime);
        AnnouncementConverter converter = new AnnouncementConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Announcement.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new AnnouncementListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    public Response putAnnouncement(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) throws Exception {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:Announcements");
        if (this.cache == null) {
            this.createCacheActor(accountSid);
        }
        Announcement announcement = this.createFrom(accountSid, data);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)announcement), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)announcement);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void createCacheActor(String accountId) {
        String path = this.runtime.getString("cache-path");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + accountId.toString();
        String uri = this.runtime.getString("cache-uri");
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + accountId.toString();
        this.cache = this.cache(path, uri);
    }

    private void precache(String text, String gender, String language) throws Exception {
        Timeout expires;
        SpeechSynthesizerRequest synthesize;
        Future future;
        Object object;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Synthesizing announcement");
        }
        if ((object = Await.result((Awaitable)(future = Patterns.ask((ActorRef)this.synthesizer, (Object)(synthesize = new SpeechSynthesizerRequest(gender, language, text)), (Timeout)(expires = new Timeout(Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS))))), (Duration)Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS))) != null) {
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)object;
            this.uri = (URI)response.get();
        }
        DiskCacheRequest request = new DiskCacheRequest(this.uri);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Caching announcement");
        }
        this.cache.tell((Object)request, null);
    }

    private Announcement createFrom(String accountSid, MultivaluedMap<String, String> data) throws Exception {
        String text;
        String language;
        Sid sid = Sid.generate((Sid.Type)Sid.Type.ANNOUNCEMENT);
        String gender = (String)data.getFirst((Object)"Gender");
        if (gender == null) {
            gender = "man";
        }
        if ((language = (String)data.getFirst((Object)"Language")) == null) {
            language = "en";
        }
        if ((text = (String)data.getFirst((Object)"Text")) != null) {
            this.precache(text, gender, language);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Creating annnouncement");
        }
        Announcement announcement = new Announcement(sid, new Sid(accountSid), gender, language, text, this.uri);
        return announcement;
    }

    private ActorRef tts(final Configuration configuration) {
        final String classpath = configuration.getString("[@class]");
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return (UntypedActor)Class.forName(classpath).getConstructor(Configuration.class).newInstance(configuration);
            }
        });
        return this.system.actorOf(props);
    }

    private ActorRef cache(final String path, final String uri) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new DiskCacheFactory(AnnouncementsEndpoint.this.configuration).getDiskCache(path, uri);
            }
        });
        return this.system.actorOf(props);
    }

    @PreDestroy
    private void cleanup() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Stopping actors before endpoint destroy");
        }
        this.system.stop(this.cache);
        this.system.stop(this.synthesizer);
    }
}

