/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.ExtensionsConfigurationDao;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.extension.api.ConfigurationException;
import org.restcomm.connect.extension.api.ExtensionConfiguration;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.ExtensionConfigurationConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.exceptions.InsufficientPermission;

public class ExtensionsConfigurationEndpoint
extends SecuredEndpoint {
    protected Configuration allConfiguration;
    protected Configuration configuration;
    protected Gson gson;
    protected XStream xstream;
    protected ExtensionsConfigurationDao extensionsConfigurationDao;

    @PostConstruct
    void init() {
        this.allConfiguration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.allConfiguration.subset("runtime-settings");
        super.init(this.configuration);
        this.extensionsConfigurationDao = ((DaoManager)this.context.getAttribute(DaoManager.class.getName())).getExtensionsConfigurationDao();
        ExtensionConfigurationConverter converter = new ExtensionConfigurationConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ExtensionConfiguration.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new ExtensionConfigurationConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.checkAuthenticatedAccount();
    }

    protected Response getConfiguration(String extensionId, Sid accountSid, MediaType responseType) {
        if (!this.isSuperAdmin()) {
            throw new InsufficientPermission();
        }
        ExtensionConfiguration extensionConfiguration = null;
        ExtensionConfiguration extensionAccountConfiguration = null;
        Sid extensionSid = null;
        String extensionName = null;
        if (Sid.pattern.matcher(extensionId).matches()) {
            extensionSid = new Sid(extensionId);
        } else {
            extensionName = extensionId;
        }
        if (Sid.pattern.matcher(extensionId).matches()) {
            try {
                extensionConfiguration = this.extensionsConfigurationDao.getConfigurationBySid(extensionSid);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        try {
            extensionConfiguration = this.extensionsConfigurationDao.getConfigurationByName(extensionName);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (accountSid != null) {
            if (extensionSid == null) {
                extensionSid = extensionConfiguration.getSid();
            }
            try {
                extensionAccountConfiguration = this.extensionsConfigurationDao.getAccountExtensionConfiguration(accountSid.toString(), extensionSid.toString());
                extensionConfiguration.setConfigurationData(extensionAccountConfiguration.getConfigurationData(), extensionAccountConfiguration.getConfigurationType());
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        if (extensionConfiguration == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)extensionConfiguration);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(extensionConfiguration.getConfigurationData()), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"ExtensionName")) {
            throw new NullPointerException("Extension name can not be null.");
        }
        if (!data.containsKey((Object)"ConfigurationData")) {
            throw new NullPointerException("ConfigurationData can not be null.");
        }
    }

    private ExtensionConfiguration createFrom(MultivaluedMap<String, String> data, MediaType responseType) {
        this.validate(data);
        Sid sid = Sid.generate((Sid.Type)Sid.Type.EXTENSION_CONFIGURATION);
        String extension = (String)data.getFirst((Object)"ExtensionName");
        boolean enabled = Boolean.parseBoolean((String)data.getFirst((Object)"Enabled"));
        Object configurationData = data.getFirst((Object)"ConfigurationData");
        ExtensionConfiguration.configurationType configurationType2 = null;
        if (responseType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            configurationType2 = ExtensionConfiguration.configurationType.JSON;
        } else if (responseType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            configurationType2 = ExtensionConfiguration.configurationType.XML;
        }
        DateTime dateCreated = DateTime.now();
        DateTime dateUpdated = DateTime.now();
        ExtensionConfiguration extensionConfiguration = new ExtensionConfiguration(sid, extension, enabled, configurationData, configurationType2, dateCreated, dateUpdated);
        return extensionConfiguration;
    }

    protected Response postConfiguration(MultivaluedMap<String, String> data, MediaType responseType) {
        String extensionName;
        ExtensionConfiguration extensionConfiguration;
        if (!this.isSuperAdmin()) {
            throw new InsufficientPermission();
        }
        Sid accountSid = null;
        String accountSidQuery = (String)data.getFirst((Object)"AccountSid");
        if (accountSidQuery != null && !accountSidQuery.isEmpty()) {
            accountSid = new Sid(accountSidQuery);
        }
        if ((extensionConfiguration = this.extensionsConfigurationDao.getConfigurationByName(extensionName = (String)data.getFirst((Object)"ExtensionName"))) == null) {
            try {
                extensionConfiguration = this.createFrom(data, responseType);
            }
            catch (NullPointerException exception) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
            }
            try {
                this.extensionsConfigurationDao.addConfiguration(extensionConfiguration);
            }
            catch (ConfigurationException exception) {
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)exception.getMessage()).build();
            }
        }
        if (accountSid != null) {
            try {
                Object configurationData = data.getFirst((Object)"ConfigurationData");
                extensionConfiguration.setConfigurationData(configurationData, extensionConfiguration.getConfigurationType());
                this.extensionsConfigurationDao.addAccountExtensionConfiguration(extensionConfiguration, accountSid);
            }
            catch (ConfigurationException exception) {
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)exception.getMessage()).build();
            }
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)extensionConfiguration), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)extensionConfiguration);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response updateConfiguration(String extensionSid, MultivaluedMap<String, String> data, MediaType responseType) {
        if (!this.isSuperAdmin()) {
            throw new InsufficientPermission();
        }
        if (!Sid.pattern.matcher(extensionSid).matches()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ExtensionConfiguration extensionConfiguration = this.extensionsConfigurationDao.getConfigurationBySid(new Sid(extensionSid));
        if (extensionConfiguration == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ExtensionConfiguration updatedExtensionConfiguration = null;
        Sid accountSid = null;
        String accountSidQuery = (String)data.getFirst((Object)"AccountSid");
        if (accountSidQuery != null && !accountSidQuery.isEmpty()) {
            accountSid = new Sid(accountSidQuery);
        }
        try {
            updatedExtensionConfiguration = this.prepareUpdatedConfiguration(extensionConfiguration, data, responseType);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        try {
            if (accountSid == null) {
                this.extensionsConfigurationDao.updateConfiguration(updatedExtensionConfiguration);
            } else {
                this.extensionsConfigurationDao.updateAccountExtensionConfiguration(updatedExtensionConfiguration, accountSid);
            }
        }
        catch (ConfigurationException exception) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)exception.getMessage()).build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)updatedExtensionConfiguration), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)updatedExtensionConfiguration);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private ExtensionConfiguration prepareUpdatedConfiguration(ExtensionConfiguration existingExtensionConfiguration, MultivaluedMap<String, String> data, MediaType responseType) {
        this.validate(data);
        Sid existingExtensionSid = existingExtensionConfiguration.getSid();
        String existingExtensionName = existingExtensionConfiguration.getExtensionName();
        boolean enabled = existingExtensionConfiguration.isEnabled();
        if (data.getFirst((Object)"Enabled") != null) {
            enabled = Boolean.parseBoolean((String)data.getFirst((Object)"Enabled"));
        }
        Object configurationData = data.getFirst((Object)"ConfigurationData");
        DateTime dateCreated = existingExtensionConfiguration.getDateCreated();
        ExtensionConfiguration.configurationType configurationType2 = null;
        if (responseType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            configurationType2 = ExtensionConfiguration.configurationType.JSON;
        } else if (responseType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            configurationType2 = ExtensionConfiguration.configurationType.XML;
        }
        return new ExtensionConfiguration(existingExtensionSid, existingExtensionName, enabled, configurationData, configurationType2, dateCreated, DateTime.now());
    }
}

