/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.CallDetailRecordFilter;
import org.restcomm.connect.dao.entities.CallDetailRecordList;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.CallDetailRecordListConverter;
import org.restcomm.connect.http.converter.ConferenceParticipantConverter;
import org.restcomm.connect.http.converter.RecordingConverter;
import org.restcomm.connect.http.converter.RecordingListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.mscontrol.api.messages.Mute;
import org.restcomm.connect.mscontrol.api.messages.Unmute;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.GetCallInfo;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class ParticipantsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected ActorRef callManager;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected CallDetailRecordListConverter listConverter;
    protected AccountsDao accountsDao;
    protected RecordingsDao recordingsDao;
    protected String instanceId;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.callManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.telephony.CallManager");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        this.recordingsDao = this.daos.getRecordingsDao();
        super.init(this.configuration);
        ConferenceParticipantConverter converter = new ConferenceParticipantConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        RecordingConverter recordingConverter = new RecordingConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.registerTypeAdapter(Recording.class, (Object)recordingConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)recordingConverter);
        this.xstream.registerConverter((Converter)new RecordingListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getCall(String accountSid, String sid, MediaType responseType) {
        Account account = this.daos.getAccountsDao().getAccount(accountSid);
        try {
            this.secure(account, "RestComm:Read:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = dao.getCallDetailRecord(new Sid(sid));
        if (cdr == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.secure(account, cdr.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)cdr);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        return null;
    }

    protected Response getCalls(String accountSid, String conferenceSid, UriInfo info, MediaType responseType) {
        CallDetailRecordFilter filter;
        CallDetailRecordFilter filterForTotal;
        Account account = this.daos.getAccountsDao().getAccount(accountSid);
        try {
            this.secure(account, "RestComm:Read:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String status = CallStateChanged.State.IN_PROGRESS.toString();
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        try {
            filterForTotal = localInstanceOnly ? new CallDetailRecordFilter(accountSid, null, null, null, status, null, null, null, conferenceSid, null, null) : new CallDetailRecordFilter(accountSid, null, null, null, status, null, null, null, conferenceSid, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = dao.getTotalCallDetailRecords(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new CallDetailRecordFilter(accountSid, null, null, null, status, null, null, null, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset)) : new CallDetailRecordFilter(accountSid, null, null, null, status, null, null, null, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = dao.getCallDetailRecords(filter);
        if (this.logger.isDebugEnabled()) {
            List allCdrs = dao.getCallDetailRecordsByAccountSid(new Sid(accountSid));
            this.logger.debug((Object)("CDR with filter size: " + cdrs.size() + ", all CDR with no filter size: " + allCdrs.size()));
            this.logger.debug((Object)("CDRs for ConferenceSid: " + conferenceSid));
            for (CallDetailRecord cdr : allCdrs) {
                this.logger.debug((Object)("CDR sid: " + cdr.getSid() + ", status: " + cdr.getStatus() + ", conferenceSid: " + cdr.getConferenceSid()));
            }
        }
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri("/" + this.getApiVersion(null) + "/" + info.getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new CallDetailRecordList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new CallDetailRecordList(cdrs)), (String)"application/json").build();
        }
        return null;
    }

    protected Response updateCall(String sid, String callSid, MultivaluedMap<String, String> data, MediaType responseType) {
        CallDetailRecord cdr;
        CallDetailRecordsDao dao;
        Timeout expires;
        block17: {
            Sid accountSid = new Sid(sid);
            Account account = this.daos.getAccountsDao().getAccount(accountSid);
            try {
                this.secure(account, "RestComm:Modify:Calls");
            }
            catch (AuthorizationException exception) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
            dao = this.daos.getCallDetailRecordsDao();
            cdr = null;
            try {
                cdr = dao.getCallDetailRecord(new Sid(callSid));
                if (cdr != null) {
                    try {
                        this.secure(account, cdr.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
                        break block17;
                    }
                    catch (AuthorizationException exception) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        String mutedStr = (String)data.getFirst((Object)"Muted");
        if (mutedStr != null) {
            CallInfo callInfo;
            ActorRef call;
            boolean muted = Boolean.parseBoolean(mutedStr);
            String callPath = null;
            try {
                callPath = cdr.getCallPath();
                Future future = Patterns.ask((ActorRef)this.callManager, (Object)new GetCall(callPath), (Timeout)expires);
                call = (ActorRef)Await.result((Awaitable)future, (Duration)Duration.create((long)100000L, (TimeUnit)TimeUnit.SECONDS));
                future = Patterns.ask((ActorRef)call, (Object)new GetCallInfo(), (Timeout)expires);
                CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)100000L, (TimeUnit)TimeUnit.SECONDS));
                callInfo = (CallInfo)response.get();
            }
            catch (Exception exception) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
            }
            if (callInfo.state().name().equalsIgnoreCase("IN_PROGRESS")) {
                if (muted) {
                    if (call != null) {
                        call.tell((Object)new Mute(), call);
                    }
                } else if (call != null) {
                    call.tell((Object)new Unmute(), call);
                }
                cdr = cdr.setMuted(Boolean.valueOf(muted));
                dao.updateCallDetailRecord(cdr);
            }
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
        }
        return null;
    }
}

