/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class IncomingPhoneNumberConverter
extends AbstractConverter
implements JsonSerializer<IncomingPhoneNumber> {
    public IncomingPhoneNumberConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return IncomingPhoneNumber.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        IncomingPhoneNumber incomingPhoneNumber = (IncomingPhoneNumber)object;
        writer.startNode("IncomingPhoneNumber");
        this.writeSid(incomingPhoneNumber.getSid(), writer);
        this.writeAccountSid(incomingPhoneNumber.getAccountSid(), writer);
        this.writeFriendlyName(incomingPhoneNumber.getFriendlyName(), writer);
        this.writePhoneNumber(incomingPhoneNumber.getPhoneNumber(), writer);
        this.writeVoiceUrl(incomingPhoneNumber.getVoiceUrl(), writer);
        this.writeVoiceMethod(incomingPhoneNumber.getVoiceMethod(), writer);
        this.writeVoiceFallbackUrl(incomingPhoneNumber.getVoiceFallbackUrl(), writer);
        this.writeVoiceFallbackMethod(incomingPhoneNumber.getVoiceFallbackMethod(), writer);
        this.writeStatusCallback(incomingPhoneNumber.getStatusCallback(), writer);
        this.writeStatusCallbackMethod(incomingPhoneNumber.getStatusCallbackMethod(), writer);
        this.writeVoiceCallerIdLookup((boolean)incomingPhoneNumber.hasVoiceCallerIdLookup(), writer);
        this.writeVoiceApplicationSid(incomingPhoneNumber.getVoiceApplicationSid(), writer);
        if (incomingPhoneNumber.getVoiceApplicationSid() != null) {
            this.writeVoiceApplicationName(incomingPhoneNumber.getVoiceApplicationName(), writer);
        }
        this.writeDateCreated(incomingPhoneNumber.getDateCreated(), writer);
        this.writeDateUpdated(incomingPhoneNumber.getDateUpdated(), writer);
        this.writeSmsUrl(incomingPhoneNumber.getSmsUrl(), writer);
        this.writeSmsMethod(incomingPhoneNumber.getSmsMethod(), writer);
        this.writeSmsFallbackUrl(incomingPhoneNumber.getSmsFallbackUrl(), writer);
        this.writeSmsFallbackMethod(incomingPhoneNumber.getSmsFallbackMethod(), writer);
        this.writeSmsApplicationSid(incomingPhoneNumber.getSmsApplicationSid(), writer);
        if (incomingPhoneNumber.getSmsApplicationSid() != null) {
            this.writeSmsApplicationName(incomingPhoneNumber.getSmsApplicationName(), writer);
        }
        this.writeUssdUrl(incomingPhoneNumber.getUssdUrl(), writer);
        this.writeUssdMethod(incomingPhoneNumber.getUssdMethod(), writer);
        this.writeUssdFallbackUrl(incomingPhoneNumber.getUssdFallbackUrl(), writer);
        this.writeUssdFallbackMethod(incomingPhoneNumber.getUssdFallbackMethod(), writer);
        this.writeUssdApplicationSid(incomingPhoneNumber.getUssdApplicationSid(), writer);
        if (incomingPhoneNumber.getUssdApplicationSid() != null) {
            this.writeUssdApplicationName(incomingPhoneNumber.getUssdApplicationName(), writer);
        }
        this.writeReferUrl(incomingPhoneNumber.getReferUrl(), writer);
        this.writeReferMethod(incomingPhoneNumber.getReferMethod(), writer);
        this.writeReferApplicationSid(incomingPhoneNumber.getReferApplicationSid(), writer);
        if (incomingPhoneNumber.getReferApplicationSid() != null) {
            this.writeReferApplicationName(incomingPhoneNumber.getReferApplicationName(), writer);
        }
        this.writeCapabilities(incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), writer);
        this.writeApiVersion(incomingPhoneNumber.getApiVersion(), writer);
        this.writeUri(incomingPhoneNumber.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(IncomingPhoneNumber incomingPhoneNumber, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(incomingPhoneNumber.getSid(), object);
        this.writeAccountSid(incomingPhoneNumber.getAccountSid(), object);
        this.writeFriendlyName(incomingPhoneNumber.getFriendlyName(), object);
        this.writePhoneNumber(incomingPhoneNumber.getPhoneNumber(), object);
        this.writeVoiceUrl(incomingPhoneNumber.getVoiceUrl(), object);
        this.writeVoiceMethod(incomingPhoneNumber.getVoiceMethod(), object);
        this.writeVoiceFallbackUrl(incomingPhoneNumber.getVoiceFallbackUrl(), object);
        this.writeVoiceFallbackMethod(incomingPhoneNumber.getVoiceFallbackMethod(), object);
        this.writeStatusCallback(incomingPhoneNumber.getStatusCallback(), object);
        this.writeStatusCallbackMethod(incomingPhoneNumber.getStatusCallbackMethod(), object);
        this.writeVoiceCallerIdLookup((boolean)incomingPhoneNumber.hasVoiceCallerIdLookup(), object);
        this.writeVoiceApplicationSid(incomingPhoneNumber.getVoiceApplicationSid(), object);
        if (incomingPhoneNumber.getVoiceApplicationSid() != null) {
            this.writeVoiceApplicationName(incomingPhoneNumber.getVoiceApplicationName(), object);
        }
        this.writeDateCreated(incomingPhoneNumber.getDateCreated(), object);
        this.writeDateUpdated(incomingPhoneNumber.getDateUpdated(), object);
        this.writeSmsUrl(incomingPhoneNumber.getSmsUrl(), object);
        this.writeSmsMethod(incomingPhoneNumber.getSmsMethod(), object);
        this.writeSmsFallbackUrl(incomingPhoneNumber.getSmsFallbackUrl(), object);
        this.writeSmsFallbackMethod(incomingPhoneNumber.getSmsFallbackMethod(), object);
        this.writeSmsApplicationSid(incomingPhoneNumber.getSmsApplicationSid(), object);
        if (incomingPhoneNumber.getSmsApplicationSid() != null) {
            this.writeSmsApplicationName(incomingPhoneNumber.getSmsApplicationName(), object);
        }
        this.writeUssdUrl(incomingPhoneNumber.getUssdUrl(), object);
        this.writeUssdMethod(incomingPhoneNumber.getUssdMethod(), object);
        this.writeUssdFallbackUrl(incomingPhoneNumber.getUssdFallbackUrl(), object);
        this.writeUssdFallbackMethod(incomingPhoneNumber.getUssdFallbackMethod(), object);
        this.writeUssdApplicationSid(incomingPhoneNumber.getUssdApplicationSid(), object);
        if (incomingPhoneNumber.getUssdApplicationSid() != null) {
            this.writeUssdApplicationName(incomingPhoneNumber.getUssdApplicationName(), object);
        }
        this.writeReferUrl(incomingPhoneNumber.getReferUrl(), object);
        this.writeReferMethod(incomingPhoneNumber.getReferMethod(), object);
        this.writeReferApplicationSid(incomingPhoneNumber.getReferApplicationSid(), object);
        if (incomingPhoneNumber.getReferApplicationSid() != null) {
            this.writeReferApplicationName(incomingPhoneNumber.getReferApplicationName(), object);
        }
        this.writeCapabilities(incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), object);
        this.writeApiVersion(incomingPhoneNumber.getApiVersion(), object);
        this.writeUri(incomingPhoneNumber.getUri(), object);
        return object;
    }

    private void writeSmsApplicationSid(Sid smsApplicationSid, HierarchicalStreamWriter writer) {
        if (smsApplicationSid != null) {
            writer.startNode("SmsApplicationSid");
            writer.setValue(smsApplicationSid.toString());
            writer.endNode();
        }
    }

    private void writeSmsApplicationSid(Sid smsApplicationSid, JsonObject object) {
        if (smsApplicationSid != null) {
            object.addProperty("sms_application_sid", smsApplicationSid.toString());
        } else {
            object.add("sms_application_sid", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeUssdApplicationSid(Sid ussdApplicationSid, HierarchicalStreamWriter writer) {
        if (ussdApplicationSid != null) {
            writer.startNode("UssdApplicationSid");
            writer.setValue(ussdApplicationSid.toString());
            writer.endNode();
        }
    }

    private void writeUssdApplicationSid(Sid ussdApplicationSid, JsonObject object) {
        if (ussdApplicationSid != null) {
            object.addProperty("ussd_application_sid", ussdApplicationSid.toString());
        } else {
            object.add("ussd_application_sid", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeReferApplicationSid(Sid referApplicationSid, JsonObject object) {
        if (referApplicationSid != null) {
            object.addProperty("refer_application_sid", referApplicationSid.toString());
        } else {
            object.add("refer_application_sid", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeReferApplicationSid(Sid referApplicationSid, HierarchicalStreamWriter writer) {
        if (referApplicationSid != null) {
            writer.startNode("ReferApplicationSid");
            writer.setValue(referApplicationSid.toString());
            writer.endNode();
        }
    }

    private void writeVoiceApplicationName(String voiceApplicationName, JsonObject object) {
        if (voiceApplicationName != null) {
            object.addProperty("voice_application_name", voiceApplicationName);
        } else {
            object.add("voice_application_name", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeVoiceApplicationName(String voiceApplicationName, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceApplicationName");
        writer.setValue(voiceApplicationName);
        writer.endNode();
    }

    private void writeSmsApplicationName(String smsApplicationName, JsonObject object) {
        if (smsApplicationName != null) {
            object.addProperty("sms_application_name", smsApplicationName);
        } else {
            object.add("sms_application_name", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeSmsApplicationName(String smsApplicationName, HierarchicalStreamWriter writer) {
        writer.startNode("SmsApplicationName");
        writer.setValue(smsApplicationName);
        writer.endNode();
    }

    private void writeUssdApplicationName(String ussdApplicationName, JsonObject object) {
        if (ussdApplicationName != null) {
            object.addProperty("ussd_application_name", ussdApplicationName);
        } else {
            object.add("ussd_application_name", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeUssdApplicationName(String ussdApplicationName, HierarchicalStreamWriter writer) {
        writer.startNode("UssdApplicationName");
        writer.setValue(ussdApplicationName);
        writer.endNode();
    }

    private void writeReferApplicationName(String referApplicationName, JsonObject object) {
        if (referApplicationName != null) {
            object.addProperty("refer_application_name", referApplicationName);
        } else {
            object.add("refer_application_name", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeReferApplicationName(String referApplicationName, HierarchicalStreamWriter writer) {
        writer.startNode("ReferApplicationName");
        writer.setValue(referApplicationName);
        writer.endNode();
    }
}

