/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.amazonS3.RecordingSecurityLevel;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.CallDetailRecordFilter;
import org.restcomm.connect.dao.entities.CallDetailRecordList;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.RecordingList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.CallDetailRecordConverter;
import org.restcomm.connect.http.converter.CallDetailRecordListConverter;
import org.restcomm.connect.http.converter.RecordingConverter;
import org.restcomm.connect.http.converter.RecordingListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.mscontrol.api.messages.Mute;
import org.restcomm.connect.mscontrol.api.messages.Unmute;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.ExecuteCallScript;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.UpdateCallScript;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class CallsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected ActorRef callManager;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected CallDetailRecordListConverter listConverter;
    protected AccountsDao accountsDao;
    protected RecordingsDao recordingsDao;
    protected String instanceId;
    protected RecordingSecurityLevel securityLevel = RecordingSecurityLevel.SECURE;
    protected boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        boolean amazonS3Enabled;
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        Configuration amazonS3Configuration = this.configuration.subset("amazon-s3");
        this.configuration = this.configuration.subset("runtime-settings");
        this.callManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.telephony.CallManager");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        this.recordingsDao = this.daos.getRecordingsDao();
        super.init(this.configuration);
        CallDetailRecordConverter converter = new CallDetailRecordConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        RecordingConverter recordingConverter = new RecordingConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.registerTypeAdapter(Recording.class, (Object)recordingConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)recordingConverter);
        this.xstream.registerConverter((Converter)new RecordingListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
        if (!amazonS3Configuration.isEmpty() && (amazonS3Enabled = amazonS3Configuration.getBoolean("enabled"))) {
            this.securityLevel = RecordingSecurityLevel.valueOf((String)amazonS3Configuration.getString("security-level", "secure").toUpperCase());
            recordingConverter.setSecurityLevel(this.securityLevel);
        }
    }

    protected Response getCall(String accountSid, String sid, MediaType responseType) {
        Account account = this.daos.getAccountsDao().getAccount(accountSid);
        this.secure(account, "RestComm:Read:Calls");
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = dao.getCallDetailRecord(new Sid(sid));
        if (cdr == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, cdr.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)cdr);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        return null;
    }

    protected Response getCalls(String accountSid, UriInfo info, MediaType responseType) {
        CallDetailRecordFilter filter;
        CallDetailRecordFilter filterForTotal;
        Account account = this.daos.getAccountsDao().getAccount(accountSid);
        this.secure(account, "RestComm:Read:Calls");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean querySubAccounts = false;
        String querySubAccountsParam = (String)info.getQueryParameters().getFirst((Object)"SubAccounts");
        if (querySubAccountsParam != null && querySubAccountsParam.equalsIgnoreCase("true")) {
            querySubAccounts = true;
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String recipient = (String)info.getQueryParameters().getFirst((Object)"To");
        String sender = (String)info.getQueryParameters().getFirst((Object)"From");
        String status = (String)info.getQueryParameters().getFirst((Object)"Status");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String endTime = (String)info.getQueryParameters().getFirst((Object)"EndTime");
        String parentCallSid = (String)info.getQueryParameters().getFirst((Object)"ParentCallSid");
        String conferenceSid = (String)info.getQueryParameters().getFirst((Object)"ConferenceSid");
        String reverse = (String)info.getQueryParameters().getFirst((Object)"Reverse");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        ArrayList<String> ownerAccounts = null;
        if (querySubAccounts) {
            ownerAccounts = new ArrayList<String>();
            ownerAccounts.add(accountSid);
            ownerAccounts.addAll(this.accountsDao.getSubAccountSidsRecursive(new Sid(accountSid)));
        }
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        try {
            filterForTotal = localInstanceOnly ? new CallDetailRecordFilter(accountSid, ownerAccounts, recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, null, null) : new CallDetailRecordFilter(accountSid, ownerAccounts, recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = dao.getTotalCallDetailRecords(filterForTotal);
        if (reverse != null && reverse.equalsIgnoreCase("true") && total > Integer.parseInt(pageSize)) {
            if (total > Integer.parseInt(pageSize) * (Integer.parseInt(page) + 1)) {
                offset = total - Integer.parseInt(pageSize) * (Integer.parseInt(page) + 1);
                limit = Integer.parseInt(pageSize);
            } else {
                offset = 0;
                limit = total - Integer.parseInt(pageSize) * Integer.parseInt(page);
            }
        }
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new CallDetailRecordFilter(accountSid, ownerAccounts, recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset)) : new CallDetailRecordFilter(accountSid, ownerAccounts, recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = dao.getCallDetailRecords(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri("/" + this.getApiVersion(null) + "/" + info.getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new CallDetailRecordList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new CallDetailRecordList(cdrs)), (String)"application/json").build();
        }
        return null;
    }

    private void normalize(MultivaluedMap<String, String> data) throws IllegalArgumentException {
        String to;
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String from = (String)data.getFirst((Object)"From");
        if (!from.contains("@")) {
            data.remove((Object)"From");
            try {
                data.putSingle((Object)"From", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(from, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
            }
            catch (NumberParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if ((to = (String)data.getFirst((Object)"To")).startsWith("client")) {
            if (to.split(":").length != 2) {
                throw new IllegalArgumentException(to + " is an invalid client identifier.");
            }
        } else if (!to.contains("@")) {
            data.remove((Object)"To");
            try {
                data.putSingle((Object)"To", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
            }
            catch (NumberParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        URI.create((String)data.getFirst((Object)"Url"));
    }

    protected Response putCall(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Sid accountId;
        try {
            accountId = new Sid(accountSid);
        }
        catch (IllegalArgumentException exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.buildErrorResponseBody(exception.getMessage(), responseType)).build();
        }
        this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Create:Calls");
        try {
            this.validate(data);
            if (this.normalizePhoneNumbers) {
                this.normalize(data);
            }
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        URI statusCallback = null;
        String statusCallbackMethod = "POST";
        List<String> statusCallbackEvent = new ArrayList<String>();
        statusCallbackEvent.add("initiated");
        statusCallbackEvent.add("ringing");
        statusCallbackEvent.add("answered");
        statusCallbackEvent.add("completed");
        String from = ((String)data.getFirst((Object)"From")).trim();
        String to = ((String)data.getFirst((Object)"To")).trim();
        String username = (String)data.getFirst((Object)"Username");
        String password = (String)data.getFirst((Object)"Password");
        Integer timeout = this.getTimeout(data);
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        URI rcmlUrl = this.getUrl("Url", data);
        try {
            if (data.containsKey((Object)"StatusCallback")) {
                statusCallback = new URI(((String)data.getFirst((Object)"StatusCallback")).trim());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (statusCallback != null) {
            if (data.containsKey((Object)"StatusCallbackMethod")) {
                statusCallbackMethod = ((String)data.getFirst((Object)"StatusCallbackMethod")).trim();
            }
            if (data.containsKey((Object)"StatusCallbackEvent")) {
                statusCallbackEvent = Arrays.asList(((String)data.getFirst((Object)"StatusCallbackEvent")).trim().split(","));
            }
        }
        CreateCall create = null;
        try {
            Future future;
            Object object;
            Class<?> klass;
            create = to.contains("@") ? new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.SIP, accountId, null, statusCallback, statusCallbackMethod, statusCallbackEvent) : (to.startsWith("client") ? new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.CLIENT, accountId, null, statusCallback, statusCallbackMethod, statusCallbackEvent) : new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.PSTN, accountId, null, statusCallback, statusCallbackMethod, statusCallbackEvent));
            create.setCreateCDR(false);
            if (this.callManager == null) {
                this.callManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.telephony.CallManager");
            }
            if (CallManagerResponse.class.equals(klass = (object = Await.result((Awaitable)(future = Patterns.ask((ActorRef)this.callManager, (Object)create, (Timeout)expires)), (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS))).getClass())) {
                CallManagerResponse managerResponse = (CallManagerResponse)object;
                if (managerResponse.succeeded()) {
                    CopyOnWriteArrayList<Object> dialBranches;
                    if (managerResponse.get() instanceof List) {
                        dialBranches = (CopyOnWriteArrayList<Object>)managerResponse.get();
                    } else {
                        dialBranches = new CopyOnWriteArrayList<Object>();
                        dialBranches.add(managerResponse.get());
                    }
                    CopyOnWriteArrayList<CallDetailRecord> cdrs = new CopyOnWriteArrayList<CallDetailRecord>();
                    for (ActorRef actorRef : dialBranches) {
                        CallResponse callResponse;
                        future = Patterns.ask((ActorRef)actorRef, (Object)new GetCallInfo(), (Timeout)expires);
                        object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                        klass = object.getClass();
                        if (!CallResponse.class.equals(klass) || !(callResponse = (CallResponse)object).succeeded()) continue;
                        CallInfo callInfo = (CallInfo)callResponse.get();
                        String version = this.getApiVersion(data);
                        URI url = rcmlUrl;
                        String method = this.getMethod("Method", data);
                        URI fallbackUrl = this.getUrl("FallbackUrl", data);
                        String fallbackMethod = this.getMethod("FallbackMethod", data);
                        ExecuteCallScript execute = new ExecuteCallScript(actorRef, accountId, version, url, method, fallbackUrl, fallbackMethod);
                        this.callManager.tell((Object)execute, null);
                        cdrs.add(this.daos.getCallDetailRecordsDao().getCallDetailRecord(callInfo.sid()));
                    }
                    if (MediaType.APPLICATION_XML_TYPE == responseType) {
                        if (cdrs.size() == 1) {
                            return Response.ok((Object)this.xstream.toXML(cdrs.get(0)), (String)"application/xml").build();
                        }
                        RestCommResponse response = new RestCommResponse((Object)new CallDetailRecordList(cdrs));
                        return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
                    }
                    if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                        if (cdrs.size() == 1) {
                            return Response.ok((Object)this.gson.toJson(cdrs.get(0)), (String)"application/json").build();
                        }
                        return Response.ok((Object)this.gson.toJson(cdrs), (String)"application/json").build();
                    }
                    return null;
                }
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)managerResponse.cause().getMessage()).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    protected Response updateCall(String sid, String callSid, MultivaluedMap<String, String> data, MediaType responseType) {
        CallInfo callInfo;
        ActorRef call;
        Sid accountSid = new Sid(sid);
        Account account = this.daos.getAccountsDao().getAccount(accountSid);
        this.secure(account, "RestComm:Modify:Calls");
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = null;
        try {
            cdr = dao.getCallDetailRecord(new Sid(callSid));
            if (cdr == null) {
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            }
            this.secure(account, cdr.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String url = (String)data.getFirst((Object)"Url");
        String method = (String)data.getFirst((Object)"Method");
        String status = (String)data.getFirst((Object)"Status");
        String fallBackUrl = (String)data.getFirst((Object)"FallbackUrl");
        String fallBackMethod = (String)data.getFirst((Object)"FallbackMethod");
        String statusCallBack = (String)data.getFirst((Object)"StatusCallback");
        String statusCallbackMethod = (String)data.getFirst((Object)"StatusCallbackMethod");
        Boolean moveConnectedCallLeg = Boolean.valueOf((String)data.getFirst((Object)"MoveConnectedCallLeg"));
        Boolean mute = Boolean.valueOf((String)data.getFirst((Object)"Mute"));
        String callPath = null;
        try {
            callPath = cdr.getCallPath();
            Future future = Patterns.ask((ActorRef)this.callManager, (Object)new GetCall(callPath), (Timeout)expires);
            call = (ActorRef)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            future = Patterns.ask((ActorRef)call, (Object)new GetCallInfo(), (Timeout)expires);
            CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            callInfo = (CallInfo)response.get();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
        if (method == null) {
            method = "POST";
        }
        if (url == null && status == null && mute == null) {
            String errorMessage = "You can either redirect a running call using \"Url\" or change the state of a Call with \"Status\" or mute a call using \"Mute=true\"";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"You can either redirect a running call using \"Url\" or change the state of a Call with \"Status\" or mute a call using \"Mute=true\"").build();
        }
        if (status != null) {
            if (status.equalsIgnoreCase("canceled")) {
                if (callInfo.state().name().equalsIgnoreCase("queued") || callInfo.state().name().equalsIgnoreCase("ringing")) {
                    if (call != null) {
                        call.tell((Object)new Hangup(), null);
                    }
                } else if (callInfo.state().name().equalsIgnoreCase("wait_for_answer") && call != null) {
                    call.tell((Object)new Hangup(Integer.valueOf(487)), null);
                }
            }
            if (status.equalsIgnoreCase("completed") && call != null) {
                call.tell((Object)new Hangup(Integer.valueOf(487)), null);
            }
        }
        if (mute != null && call != null) {
            try {
                this.muteUnmuteCall(mute, callInfo, call, cdr, dao);
            }
            catch (Exception exception) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
            }
        }
        if (url != null && call != null) {
            try {
                String version = this.getApiVersion(data);
                URI uri = new URL(url).toURI();
                URI fallbackUri = fallBackUrl != null ? new URL(fallBackUrl).toURI() : null;
                fallBackMethod = fallBackMethod == null ? "POST" : fallBackMethod;
                URI callbackUri = statusCallBack != null ? new URL(statusCallBack).toURI() : null;
                statusCallbackMethod = statusCallbackMethod == null ? "POST" : statusCallbackMethod;
                UpdateCallScript update = new UpdateCallScript(call, accountSid, version, uri, method, fallbackUri, fallBackMethod, callbackUri, statusCallbackMethod, moveConnectedCallLeg);
                this.callManager.tell((Object)update, null);
            }
            catch (Exception exception) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
            }
        } else if (this.logger.isInfoEnabled()) {
            if (url == null) {
                this.logger.info((Object)"Problem during Call Update, Url is null. Make sure you provide Url parameter");
            }
            if (call == null) {
                this.logger.info((Object)"Problem during Call update, Call is null. Make sure you provide the proper Call SID");
            }
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
        }
        return null;
    }

    private Integer getTimeout(MultivaluedMap<String, String> data) {
        Integer result = 60;
        if (data.containsKey((Object)"Timeout")) {
            result = Integer.parseInt((String)data.getFirst((Object)"Timeout"));
        }
        return result;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Url")) {
            throw new NullPointerException("Url can not be null.");
        }
    }

    protected Response getRecordingsByCall(String accountSid, String callSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Recordings");
        List recordings = this.recordingsDao.getRecordingsByCall(new Sid(callSid));
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)recordings), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new RecordingList(recordings));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected void muteUnmuteCall(Boolean mute, CallInfo callInfo, ActorRef call, CallDetailRecord cdr, CallDetailRecordsDao dao) {
        if (callInfo.state().name().equalsIgnoreCase("IN_PROGRESS") || callInfo.state().name().equalsIgnoreCase("in-progress")) {
            if (mute.booleanValue()) {
                if (!callInfo.isMuted()) {
                    call.tell((Object)new Mute(), null);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Call is already muted.");
                }
            } else if (callInfo.isMuted()) {
                call.tell((Object)new Unmute(), null);
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Call is not muted.");
            }
            cdr = cdr.setMuted(mute);
            dao.updateCallDetailRecord(cdr);
        }
    }
}

