/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.dao.entities.ConferenceDetailRecordFilter;
import org.restcomm.connect.dao.entities.ConferenceDetailRecordList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.ConferenceDetailRecordConverter;
import org.restcomm.connect.http.converter.ConferenceDetailRecordListConverter;

@NotThreadSafe
public abstract class ConferencesEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    private DaoManager daoManager;
    private Gson gson;
    private GsonBuilder builder;
    private XStream xstream;
    private ConferenceDetailRecordListConverter listConverter;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daoManager = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        super.init(this.configuration);
        ConferenceDetailRecordConverter converter = new ConferenceDetailRecordConverter(this.configuration);
        this.listConverter = new ConferenceDetailRecordListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(ConferenceDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(ConferenceDetailRecordList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.builder.disableHtmlEscaping();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)this.listConverter);
    }

    protected Response getConference(String accountSid, String sid, MediaType responseType) {
        Account account = this.daoManager.getAccountsDao().getAccount(accountSid);
        try {
            this.secure(account, "RestComm:Read:Conferences");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ConferenceDetailRecordsDao dao = this.daoManager.getConferenceDetailRecordsDao();
        ConferenceDetailRecord cdr = dao.getConferenceDetailRecord(new Sid(sid));
        if (cdr == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.secure(account, cdr.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)cdr);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        return null;
    }

    protected Response getConferences(String accountSid, UriInfo info, MediaType responseType) {
        ConferenceDetailRecordFilter filter;
        ConferenceDetailRecordFilter filterForTotal;
        Account account = this.daoManager.getAccountsDao().getAccount(accountSid);
        try {
            this.secure(account, "RestComm:Read:Conferences");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String status = (String)info.getQueryParameters().getFirst((Object)"Status");
        String dateCreated = (String)info.getQueryParameters().getFirst((Object)"DateCreated");
        String dateUpdated = (String)info.getQueryParameters().getFirst((Object)"DateUpdated");
        String friendlyName = (String)info.getQueryParameters().getFirst((Object)"FriendlyName");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        ConferenceDetailRecordsDao dao = this.daoManager.getConferenceDetailRecordsDao();
        try {
            filterForTotal = new ConferenceDetailRecordFilter(accountSid, status, dateCreated, dateUpdated, friendlyName, null, null);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = dao.getTotalConferenceDetailRecords(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = new ConferenceDetailRecordFilter(accountSid, status, dateCreated, dateUpdated, friendlyName, Integer.valueOf(limit), Integer.valueOf(offset));
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = dao.getConferenceDetailRecords(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri("/" + this.getApiVersion(null) + "/" + info.getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ConferenceDetailRecordList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new ConferenceDetailRecordList(cdrs)), (String)"application/json").build();
        }
        return null;
    }
}

