/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.email.EmailService;
import org.restcomm.connect.email.api.EmailRequest;
import org.restcomm.connect.email.api.EmailResponse;
import org.restcomm.connect.email.api.Mail;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.EmailMessageConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;

public class EmailMessagesEndpoint
extends SecuredEndpoint {
    private static Logger logger = Logger.getLogger(EmailMessagesEndpoint.class);
    @Context
    protected ServletContext context;
    protected ActorSystem system;
    protected Configuration configuration;
    protected Configuration confemail;
    protected Gson gson;
    protected AccountsDao accountsDao;
    ActorRef mailerService = null;
    protected XStream xstream;
    protected Mail emailMsg;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.confemail = this.configuration.subset("smtp-service");
        this.configuration = this.configuration.subset("runtime-settings");
        this.accountsDao = storage.getAccountsDao();
        this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
        super.init(this.configuration);
        EmailMessageConverter converter = new EmailMessageConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Mail.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private void normalize(MultivaluedMap<String, String> data) throws IllegalArgumentException {
        String from = (String)data.getFirst((Object)"From");
        data.remove((Object)"From");
        try {
            data.putSingle((Object)"From", (Object)this.validateEmail(from));
        }
        catch (InvalidEmailException exception) {
            throw new IllegalArgumentException(exception);
        }
        String to = (String)data.getFirst((Object)"To");
        data.remove((Object)"To");
        try {
            data.putSingle((Object)"To", (Object)this.validateEmail(to));
        }
        catch (InvalidEmailException exception) {
            throw new IllegalArgumentException(exception);
        }
        String subject = (String)data.getFirst((Object)"Subject");
        if (subject.length() > 160) {
            data.remove((Object)"Subject");
            data.putSingle((Object)"Subject", (Object)subject.substring(0, 160));
        }
        if (data.containsKey((Object)"CC")) {
            String cc = (String)data.getFirst((Object)"CC");
            data.remove((Object)"CC");
            try {
                data.putSingle((Object)"CC", (Object)this.validateEmails(cc));
            }
            catch (InvalidEmailException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if (data.containsKey((Object)"BCC")) {
            String bcc = (String)data.getFirst((Object)"BCC");
            data.remove((Object)"BCC");
            try {
                data.putSingle((Object)"BCC", (Object)this.validateEmails(bcc));
            }
            catch (InvalidEmailException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    protected Response putEmailMessage(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:EmailMessages");
        try {
            this.validate(data);
            this.normalize(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String sender = (String)data.getFirst((Object)"From");
        String recipient = (String)data.getFirst((Object)"To");
        String body = (String)data.getFirst((Object)"Body");
        String subject = (String)data.getFirst((Object)"Subject");
        String cc = data.containsKey((Object)"CC") ? (String)data.getFirst((Object)"CC") : " ";
        String bcc = data.containsKey((Object)"BCC") ? (String)data.getFirst((Object)"BCC") : " ";
        try {
            this.emailMsg = new Mail(sender, recipient, subject, body, cc, bcc, DateTime.now(), accountSid);
            if (this.mailerService == null) {
                this.mailerService = this.session(this.confemail);
            }
            ActorRef observer = this.observer();
            this.mailerService.tell((Object)new Observe(observer), observer);
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                return Response.ok((Object)this.gson.toJson((Object)this.emailMsg), (String)"application/json").build();
            }
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                RestCommResponse response = new RestCommResponse((Object)this.emailMsg);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            return null;
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Body")) {
            throw new NullPointerException("Body can not be null.");
        }
        if (!data.containsKey((Object)"Subject")) {
            throw new NullPointerException("Body can not be null.");
        }
    }

    public String validateEmail(String email) throws InvalidEmailException {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        if (!m.matches()) {
            String err = "Not a Valid Email Address";
            throw new InvalidEmailException(err);
        }
        return email;
    }

    public String validateEmails(String emails) throws InvalidEmailException {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        if (emails.indexOf(44) > 0) {
            String[] emailsArray = emails.split(",");
            for (int i = 0; i < emailsArray.length; ++i) {
                Matcher m = p.matcher(emailsArray[i]);
                if (m.matches()) continue;
                String err = "Not a Valid Email Address:" + emailsArray[i];
                throw new InvalidEmailException(err);
            }
        } else {
            Matcher m = p.matcher(emails);
            if (!m.matches()) {
                String err = "Not a Valid Email Address";
                throw new InvalidEmailException(err);
            }
        }
        return emails;
    }

    private ActorRef session(final Configuration configuration) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new EmailService(configuration);
            }
        });
        return this.system.actorOf(props);
    }

    private ActorRef observer() {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new EmailSessionObserver();
            }
        });
        return this.system.actorOf(props);
    }

    private static class InvalidEmailException
    extends Exception {
        public InvalidEmailException() {
        }

        public InvalidEmailException(String message) {
            super(message);
        }
    }

    private final class EmailSessionObserver
    extends UntypedActor {
        public void onReceive(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (EmailResponse.class.equals(klass)) {
                EmailResponse response = (EmailResponse)message;
                if (!response.succeeded()) {
                    logger.error((Object)("There was an error while sending an email :" + response.error()), response.cause());
                }
                UntypedActorContext context = this.getContext();
                ActorRef self = this.self();
                EmailMessagesEndpoint.this.mailerService.tell((Object)new StopObserving(self), null);
                context.stop(self);
            } else if (Observing.class.equals(klass)) {
                EmailMessagesEndpoint.this.mailerService.tell((Object)new EmailRequest(EmailMessagesEndpoint.this.emailMsg), this.self());
            }
        }
    }
}

