/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.GatewaysDao;
import org.restcomm.connect.dao.entities.Gateway;
import org.restcomm.connect.dao.entities.GatewayList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.GatewayConverter;
import org.restcomm.connect.http.converter.GatewayListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.telephony.api.RegisterGateway;

@ThreadSafe
public class GatewaysEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected GatewaysDao dao;
    protected Gson gson;
    protected XStream xstream;
    private ActorRef proxyManager;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getGatewaysDao();
        GatewayConverter converter = new GatewayConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Gateway.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new GatewayListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.proxyManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.telephony.proxy.ProxyManager");
    }

    private Gateway createFrom(MultivaluedMap<String, String> data) {
        Gateway.Builder builder = Gateway.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.GATEWAY);
        builder.setSid(sid);
        String friendlyName = (String)data.getFirst((Object)"FriendlyName");
        if (friendlyName == null || friendlyName.isEmpty()) {
            friendlyName = (String)data.getFirst((Object)"UserName");
        }
        builder.setFriendlyName(friendlyName);
        builder.setPassword((String)data.getFirst((Object)"Password"));
        builder.setProxy((String)data.getFirst((Object)"Proxy"));
        boolean register = Boolean.parseBoolean((String)data.getFirst((Object)"Register"));
        builder.setRegister(register);
        builder.setUserName((String)data.getFirst((Object)"UserName"));
        int ttl = Integer.parseInt((String)data.getFirst((Object)"TTL"));
        builder.setTimeToLive(ttl);
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.getApiVersion(data)).append("/Management/").append("Gateways/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    protected Response getGateway(String accountSid, String sid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Gateways");
        Gateway gateway = this.dao.getGateway(new Sid(sid));
        if (gateway == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)gateway);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)gateway), (String)"application/json").build();
        }
        return null;
    }

    protected Response getGateways(String accountSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Gateways");
        List gateways = this.dao.getGateways();
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new GatewayList(gateways));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)gateways), (String)"application/json").build();
        }
        return null;
    }

    protected Response putGateway(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:Gateways");
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Gateway gateway = this.createFrom(data);
        this.dao.addGateway(gateway);
        if (this.proxyManager == null) {
            this.proxyManager = (ActorRef)this.context.getAttribute("org.restcomm.connect.telephony.proxy.ProxyManager");
        }
        this.proxyManager.tell((Object)new RegisterGateway(gateway), null);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)gateway);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)gateway), (String)"application/json").build();
        }
        return null;
    }

    protected Response updateGateway(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Modify:Gateways");
        Gateway gateway = this.dao.getGateway(new Sid(sid));
        if (gateway == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.dao.updateGateway(this.update(gateway, data));
        gateway = this.dao.getGateway(new Sid(sid));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)gateway);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)gateway), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) {
        if (!data.containsKey((Object)"UserName")) {
            throw new NullPointerException("UserName can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
        if (!data.containsKey((Object)"Proxy")) {
            throw new NullPointerException("The Proxy can not be null");
        }
        if (!data.containsKey((Object)"Register")) {
            throw new NullPointerException("Register must be true or false");
        }
    }

    private Gateway update(Gateway gateway, MultivaluedMap<String, String> data) {
        Gateway result = gateway;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"UserName")) {
            result = result.setUserName((String)data.getFirst((Object)"UserName"));
        }
        if (data.containsKey((Object)"Password")) {
            result = result.setPassword((String)data.getFirst((Object)"Password"));
        }
        if (data.containsKey((Object)"Proxy")) {
            result = result.setProxy((String)data.getFirst((Object)"Proxy"));
        }
        if (data.containsKey((Object)"Register")) {
            result = result.setRegister(Boolean.parseBoolean("Register"));
        }
        if (data.containsKey((Object)"TTL")) {
            result = result.setTimeToLive(Integer.parseInt((String)data.getFirst((Object)"TTL")));
        }
        return result;
    }
}

