/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.loader.ObjectInstantiationException;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.IncomingPhoneNumberFilter;
import org.restcomm.connect.dao.entities.IncomingPhoneNumberList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.extension.api.ApiRequest;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.AvailableCountriesConverter;
import org.restcomm.connect.http.converter.AvailableCountriesList;
import org.restcomm.connect.http.converter.IncomingPhoneNumberConverter;
import org.restcomm.connect.http.converter.IncomingPhoneNumberListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.provisioning.number.api.PhoneNumber;
import org.restcomm.connect.provisioning.number.api.PhoneNumberParameters;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManager;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManagerProvider;
import org.restcomm.connect.provisioning.number.api.PhoneNumberType;

@NotThreadSafe
public abstract class IncomingPhoneNumbersEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected PhoneNumberProvisioningManager phoneNumberProvisioningManager;
    PhoneNumberParameters phoneNumberParameters;
    private IncomingPhoneNumbersDao dao;
    private XStream xstream;
    protected Gson gson;

    @PostConstruct
    public void init() throws ObjectInstantiationException {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        super.init(this.configuration.subset("runtime-settings"));
        this.dao = storage.getIncomingPhoneNumbersDao();
        this.accountsDao = storage.getAccountsDao();
        this.phoneNumberProvisioningManager = new PhoneNumberProvisioningManagerProvider(this.configuration, this.context).get();
        Configuration callbackUrlsConfiguration = this.configuration.subset("phone-number-provisioning").subset("callback-urls");
        this.phoneNumberParameters = new PhoneNumberParameters(callbackUrlsConfiguration.getString("voice[@url]"), callbackUrlsConfiguration.getString("voice[@method]"), false, callbackUrlsConfiguration.getString("sms[@url]"), callbackUrlsConfiguration.getString("sms[@method]"), callbackUrlsConfiguration.getString("fax[@url]"), callbackUrlsConfiguration.getString("fax[@method]"), callbackUrlsConfiguration.getString("ussd[@url]"), callbackUrlsConfiguration.getString("ussd[@method]"));
        IncomingPhoneNumberConverter converter = new IncomingPhoneNumberConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.registerTypeAdapter(IncomingPhoneNumber.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new IncomingPhoneNumberListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new AvailableCountriesConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private IncomingPhoneNumber createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        IncomingPhoneNumber.Builder builder = IncomingPhoneNumber.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.PHONE_NUMBER);
        builder.setSid(sid);
        builder.setAccountSid(accountSid);
        String phoneNumber = (String)data.getFirst((Object)"PhoneNumber");
        String cost = (String)data.getFirst((Object)"Cost");
        builder.setPhoneNumber(phoneNumber);
        builder.setFriendlyName(this.getFriendlyName(phoneNumber, data));
        if (data.containsKey((Object)"VoiceCapable")) {
            builder.setVoiceCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"VoiceCapable"))));
        }
        if (data.containsKey((Object)"SmsCapable")) {
            builder.setSmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"SmsCapable"))));
        }
        if (data.containsKey((Object)"MmsCapable")) {
            builder.setMmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"MmsCapable"))));
        }
        if (data.containsKey((Object)"FaxCapable")) {
            builder.setFaxCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"FaxCapable"))));
        }
        if (data.containsKey((Object)"isSIP")) {
            builder.setPureSip(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"isSIP"))));
        } else {
            builder.setPureSip(Boolean.valueOf(false));
        }
        String apiVersion = this.getApiVersion(data);
        builder.setApiVersion(apiVersion);
        builder.setVoiceUrl(this.getUrl("VoiceUrl", data));
        builder.setVoiceMethod(this.getMethod("VoiceMethod", data));
        builder.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        builder.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        builder.setStatusCallback(this.getUrl("StatusCallback", data));
        builder.setStatusCallbackMethod(this.getMethod("StatusCallbackMethod", data));
        builder.setHasVoiceCallerIdLookup(this.getHasVoiceCallerIdLookup(data));
        builder.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        builder.setSmsUrl(this.getUrl("SmsUrl", data));
        builder.setSmsMethod(this.getMethod("SmsMethod", data));
        builder.setSmsFallbackUrl(this.getUrl("SmsFallbackUrl", data));
        builder.setSmsFallbackMethod(this.getMethod("SmsFallbackMethod", data));
        builder.setSmsApplicationSid(this.getSid("SmsApplicationSid", data));
        builder.setUssdUrl(this.getUrl("UssdUrl", data));
        builder.setUssdMethod(this.getMethod("UssdMethod", data));
        builder.setUssdFallbackUrl(this.getUrl("UssdFallbackUrl", data));
        builder.setUssdFallbackMethod(this.getMethod("UssdFallbackMethod", data));
        builder.setUssdApplicationSid(this.getSid("UssdApplicationSid", data));
        builder.setReferUrl(this.getUrl("ReferUrl", data));
        builder.setReferMethod(this.getMethod("ReferMethod", data));
        builder.setReferApplicationSid(this.getSid("ReferApplicationSid", data));
        Configuration configuration = this.configuration.subset("runtime-settings");
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(apiVersion).append("/Accounts/").append(accountSid.toString()).append("/IncomingPhoneNumbers/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    private String e164(String number) throws NumberParseException {
        Phonenumber.PhoneNumber result;
        PhoneNumberUtil numbersUtil = PhoneNumberUtil.getInstance();
        if (!number.startsWith("+")) {
            number = "+" + number;
        }
        if (numbersUtil.isValidNumber(result = numbersUtil.parse(number, "US"))) {
            return numbersUtil.format(result, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "This is not a valid number");
    }

    private String getFriendlyName(String phoneNumber, MultivaluedMap<String, String> data) {
        String friendlyName = phoneNumber;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        return friendlyName;
    }

    protected Response getIncomingPhoneNumber(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:IncomingPhoneNumbers");
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        if (incomingPhoneNumber == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (operatedAccount == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.secure(operatedAccount, incomingPhoneNumber.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getAvailableCountries(String accountSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:IncomingPhoneNumbers");
        ArrayList<String> countries = this.phoneNumberProvisioningManager.getAvailableCountries();
        if (countries == null) {
            countries = new ArrayList<String>();
            countries.add("US");
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(countries), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new AvailableCountriesList(countries));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getIncomingPhoneNumbers(String accountSid, String phoneNumberFilter, String friendlyNameFilter, PhoneNumberType phoneNumberType, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:IncomingPhoneNumbers");
        IncomingPhoneNumberFilter incomingPhoneNumberFilter = new IncomingPhoneNumberFilter(accountSid, friendlyNameFilter, phoneNumberFilter);
        List incomingPhoneNumbers = this.dao.getIncomingPhoneNumbersByFilter(incomingPhoneNumberFilter);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumbers), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new IncomingPhoneNumberList(incomingPhoneNumbers));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response putIncomingPhoneNumber(String accountSid, MultivaluedMap<String, String> data, PhoneNumberType phoneNumberType, MediaType responseType) {
        IncomingPhoneNumber incomingPhoneNumber;
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:IncomingPhoneNumbers");
        try {
            this.validate(data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String number = (String)data.getFirst((Object)"PhoneNumber");
        String isSIP = (String)data.getFirst((Object)"isSIP");
        if (isSIP == null) {
            try {
                number = this.e164(number);
            }
            catch (NumberParseException e) {
                // empty catch block
            }
        }
        if ((incomingPhoneNumber = this.dao.getIncomingPhoneNumber(number)) == null) {
            incomingPhoneNumber = this.createFrom(new Sid(accountSid), data);
            this.phoneNumberParameters.setPhoneNumberType(phoneNumberType);
            PhoneNumber phoneNumber = IncomingPhoneNumbersEndpoint.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber);
            boolean hasSuceeded = false;
            if (this.phoneNumberProvisioningManager != null && isSIP == null) {
                ApiRequest apiRequest = new ApiRequest(accountSid, data, ApiRequest.Type.INCOMINGPHONENUMBER);
                if (this.executePreApiAction(apiRequest)) {
                    hasSuceeded = this.phoneNumberProvisioningManager.buyNumber(phoneNumber, this.phoneNumberParameters);
                } else {
                    hasSuceeded = false;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)"DID purchase is now allowed for this account");
                    }
                }
                this.executePostApiAction(apiRequest);
                if (!hasSuceeded) {
                    String msg = "DID purchase is now allowed for this account";
                    String error = "DID_QUOTA_EXCEEDED";
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.buildErrorResponseBody(msg, error, responseType)).build();
                }
            } else if (isSIP != null) {
                hasSuceeded = true;
            }
            if (hasSuceeded) {
                if (phoneNumber.getFriendlyName() != null) {
                    incomingPhoneNumber.setFriendlyName(phoneNumber.getFriendlyName());
                }
                if (phoneNumber.getPhoneNumber() != null) {
                    incomingPhoneNumber.setPhoneNumber(phoneNumber.getPhoneNumber());
                }
                this.dao.addIncomingPhoneNumber(incomingPhoneNumber);
                if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                    return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
                }
                if (MediaType.APPLICATION_XML_TYPE == responseType) {
                    RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
                    return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
                }
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"21452").build();
    }

    public Response updateIncomingPhoneNumber(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Modify:IncomingPhoneNumbers");
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        this.secure(operatedAccount, incomingPhoneNumber.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        boolean updated = true;
        if (!(this.phoneNumberProvisioningManager == null || incomingPhoneNumber.isPureSip() != null && incomingPhoneNumber.isPureSip().booleanValue())) {
            updated = this.phoneNumberProvisioningManager.updateNumber(IncomingPhoneNumbersEndpoint.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber), this.phoneNumberParameters);
        }
        if (updated) {
            this.dao.updateIncomingPhoneNumber(this.update(incomingPhoneNumber, data));
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
            }
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            return null;
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"21452").build();
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"PhoneNumber") && !data.containsKey((Object)"AreaCode")) {
            throw new NullPointerException("Phone number can not be null.");
        }
    }

    private IncomingPhoneNumber update(IncomingPhoneNumber incomingPhoneNumber, MultivaluedMap<String, String> data) {
        URI uri;
        if (data.containsKey((Object)"ApiVersion")) {
            incomingPhoneNumber.setApiVersion(this.getApiVersion(data));
        }
        if (data.containsKey((Object)"FriendlyName")) {
            incomingPhoneNumber.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"VoiceUrl")) {
            uri = this.getUrl("VoiceUrl", data);
            incomingPhoneNumber.setVoiceUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"VoiceMethod")) {
            incomingPhoneNumber.setVoiceMethod(this.getMethod("VoiceMethod", data));
        }
        if (data.containsKey((Object)"VoiceFallbackUrl")) {
            uri = this.getUrl("VoiceFallbackUrl", data);
            incomingPhoneNumber.setVoiceFallbackUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"VoiceFallbackMethod")) {
            incomingPhoneNumber.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        }
        if (data.containsKey((Object)"StatusCallback")) {
            uri = this.getUrl("StatusCallback", data);
            incomingPhoneNumber.setStatusCallback(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"StatusCallbackMethod")) {
            incomingPhoneNumber.setStatusCallbackMethod(this.getMethod("StatusCallbackMethod", data));
        }
        if (data.containsKey((Object)"VoiceCallerIdLookup")) {
            incomingPhoneNumber.setHasVoiceCallerIdLookup(Boolean.valueOf(this.getHasVoiceCallerIdLookup(data)));
        }
        if (data.containsKey((Object)"VoiceApplicationSid")) {
            if (StringUtils.isEmpty((String)((String)data.getFirst((Object)"VoiceApplicationSid")))) {
                incomingPhoneNumber.setVoiceApplicationSid(null);
            } else {
                incomingPhoneNumber.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
            }
        }
        if (data.containsKey((Object)"SmsUrl")) {
            uri = this.getUrl("SmsUrl", data);
            incomingPhoneNumber.setSmsUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"SmsMethod")) {
            incomingPhoneNumber.setSmsMethod(this.getMethod("SmsMethod", data));
        }
        if (data.containsKey((Object)"SmsFallbackUrl")) {
            uri = this.getUrl("SmsFallbackUrl", data);
            incomingPhoneNumber.setSmsFallbackUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"SmsFallbackMethod")) {
            incomingPhoneNumber.setSmsFallbackMethod(this.getMethod("SmsFallbackMethod", data));
        }
        if (data.containsKey((Object)"SmsApplicationSid")) {
            if (StringUtils.isEmpty((String)((String)data.getFirst((Object)"SmsApplicationSid")))) {
                incomingPhoneNumber.setSmsApplicationSid(null);
            } else {
                incomingPhoneNumber.setSmsApplicationSid(this.getSid("SmsApplicationSid", data));
            }
        }
        if (data.containsKey((Object)"ReferUrl")) {
            uri = this.getUrl("ReferUrl", data);
            incomingPhoneNumber.setReferUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"ReferMethod")) {
            incomingPhoneNumber.setReferMethod(this.getMethod("ReferMethod", data));
        }
        if (data.containsKey((Object)"ReferApplicationSid")) {
            if (StringUtils.isEmpty((String)((String)data.getFirst((Object)"ReferApplicationSid")))) {
                incomingPhoneNumber.setReferApplicationSid(null);
            } else {
                incomingPhoneNumber.setReferApplicationSid(this.getSid("ReferApplicationSid", data));
            }
        }
        if (data.containsKey((Object)"VoiceCapable")) {
            incomingPhoneNumber.setVoiceCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"VoiceCapable"))));
        }
        if (data.containsKey((Object)"VoiceCapable")) {
            incomingPhoneNumber.setVoiceCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"VoiceCapable"))));
        }
        if (data.containsKey((Object)"SmsCapable")) {
            incomingPhoneNumber.setSmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"SmsCapable"))));
        }
        if (data.containsKey((Object)"MmsCapable")) {
            incomingPhoneNumber.setMmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"MmsCapable"))));
        }
        if (data.containsKey((Object)"FaxCapable")) {
            incomingPhoneNumber.setFaxCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"FaxCapable"))));
        }
        if (data.containsKey((Object)"UssdUrl")) {
            uri = this.getUrl("UssdUrl", data);
            incomingPhoneNumber.setUssdUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"UssdMethod")) {
            incomingPhoneNumber.setUssdMethod(this.getMethod("UssdMethod", data));
        }
        if (data.containsKey((Object)"UssdFallbackUrl")) {
            uri = this.getUrl("UssdFallbackUrl", data);
            incomingPhoneNumber.setUssdFallbackUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"UssdFallbackMethod")) {
            incomingPhoneNumber.setUssdFallbackMethod(this.getMethod("UssdFallbackMethod", data));
        }
        if (data.containsKey((Object)"UssdApplicationSid")) {
            if (StringUtils.isEmpty((String)((String)data.getFirst((Object)"UssdApplicationSid")))) {
                incomingPhoneNumber.setUssdApplicationSid(null);
            } else {
                incomingPhoneNumber.setUssdApplicationSid(this.getSid("UssdApplicationSid", data));
            }
        }
        incomingPhoneNumber.setDateUpdated(DateTime.now());
        return incomingPhoneNumber;
    }

    public Response deleteIncomingPhoneNumber(String accountSid, String sid) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Delete:IncomingPhoneNumbers");
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        this.secure(operatedAccount, incomingPhoneNumber.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (!(this.phoneNumberProvisioningManager == null || incomingPhoneNumber.isPureSip() != null && incomingPhoneNumber.isPureSip().booleanValue())) {
            this.phoneNumberProvisioningManager.cancelNumber(IncomingPhoneNumbersEndpoint.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber));
        }
        this.dao.removeIncomingPhoneNumber(new Sid(sid));
        return Response.noContent().build();
    }

    public static PhoneNumber convertIncomingPhoneNumbertoPhoneNumber(IncomingPhoneNumber incomingPhoneNumber) {
        return new PhoneNumber(incomingPhoneNumber.getFriendlyName(), incomingPhoneNumber.getPhoneNumber(), null, null, null, null, null, null, null, null, incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), Boolean.valueOf(false));
    }
}

