/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.CallDetailRecordFilter;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.CallinfoConverter;
import org.restcomm.connect.http.converter.MonitoringServiceConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.GetLiveCalls;
import org.restcomm.connect.telephony.api.MonitoringServiceResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class SupervisorEndpoint
extends SecuredEndpoint {
    private static Logger logger = Logger.getLogger(SupervisorEndpoint.class);
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    private DaoManager daos;
    private Gson gson;
    private GsonBuilder builder;
    private XStream xstream;
    private ActorRef monitoringService;

    @PostConstruct
    public void init() {
        this.monitoringService = (ActorRef)this.context.getAttribute(MonitoringService.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        super.init(this.configuration);
        CallinfoConverter converter = new CallinfoConverter(this.configuration);
        MonitoringServiceConverter listConverter = new MonitoringServiceConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallInfo.class, (Object)converter);
        this.builder.registerTypeAdapter(MonitoringServiceResponse.class, (Object)listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)listConverter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    protected Response pong(String accountSid, MediaType responseType) {
        CallDetailRecordFilter filterForTotal;
        this.checkAuthenticatedAccount();
        this.allowOnlySuperAdmin();
        try {
            filterForTotal = new CallDetailRecordFilter("", null, null, null, null, null, null, null, null, null, null);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int totalCalls = this.daos.getCallDetailRecordsDao().getTotalCallDetailRecords(filterForTotal);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)("TotalCalls: " + totalCalls));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)("TotalCalls: " + totalCalls)), (String)"application/json").build();
        }
        return null;
    }

    protected Response getMetrics(String accountSid, MediaType responseType) {
        MonitoringServiceResponse monitoringServiceResponse;
        this.checkAuthenticatedAccount();
        this.allowOnlySuperAdmin();
        try {
            Timeout expires = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
            GetLiveCalls getLiveCalls = new GetLiveCalls();
            Future future = Patterns.ask((ActorRef)this.monitoringService, (Object)getLiveCalls, (Timeout)expires);
            monitoringServiceResponse = (MonitoringServiceResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        if (monitoringServiceResponse != null) {
            RestCommResponse response;
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                response = new RestCommResponse((Object)monitoringServiceResponse);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                response = Response.ok((Object)this.gson.toJson((Object)monitoringServiceResponse), (String)"application/json").build();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Supervisor endpoint response: " + this.gson.toJson((Object)monitoringServiceResponse)));
                }
                return response;
            }
            return null;
        }
        return null;
    }

    protected Response registerForUpdates(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        MonitoringServiceResponse liveCalls;
        this.checkAuthenticatedAccount();
        this.allowOnlySuperAdmin();
        try {
            Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
            GetLiveCalls getLiveCalls = new GetLiveCalls();
            Future future = Patterns.ask((ActorRef)this.monitoringService, (Object)getLiveCalls, (Timeout)expires);
            liveCalls = (MonitoringServiceResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        if (liveCalls != null) {
            RestCommResponse response;
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                response = new RestCommResponse((Object)liveCalls);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                response = Response.ok((Object)this.gson.toJson((Object)liveCalls), (String)"application/json").build();
                return response;
            }
            return null;
        }
        return null;
    }

    protected Response registerForCallUpdates(String accountSid, String callSid, MultivaluedMap<String, String> data, MediaType responseType) {
        MonitoringServiceResponse liveCalls;
        this.checkAuthenticatedAccount();
        this.allowOnlySuperAdmin();
        String url = (String)data.getFirst((Object)"Url");
        String refresh = (String)data.getFirst((Object)"Refresh");
        try {
            Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
            GetLiveCalls getLiveCalls = new GetLiveCalls();
            Future future = Patterns.ask((ActorRef)this.monitoringService, (Object)getLiveCalls, (Timeout)expires);
            liveCalls = (MonitoringServiceResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        if (liveCalls != null) {
            RestCommResponse response;
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                response = new RestCommResponse((Object)liveCalls);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                response = Response.ok((Object)this.gson.toJson((Object)liveCalls), (String)"application/json").build();
                return response;
            }
            return null;
        }
        return null;
    }
}

