/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class NotificationConverter
extends AbstractConverter
implements JsonSerializer<Notification> {
    public NotificationConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Notification.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Notification notification = (Notification)object;
        writer.startNode("Notification");
        this.writeSid(notification.getSid(), writer);
        this.writeDateCreated(notification.getDateCreated(), writer);
        this.writeDateUpdated(notification.getDateUpdated(), writer);
        this.writeAccountSid(notification.getAccountSid(), writer);
        this.writeCallSid(notification.getCallSid(), writer);
        this.writeApiVersion(notification.getApiVersion(), writer);
        this.writeLog((int)notification.getLog(), writer);
        this.writeErrorCode((int)notification.getErrorCode(), writer);
        this.writeMoreInfo(notification.getMoreInfo(), writer);
        this.writeMessageText(notification.getMessageText(), writer);
        this.writeMessageDate(notification.getMessageDate(), writer);
        this.writeRequestUrl(notification.getRequestUrl(), writer);
        this.writeRequestMethod(notification.getRequestMethod(), writer);
        this.writeRequestVariables(notification.getRequestVariables(), writer);
        this.writeResponseHeaders(notification.getResponseHeaders(), writer);
        this.writeResponseBody(notification.getResponseBody(), writer);
        this.writeUri(notification.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Notification notification, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(notification.getSid(), object);
        this.writeDateCreated(notification.getDateCreated(), object);
        this.writeDateUpdated(notification.getDateUpdated(), object);
        this.writeAccountSid(notification.getAccountSid(), object);
        this.writeCallSid(notification.getCallSid(), object);
        this.writeApiVersion(notification.getApiVersion(), object);
        this.writeLog((int)notification.getLog(), object);
        this.writeErrorCode((int)notification.getErrorCode(), object);
        this.writeMoreInfo(notification.getMoreInfo(), object);
        this.writeMessageText(notification.getMessageText(), object);
        this.writeMessageDate(notification.getMessageDate(), object);
        this.writeRequestUrl(notification.getRequestUrl(), object);
        this.writeRequestMethod(notification.getRequestMethod(), object);
        this.writeRequestVariables(notification.getRequestVariables(), object);
        this.writeResponseHeaders(notification.getResponseHeaders(), object);
        this.writeResponseBody(notification.getResponseBody(), object);
        this.writeUri(notification.getUri(), object);
        return object;
    }

    private void writeErrorCode(int errorCode, HierarchicalStreamWriter writer) {
        writer.startNode("ErrorCode");
        writer.setValue(Integer.toString(errorCode));
        writer.endNode();
    }

    private void writeErrorCode(int errorCode, JsonObject object) {
        object.addProperty("error_code", (Number)errorCode);
    }

    private void writeLog(int log, HierarchicalStreamWriter writer) {
        writer.startNode("Log");
        writer.setValue(Integer.toString(log));
        writer.endNode();
    }

    private void writeLog(int log, JsonObject object) {
        object.addProperty("log", (Number)log);
    }

    private void writeMessageDate(DateTime messageDate, HierarchicalStreamWriter writer) {
        writer.startNode("MessageDate");
        writer.setValue(messageDate.toString());
        writer.endNode();
    }

    private void writeMessageDate(DateTime messageDate, JsonObject object) {
        object.addProperty("message_date", messageDate.toString());
    }

    private void writeMessageText(String messageText, HierarchicalStreamWriter writer) {
        writer.startNode("MessageText");
        if (messageText != null) {
            writer.setValue(messageText);
        }
        writer.endNode();
    }

    private void writeMessageText(String messageText, JsonObject object) {
        if (messageText != null) {
            object.addProperty("message_text", messageText);
        } else {
            object.add("message_text", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeMoreInfo(URI moreInfo, HierarchicalStreamWriter writer) {
        writer.startNode("MoreInfo");
        writer.setValue(moreInfo.toString());
        writer.endNode();
    }

    private void writeMoreInfo(URI moreInfo, JsonObject object) {
        object.addProperty("more_info", moreInfo.toString());
    }

    private void writeRequestUrl(URI requestUrl, HierarchicalStreamWriter writer) {
        writer.startNode("RequestUrl");
        writer.setValue(requestUrl.toString());
        writer.endNode();
    }

    private void writeRequestUrl(URI requestUrl, JsonObject object) {
        object.addProperty("request_url", requestUrl.toString());
    }

    private void writeRequestMethod(String requestMethod, HierarchicalStreamWriter writer) {
        writer.startNode("RequestMethod");
        writer.setValue(requestMethod);
        writer.endNode();
    }

    private void writeRequestMethod(String requestMethod, JsonObject object) {
        object.addProperty("request_method", requestMethod);
    }

    private void writeRequestVariables(String requestVariables, HierarchicalStreamWriter writer) {
        writer.startNode("RequestVariables");
        if (requestVariables != null) {
            writer.setValue(requestVariables);
        }
        writer.endNode();
    }

    private void writeRequestVariables(String requestVariables, JsonObject object) {
        if (requestVariables != null) {
            object.addProperty("request_variables", requestVariables);
        } else {
            object.add("request_variables", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeResponseHeaders(String responseHeaders, HierarchicalStreamWriter writer) {
        writer.startNode("ResponseHeaders");
        if (responseHeaders != null) {
            writer.setValue(responseHeaders);
        }
        writer.endNode();
    }

    private void writeResponseHeaders(String responseHeaders, JsonObject object) {
        if (responseHeaders != null) {
            object.addProperty("response_headers", responseHeaders);
        } else {
            object.add("response_headers", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeResponseBody(String responseBody, HierarchicalStreamWriter writer) {
        writer.startNode("ResponseBody");
        if (responseBody != null) {
            writer.setValue(responseBody);
        }
        writer.endNode();
    }

    private void writeResponseBody(String responseBody, JsonObject object) {
        if (responseBody != null) {
            object.addProperty("response_body", responseBody);
        } else {
            object.add("response_body", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

