/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.chain.processor.impl;

import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.EndpointProcessor;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.Processor;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.ProcessorListener;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.chain.processor.impl.ProcessorParsingException;

public abstract class DefaultProcessor
implements Processor {
    private static transient Logger LOG = Logger.getLogger(DefaultProcessor.class);
    private EventListenerList listenerList = new EventListenerList();
    protected ProcessorChain chain;
    protected String name;
    protected Processor.Type type;

    public DefaultProcessor() {
        this.type = Processor.Type.CHAIN;
    }

    public DefaultProcessor(String name) {
        this();
        this.setName(name);
    }

    public DefaultProcessor(ProcessorChain chain) {
        this.chain = chain;
        this.type = Processor.Type.SINGLE_PROCESSOR;
    }

    public DefaultProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    public void addProcessorListener(ProcessorListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding listener " + listener + " to " + this));
        }
        this.listenerList.add(ProcessorListener.class, listener);
    }

    protected void fireProcessingEvent(Message message, Processor processor) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessorListener.class) continue;
            ((ProcessorListener)listeners[i + 1]).onProcessorProcessing(message, processor);
        }
    }

    protected void fireEndEvent(Message message, Processor processor) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessorListener.class) continue;
            ((ProcessorListener)listeners[i + 1]).onProcessorEnd(message, processor);
        }
    }

    protected void fireUnlinkEvent(Processor processor) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessorListener.class) continue;
            ((ProcessorListener)listeners[i + 1]).onProcessorUnlink(processor);
        }
    }

    protected void fireAbortEvent(Processor processor) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessorListener.class) continue;
            ((ProcessorListener)listeners[i + 1]).onProcessorAbort(processor);
        }
    }

    public void process(MutableMessage message) throws ProcessorParsingException {
        if (message == null) {
            throw new ProcessorParsingException("null Messages not allowed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> process() message [" + message + "]"));
        }
        if (!message.isLinked() && !(this instanceof EndpointProcessor)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("UNLINK message [" + message + "] on chain " + this.chain.getName() + " on processor " + this));
            }
            this.fireUnlinkEvent((Processor)this.getCallback());
        } else if (message.isAborted() && !(this instanceof EndpointProcessor)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ABORT message [" + message + "] on chain " + this.chain.getName() + " on processor " + this));
            }
            this.fireAbortEvent((Processor)this.getCallback());
        } else {
            this.fireProcessingEvent((Message)message, (Processor)this.getCallback());
            this.getCallback().doProcess((Message)message);
            this.fireEndEvent((Message)message, (Processor)this.getCallback());
        }
        Processor nextLink = null;
        if (this.chain != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DP " + this.type + " from callback " + ((Processor)this.getCallback()).getName() + " chain " + this.chain.getName()));
            }
            nextLink = this.chain.getNextLink((Processor)this);
        }
        if (nextLink != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DP " + this.type + " from callback " + ((Processor)this.getCallback()).getName() + " nextlink " + nextLink.getName()));
            }
            nextLink.process(message);
        }
    }

    public Processor.Type getType() {
        return this.type;
    }

    public abstract String getVersion();

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getId();

    public abstract ProcessorCallBack getCallback();
}

