/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.adapter.impl;

import java.net.NoRouteToHostException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.adapter.ProtocolAdapter;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;

public class TCPProtocolAdapter
extends ProtocolAdapter {
    private static transient Logger LOG = Logger.getLogger(TCPProtocolAdapter.class);
    private SipFactory sipFactory = ConfigurationCache.getSipFactory();

    public Message adapt(Message message) throws NoRouteToHostException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        String sourceTransport = sm.getInitialTransport();
        if (sourceTransport == null) {
            sourceTransport = ProtocolAdapterFactory.PROTOCOL_UDP;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("o Contact " + sm.getHeader("Contact")));
            LOG.trace((Object)("o Transport " + sourceTransport));
            LOG.trace((Object)("o Message follows:\n" + message.toString()));
            LOG.trace((Object)">> adapt() Adapting protocol [->TCP]");
        }
        String user = ((SipURI)sm.getFrom().getURI()).getUser();
        String host = ((SipURI)sm.getFrom().getURI()).getHost();
        int port = ((SipURI)sm.getFrom().getURI()).getPort();
        SipURI sipUri = this.sipFactory.createSipURI(user, host);
        sipUri.setTransportParam("tcp");
        sipUri.setPort(port);
        if (sm instanceof SipServletRequest) {
            ((SipServletRequest)sm).setRequestURI((URI)sipUri);
        }
        m.setContent((Object)sm);
        return m;
    }

    public String getProtocol() {
        return ProtocolAdapterFactory.PROTOCOL_TCP;
    }
}

