/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultDPIProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.managers.ThreatManager;
import org.restcomm.sbc.threat.Threat;

public class UserAgentACLDPIProcessor
extends DefaultDPIProcessor
implements ProcessorCallBack {
    private String name = "ACL UA Processor";
    private static transient Logger LOG = Logger.getLogger(UserAgentACLDPIProcessor.class);
    private static String[] a = new String[]{"sipcli", "sipvicious", "sip-scan", "sipsak", "sundayddr", "friendly-scanner", "iWar", "CSipSimple", "SIVuS", "Gulp", "sipv", "smap", "friendly-request", "VaxIPUserAgent", "VaxSIPUserAgent", "siparmyknife", "Test Agent"};
    private static ArrayList<String> attackers = new ArrayList<String>(Arrays.asList(a));

    public UserAgentACLDPIProcessor(ProcessorChain processorChain) {
        super(processorChain);
    }

    public UserAgentACLDPIProcessor(String name, ProcessorChain processorChain) {
        super(name, processorChain);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public SipServletMessage doProcess(SIPMutableMessage message) throws ProcessorParsingException {
        SipServletMessage m;
        String userAgent;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> doProcess()");
        }
        String string = userAgent = (userAgent = (m = message.getContent()).getHeader("User-Agent")) == null || "".equals(userAgent.trim()) ? "Anonymous" : userAgent;
        if (userAgent.equals("Anonymous") || this.isAttacker(userAgent)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("THREAT: Forbidden access to threat-candidate UA " + userAgent));
            }
            ThreatManager threatManager = ThreatManager.getThreatManager();
            threatManager.create(Threat.Type.BAD_UA, m.getFrom().getDisplayName(), m.getRemoteAddr(), 0, userAgent, m.getTransport());
            if (m instanceof SipServletRequest) {
                SipServletRequest request = (SipServletRequest)m;
                SipServletResponse response = request.createResponse(405, "Method not allowed");
                message.setContent((Object)response);
                message.unlink();
            }
        }
        return m;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        this.doProcess((SIPMutableMessage)message);
    }

    public String getVersion() {
        return "1.0.0";
    }

    private boolean isAttacker(String ua) {
        for (String attackerUA : attackers) {
            if (!ua.contains(attackerUA)) continue;
            return true;
        }
        return false;
    }
}

