/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.registrar;

import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.managers.MessageUtil;

public class RegistrarProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(RegistrarProcessor.class);
    private String name = "REGISTRAR Processor";

    public RegistrarProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public RegistrarProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processRequest(SIPMutableMessage message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processRequest()");
        }
        SipServletRequest dmzRequest = (SipServletRequest)message.getContent();
        SipServletRequest oRequest = (SipServletRequest)dmzRequest.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        int expires = dmzRequest.getExpires();
        Address contactAddress = null;
        if (ConfigurationCache.isRegThrottleEnabled() && expires > 0) {
            SipURI fromURI;
            LocationManager locationManager = LocationManager.getLocationManager();
            try {
                contactAddress = dmzRequest.getAddressHeader("Contact");
                fromURI = (SipURI)dmzRequest.getFrom().getURI();
            }
            catch (ServletParseException e) {
                LOG.error((Object)"Cannot get Contact Address!");
                return;
            }
            SipURI uri = (SipURI)contactAddress.getURI();
            String user = uri.getUser();
            String domain = fromURI.getHost();
            int mzExpiry = ConfigurationCache.getRegThrottleMZTTL();
            int uaExpiry = ConfigurationCache.getRegThrottleUATTL();
            dmzRequest.setExpires(mzExpiry);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("expires=" + expires + " ua=" + uaExpiry + " mz=" + mzExpiry));
            }
            expires = uaExpiry;
            if (!locationManager.exists(user, domain)) {
                message.setContent((Object)dmzRequest);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Registration Throttle Replying to originator");
            }
            SipServletResponse dmzResponse = dmzRequest.createResponse(200, "Ok");
            dmzResponse.setHeader("Max-Expires", "" + uaExpiry);
            dmzResponse.setHeader("Min-Expires", "" + uaExpiry);
            dmzResponse.setHeader("Expires", "" + uaExpiry);
            contactAddress.setExpires(uaExpiry);
            dmzResponse.setAddressHeader("Contact", contactAddress);
            if (LOG.isDebugEnabled()) {
                // empty if block
            }
            message.setContent((Object)dmzResponse);
            message.unlink();
            return;
        }
        try {
            dmzRequest.setAddressHeader(MessageUtil.B2BUA_ORIG_CONTACT_ADDR, dmzRequest.getAddressHeader("Contact"));
        }
        catch (ServletParseException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
            SipServletResponse dmzResponse = dmzRequest.createResponse(401, "Not Found");
            message.setContent((Object)dmzResponse);
            message.unlink();
            return;
        }
        message.setContent((Object)dmzRequest);
    }

    private void processResponse(SIPMutableMessage message) {
        SipServletResponse mzResponse = (SipServletResponse)message.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
            LOG.trace((Object)(">> response received: \n" + mzResponse.toString()));
        }
        SipServletRequest oRequest = (SipServletRequest)mzResponse.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        Location location = null;
        if (mzResponse.getStatus() == 200) {
            LocationManager locationManager = LocationManager.getLocationManager();
            Address address = null;
            SipURI uri = null;
            try {
                address = mzResponse.getAddressHeader("Contact");
                uri = (SipURI)address.getURI();
                LOG.info((Object)("URI " + uri.toString()));
            }
            catch (ServletParseException e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
            String user = ((SipURI)mzResponse.getFrom().getURI()).getUser();
            String domain = ((SipURI)mzResponse.getTo().getURI()).getHost();
            int mzExpires = mzResponse.getRequest().getExpires();
            if (mzExpires <= 0) {
                location = locationManager.unregister(user, domain);
                if (LOG.isDebugEnabled() && location != null) {
                    LOG.debug((Object)("UNREGISTER " + location.getUser()));
                }
            } else {
                if (ConfigurationCache.isRegThrottleEnabled()) {
                    mzExpires = ConfigurationCache.getRegThrottleMZTTL();
                }
                int cSeq = this.getCSeq(mzResponse.getRequest());
                String callerID = mzResponse.getCallId();
                if (!locationManager.exists(user, domain)) {
                    location = new Location(uri.getUser(), domain, uri.getHost(), uri.getPort(), message.getTargetTransport());
                    locationManager.register(location, mzResponse.getRequest().getHeader("User-Agent"), mzResponse.getCallId(), this.getCSeq(mzResponse.getRequest()), mzExpires);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("REGISTER new " + location));
                    }
                } else {
                    try {
                        location = locationManager.getLocation(user, domain);
                    }
                    catch (LocationNotFoundException e) {
                        LOG.error((Object)"No Binding ", (Throwable)e);
                    }
                    if (location.getcSeq() < cSeq && callerID.equals(location.getCallID())) {
                        locationManager.register(location, mzResponse.getRequest().getHeader("User-Agent"), mzResponse.getCallId(), this.getCSeq(mzResponse.getRequest()), mzExpires);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("REGISTER update " + location));
                        }
                    } else {
                        locationManager.register(location, mzResponse.getRequest().getHeader("User-Agent"), mzResponse.getCallId(), this.getCSeq(mzResponse.getRequest()), mzExpires);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("REGISTER new Dialog " + location));
                        }
                    }
                }
            }
        }
        message.setContent((Object)mzResponse);
    }

    private int getCSeq(SipServletRequest request) {
        String s = request.getHeader("CSeq");
        try {
            return Integer.parseInt(s.substring(0, s.indexOf(32)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

