/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.DaoUtils;
import org.restcomm.sbc.dao.NetworkPointsDao;

@ThreadSafe
public final class MybatisNetworkPointsDao
implements NetworkPointsDao {
    private static final String namespace = "org.restcomm.sbc.dao.NetworkPointsDao.";
    private final SqlSessionFactory sessions;

    public MybatisNetworkPointsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkPoint(NetworkPoint entry) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.NetworkPointsDao.addEntry", (Object)this.toMap(entry));
            session.commit();
        }
    }

    public NetworkPoint getNetworkPoint(String name) {
        NetworkPoint entry = null;
        entry = this.getNetworkPoint("org.restcomm.sbc.dao.NetworkPointsDao.getEntryByTag", (Object)name);
        if (entry == null) {
            entry = this.getNetworkPoint("org.restcomm.sbc.dao.NetworkPointsDao.getEntry", (Object)name);
        }
        return entry;
    }

    public boolean isTagged(String point) {
        NetworkPoint entry = null;
        entry = this.getNetworkPoint("org.restcomm.sbc.dao.NetworkPointsDao.getEntry", (Object)point);
        if (entry == null) {
            return false;
        }
        return entry.getTag().isTagged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkPoint getNetworkPoint(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                NetworkPoint networkPoint = this.toNetworkPoint(result);
                return networkPoint;
            }
            NetworkPoint networkPoint = null;
            return networkPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkPoint> getNetworkPoints() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.NetworkPointsDao.getEntries");
            ArrayList<NetworkPoint> entrys = new ArrayList<NetworkPoint>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toNetworkPoint(result));
                }
            }
            ArrayList<NetworkPoint> arrayList = entrys;
            return arrayList;
        }
    }

    public void updateNetworkPoint(NetworkPoint point) {
        this.updateNetworkPoint("org.restcomm.sbc.dao.NetworkPointsDao.updateEntry", point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkPoint(String selector, NetworkPoint point) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, (Object)this.toMap(point));
            session.commit();
        }
    }

    public void removeNetworkPoint(String uid) {
        this.removeNetworkPoint("org.restcomm.sbc.dao.NetworkPointsDao.removeEntry", uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNetworkPoint(String selector, String uid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)uid);
            session.commit();
        }
    }

    private NetworkPoint toNetworkPoint(Map<String, Object> map) {
        String id = DaoUtils.readString((Object)map.get("id"));
        Sid entrySid = DaoUtils.readSid((Object)map.get("account_sid"));
        NetworkPoint.Tag tag = DaoUtils.readTag((Object)map.get("tag"));
        return new NetworkPoint(id, entrySid, tag);
    }

    private Map<String, Object> toMap(NetworkPoint entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", entry.getId());
        map.put("tag", DaoUtils.writeTag((NetworkPoint.Tag)entry.getTag()));
        map.put("account_sid", DaoUtils.writeSid((Sid)entry.getAccountSid()));
        return map;
    }
}

