/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceHandler;
import org.mobicents.media.io.ice.events.IceEventListener;
import org.mobicents.media.io.ice.events.SelectedCandidatesEvent;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.utils.Text;
import org.restcomm.sbc.media.RtcpHandler;
import org.restcomm.sbc.media.dtls.DtlsHandler;
import org.restcomm.sbc.media.dtls.DtlsSrtpServerProvider;

public class RtcpChannel
extends MultiplexedChannel
implements DtlsListener,
IceEventListener {
    private static final Logger logger = Logger.getLogger(RtcpChannel.class);
    private boolean bound = false;
    private static final int STUN_PRIORITY = 3;
    private static final int RTCP_PRIORITY = 2;
    private static final int DTLS_PRIORITY = 1;
    private static final int PORT_ANY = -1;
    private RtcpHandler rtcpHandler = new RtcpHandler();
    private DtlsHandler dtlsHandler;
    private IceHandler stunHandler;
    private boolean ice;
    private boolean secure;
    private RtpListener rtpListener;

    public RtcpChannel(DtlsSrtpServerProvider dtlsServerProvider) {
        this.dtlsHandler = new DtlsHandler(dtlsServerProvider);
        this.stunHandler = new IceHandler(2, (IceEventListener)this);
        this.secure = false;
    }

    public void setRemotePeer(SocketAddress remotePeer) {
        if (this.dataChannel != null) {
            if (this.dataChannel.isConnected()) {
                try {
                    this.dataChannel.disconnect();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.dataChannel.connect(remotePeer);
            }
            catch (IOException e) {
                logger.error((Object)"Can not connect to remote address. Check that you are not using local address (127.0.0.X)", (Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("RemotePeer  " + remotePeer.toString()));
            logger.trace((Object)("Datachannel " + this.dataChannel));
        }
    }

    public void setRtpListener(RtpListener rtpListener) {
        this.rtpListener = rtpListener;
    }

    public boolean isAvailable() {
        boolean available;
        boolean bl = available = this.dataChannel != null && this.dataChannel.isConnected();
        if (this.secure) {
            available = available && this.dtlsHandler.isHandshakeComplete();
        }
        return available;
    }

    public boolean isBound() {
        return this.bound;
    }

    private void onBinding() {
        if (this.secure) {
            this.stunHandler.setPipelinePriority(3);
        }
        this.rtcpHandler.setChannel(this.dataChannel);
    }

    public boolean canHandleRTCP(byte[] packet) {
        return this.rtcpHandler.canHandle(packet);
    }

    public boolean canHandleDTLS(byte[] packet) {
        return this.dtlsHandler.canHandle(packet);
    }

    public boolean canHandleICE(byte[] packet) {
        return this.stunHandler.canHandle(packet);
    }

    public void bind(boolean isLocal, int port) throws IOException {
        this.onBinding();
        this.bound = true;
    }

    @Deprecated
    public void bind(DatagramChannel channel) throws SocketException {
        this.dataChannel = channel;
        this.onBinding();
        if (!channel.socket().isBound()) {
            // empty if block
        }
        this.bound = true;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("bind(channel) bound      " + channel.socket().isBound()));
            logger.trace((Object)("bind(channel) connected  " + this.isConnected()));
            logger.trace((Object)("bind(channel) secure     " + this.secure));
            logger.trace((Object)("bind(channel) available  " + this.isAvailable()));
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void enableIce(IceAuthenticator authenticator) {
        if (!this.ice) {
            this.ice = true;
            this.stunHandler.setAuthenticator(authenticator);
            this.handlers.addHandler((PacketHandler)this.stunHandler);
        }
    }

    public void disableIce() {
        if (this.ice) {
            this.ice = false;
            this.handlers.removeHandler((PacketHandler)this.stunHandler);
        }
    }

    public void enableSRTCP(String hashFunction, String remotePeerFingerprint) {
        if (!this.secure) {
            this.secure = true;
            this.dtlsHandler.setRemoteFingerprint(hashFunction, remotePeerFingerprint);
            this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            this.dtlsHandler.setChannel(this.dataChannel);
        }
    }

    public void enableSRTCP() {
        if (!this.secure) {
            this.secure = true;
            this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            this.dtlsHandler.setChannel(this.dataChannel);
        }
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.dtlsHandler.setRemoteFingerprint(hashFunction, fingerprint);
    }

    public void disableSRTCP() {
        if (this.secure) {
            this.secure = false;
            if (this.dtlsHandler != null) {
                this.dtlsHandler.setRemoteFingerprint("", "");
            }
            this.dtlsHandler.resetLocalFingerprint();
            this.rtcpHandler.disableSRTCP();
        }
    }

    public Text getDtlsLocalFingerprint() {
        if (this.secure) {
            return new Text(this.dtlsHandler.getLocalFingerprint());
        }
        return new Text("");
    }

    public void close() {
        this.bound = false;
        super.close();
        this.reset();
    }

    public void reset() {
        this.rtcpHandler.reset();
        if (this.ice) {
            this.disableIce();
            this.stunHandler.reset();
        }
        if (this.secure) {
            this.disableSRTCP();
            this.dtlsHandler.reset();
        }
    }

    public void onDtlsHandshakeComplete() {
        logger.info((Object)"DTLS handshake completed for RTCP candidate.\nJoining RTP session.");
    }

    public void onDtlsHandshakeFailed(Throwable e) {
        logger.info((Object)"DTLS handshake failed.");
        if (this.rtpListener != null) {
            this.rtpListener.onRtcpFailure(e);
        }
    }

    public void onSelectedCandidates(SelectedCandidatesEvent event) {
        logger.info((Object)("onSelectedCandidates(), handshake must begin with event=" + event));
        logger.info((Object)("Remote Peer=" + event.getRemotePeer()));
        try {
            logger.info((Object)("dataChannel Local=" + this.dataChannel.getLocalAddress() + ", Remote=" + this.dataChannel.getRemoteAddress()));
            this.connect(event.getRemotePeer());
            if (this.secure) {
                this.dtlsHandler.handshake();
            }
        }
        catch (IOException e) {
            this.rtpListener.onRtcpFailure((Throwable)e);
        }
    }

    public RtcpHandler getRtcpHandler() {
        return this.rtcpHandler;
    }

    public DtlsHandler getDtlsHandler() {
        return this.dtlsHandler;
    }

    public IceHandler getStunHandler() {
        return this.stunHandler;
    }
}

