/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.rest.ConnectorsEndpoint;

@Path(value="/Connectors")
@ThreadSafe
public final class ConnectorsXmlEndpoint
extends ConnectorsEndpoint {
    @Path(value="/{sid}.json")
    @GET
    public Response getConnectorAsJson(@PathParam(value="sid") String sid) {
        return this.getConnector(new Sid(sid), MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getConnectorAsXml(@PathParam(value="sid") String sid) {
        return this.getConnector(new Sid(sid), MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteConnectorAsXml(@PathParam(value="sid") String sid) {
        return this.deleteConnector(new Sid(sid));
    }

    @GET
    public Response getConnectors(@Context UriInfo info) {
        return this.getConnectors(info, MediaType.APPLICATION_XML_TYPE);
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response putConnector(MultivaluedMap<String, String> data) {
        return this.putConnector(data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response updateAccountAsXmlPost(@PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateConnector(new Sid(sid), data, MediaType.APPLICATION_XML_TYPE);
    }
}

