/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.servlet.sip;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.log4j.Logger;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.call.Call;
import org.restcomm.sbc.call.CallManager;
import org.restcomm.sbc.chain.impl.invite.DownstreamInviteProcessorChain;
import org.restcomm.sbc.chain.impl.invite.UpstreamInviteProcessorChain;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.managers.RouteManager;
import org.restcomm.sbc.media.MediaSession;

public class SBCCallServlet
extends SipServlet
implements SipApplicationSessionListener {
    private static final long serialVersionUID = 1L;
    private static transient Logger LOG = Logger.getLogger(SBCCallServlet.class);
    private UpstreamInviteProcessorChain upChain;
    private CallManager callManager;
    private DownstreamInviteProcessorChain dwChain;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.callManager = CallManager.getCallManager();
        LOG.info((Object)"Call sip servlet has been started");
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> init()");
        }
        this.upChain = new UpstreamInviteProcessorChain();
        LOG.info((Object)("Loading (v. " + this.upChain.getVersion() + ") " + this.upChain.getName()));
        this.dwChain = new DownstreamInviteProcessorChain();
        LOG.info((Object)("Loading (v. " + this.dwChain.getVersion() + ") " + this.dwChain.getName()));
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        String direction = "outbound";
        if (RouteManager.isFromDMZ((SipServletMessage)request)) {
            direction = "inbound";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("CALL REQUEST DMZ:" + direction));
            LOG.trace((Object)("CALL REQUEST SES:" + request.getSession()));
        }
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        SipURI toURI = (SipURI)request.getTo().getURI();
        Call call = this.callManager.getCall(request.getSession().getId());
        call = call == null ? this.callManager.createCall(null, request.getSession().getId(), toURI.getUser(), fromURI.getUser(), direction, null, request.getFrom().getDisplayName()) : this.callManager.createCall(call, request.getSession().getId(), toURI.getUser(), fromURI.getUser(), direction, null, request.getFrom().getDisplayName());
        request.getApplicationSession().setExpires(0);
        request.getSession().setAttribute(MessageUtil.CALL_MANAGER, (Object)call);
        this.upChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)request));
    }

    protected void doInfo(SipServletRequest request) throws ServletException, IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("INFO REQUEST DMZ:" + RouteManager.isFromDMZ((SipServletMessage)request)));
        }
        this.upChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)request));
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        if (response.getStatus() == 100) {
            return;
        }
        String callSessionId = this.getCallSessionId(response.getRequest());
        if (response.getStatus() == 180) {
            this.callManager.changeCallStatus(callSessionId, Call.Status.RINGING);
        }
        if (response.getMethod().equals("INVITE") && response.getStatus() > 200) {
            Call call = this.callManager.getCall(callSessionId);
            if (call != null) {
                this.callManager.changeCallStatus(callSessionId, response.getStatus(), response.getReasonPhrase());
            } else {
                callSessionId = response.getRequest().getSession().getId();
                call = this.callManager.getCall(callSessionId);
                if (call != null) {
                    this.callManager.changeCallStatus(callSessionId, response.getStatus(), response.getReasonPhrase());
                }
            }
        }
        try {
            this.dwChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)response));
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)(e.getMessage() + " not forwarding message"));
            return;
        }
        super.doResponse(response);
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CALL BYE SES:" + request.getSession()));
            LOG.debug((Object)("Got Request BYE: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
            LOG.debug((Object)"RTP Session might end");
        }
        SipServletResponse response = request.createResponse(200);
        response.send();
        String callSessionId = this.getCallSessionId(request);
        Call call = null;
        if (callSessionId != null) {
            call = this.callManager.getCall(callSessionId);
        }
        if (call != null) {
            this.callManager.changeCallStatus(callSessionId, Call.Status.COMPLETED);
        } else {
            callSessionId = request.getSession().getId();
            call = this.callManager.getCall(callSessionId);
            if (call != null) {
                this.callManager.changeCallStatus(callSessionId, Call.Status.COMPLETED);
            }
        }
        try {
            this.upChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)request));
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)(e.getMessage() + " not forwarding message"));
        }
    }

    protected void doAck(SipServletRequest request) throws ServletException, IOException {
        SipServletRequest oRequest = (SipServletRequest)request.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CALL ACK SES:" + request.getSession()));
            LOG.debug((Object)("Got Request ACK: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
            LOG.debug((Object)"RTP Session might start");
        }
        String callSessionId = request.getSession().getId();
        Call call = this.callManager.getCall(callSessionId);
        this.callManager.changeCallStatus(callSessionId, Call.Status.BRIDGED);
        MediaSession mediaSession = call.getMediaSession();
    }

    protected void doPrack(SipServletRequest request) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CALL PRACK SES:" + request.getSession()));
            LOG.debug((Object)("Got Request PRACK: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
        }
        this.upChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)request));
    }

    protected void doCancel(SipServletRequest request) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CALL CANCEL SES:" + request.getSession()));
            LOG.debug((Object)("Got Request CANCEL: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
            LOG.debug((Object)"RTP Session might end");
        }
        SipServletResponse response = request.createResponse(200);
        response.send();
        response = request.createResponse(487);
        response.send();
        this.upChain.process((MutableMessage)new SIPMutableMessage((SipServletMessage)request));
        String callSessionId = request.getSession().getId();
        Call call = this.callManager.getCall(callSessionId);
        this.callManager.changeCallStatus(callSessionId, Call.Status.COMPLETED);
    }

    private String getCallSessionId(SipServletRequest currentRequest) {
        if (!currentRequest.getSession().isValid()) {
            return null;
        }
        SipServletRequest oRequest = (SipServletRequest)currentRequest.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        return oRequest.getSession().getId();
    }

    public void sessionCreated(SipApplicationSessionEvent ev) {
        LOG.info((Object)"Session Created ");
    }

    public void sessionDestroyed(SipApplicationSessionEvent ev) {
        LOG.info((Object)"Session Destroyed");
    }

    public void sessionExpired(SipApplicationSessionEvent ev) {
        LOG.info((Object)"Session Expired ");
    }

    public void sessionReadyToInvalidate(SipApplicationSessionEvent ev) {
        LOG.info((Object)"Session Ready to invalidate ");
    }
}

