/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc;

import com.typesafe.config.ConfigFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServlet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.log4j.Logger;
import org.restcomm.sbc.ConfigurationStringLookup;
import org.restcomm.sbc.Version;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.identity.IdentityContext;
import org.restcomm.sbc.loader.ObjectFactory;
import org.restcomm.sbc.loader.ObjectInstantiationException;
import org.restcomm.sbc.managers.Monitor;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;
import org.restcomm.sbc.managers.jmx.JMXProviderFactory;

public final class Bootstrapper
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Bootstrapper.class);

    public Bootstrapper() {
        Thread.setDefaultUncaughtExceptionHandler(new MyExceptionHandler());
    }

    public void destroy() {
    }

    private String home(ServletConfig config) {
        ServletContext context = config.getServletContext();
        String path = context.getRealPath("/");
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        String path = context.getRealPath("WEB-INF/conf/sbc.xml");
        ConfigurationStringLookup strings = new ConfigurationStringLookup();
        strings.addProperty("home", this.home(config));
        strings.addProperty("uri", this.uri(config));
        ConfigurationInterpolator.registerGlobalLookup((String)"sbc", (StrLookup)strings);
        XMLConfiguration xml = null;
        try {
            xml = new XMLConfiguration(path);
        }
        catch (ConfigurationException exception) {
            LOG.error((Object)exception);
        }
        xml.setProperty("runtime-settings.home-directory", (Object)this.home(config));
        xml.setProperty("runtime-settings.root-uri", (Object)this.uri(config));
        context.setAttribute(Configuration.class.getName(), (Object)xml);
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        ConfigFactory.load();
        DaoManager storage = null;
        try {
            storage = this.storage((Configuration)xml, loader);
        }
        catch (ObjectInstantiationException exception) {
            throw new ServletException((Throwable)exception);
        }
        context.setAttribute(DaoManager.class.getName(), (Object)storage);
        ShiroResources.getInstance().set(DaoManager.class, storage);
        ShiroResources.getInstance().set(Configuration.class, xml.subset("runtime-settings"));
        RestcommConfiguration.createOnce((Configuration)xml);
        IdentityContext identityContext = new IdentityContext((Configuration)xml);
        context.setAttribute(IdentityContext.class.getName(), (Object)identityContext);
        try {
            this.bindConnectors(storage);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        Version.printVersion();
        Monitor monitor = Monitor.getMonitor();
        monitor.start();
    }

    private void bindConnectors(DaoManager storage) throws Exception {
        JMXProvider jmxManager = null;
        jmxManager = JMXProviderFactory.getJMXProvider();
        ConnectorsDao dao = storage.getConnectorsDao();
        for (Connector connector : dao.getConnectors()) {
            String npoint = connector.getPoint();
            String ipAddress = NetworkManager.getIpAddress(npoint);
            if (connector.getState() != Connector.State.UP) continue;
            boolean status = jmxManager.addSipConnector(ipAddress, connector.getPort(), connector.getTransport().toString());
            if (status) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Binding Connector on " + npoint + ":" + ipAddress + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("CANNOT Bind Connector on " + npoint + ":" + ipAddress + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
        }
    }

    private DaoManager storage(Configuration configuration, ClassLoader loader) throws ObjectInstantiationException {
        String classpath = configuration.getString("dao-manager[@class]");
        DaoManager daoManager = (DaoManager)new ObjectFactory(loader).getObjectInstance(classpath);
        daoManager.configure(configuration.subset("dao-manager"));
        daoManager.start();
        LOG.info((Object)"DaoManager started");
        return daoManager;
    }

    private String uri(ServletConfig config) {
        return config.getServletContext().getContextPath();
    }

    class MyExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MyExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error((Object)t.getName(), e);
        }
    }
}

