/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.Immutable;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.managers.Monitor;

@Immutable
public class BanList {
    private final DateTime dateCreated;
    private final DateTime dateExpires;
    private final String ipAddress;
    private final Sid accountSid;
    private final Reason reason;
    private final Monitor.Action action;

    public BanList(DateTime dateCreated, DateTime dateExpires, String ipAddress, Sid accountSid, Reason reason, Monitor.Action action) {
        this.dateCreated = dateCreated;
        this.dateExpires = dateExpires;
        this.ipAddress = ipAddress;
        this.accountSid = accountSid;
        this.reason = reason;
        this.action = action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateExpires() {
        return this.dateExpires;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Monitor.Action getAction() {
        return this.action;
    }

    public BanList setIpAddress(String ipAddress) {
        return new BanList(DateTime.now(), DateTime.now().plusDays(1), ipAddress, this.accountSid, this.reason, this.action);
    }

    public BanList setReason(Reason reason) {
        return new BanList(DateTime.now(), DateTime.now().plusDays(1), this.ipAddress, this.accountSid, reason, this.action);
    }

    public BanList setAction(Monitor.Action action) {
        return new BanList(DateTime.now(), DateTime.now().plusDays(1), this.ipAddress, this.accountSid, this.reason, action);
    }

    public static final class Builder {
        private String ipAddress;
        private Sid accountSid;
        private Reason reason;
        private Monitor.Action action;

        private Builder() {
        }

        public BanList build() {
            DateTime now = DateTime.now();
            return new BanList(now, now.plusDays(1), this.ipAddress, this.accountSid, this.reason, this.action);
        }

        public void setipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setReason(Reason reason) {
            this.reason = reason;
        }

        public void setAction(Monitor.Action action) {
            this.action = action;
        }
    }

    public static enum Reason {
        ADMIN("Admin"),
        THREAT("Threat");

        private final String text;

        private Reason(String text) {
            this.text = text;
        }

        public static Reason getValueOf(String text) {
            Reason[] values;
            for (Reason value : values = Reason.values()) {
                if (!value.text.equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid reason.");
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Type {
        WHITE("White"),
        BLACK("Black");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public static Type getValueOf(String text) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.text.equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid type.");
        }

        public String toString() {
            return this.text;
        }
    }
}

