/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class Sid {
    public static final Pattern pattern = Pattern.compile("[a-zA-Z0-9]{34}");
    private final String id;

    public Sid(String id) throws IllegalArgumentException {
        if (!pattern.matcher(id).matches()) {
            throw new IllegalArgumentException(id + " is an INVALID_SID sid value.");
        }
        this.id = id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sid other = (Sid)object;
        return this.toString().equals(other.toString());
    }

    public static Sid generate(Type type, String string) {
        String token = new Md5Hash((Object)string).toString();
        switch (type) {
            case ACCOUNT: {
                return new Sid("AC" + token);
            }
            case CONNECTOR: {
                return new Sid("CN" + token);
            }
            case ROUTE: {
                return new Sid("RT" + token);
            }
            case RANDOM: {
                return new Sid("RN" + token);
            }
        }
        return Sid.generate(type);
    }

    public static Sid generate(Type type) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        switch (type) {
            case ACCOUNT: {
                return new Sid("AC" + uuid);
            }
            case CONNECTOR: {
                return new Sid("CN" + uuid);
            }
            case ROUTE: {
                return new Sid("RT" + uuid);
            }
            case RANDOM: {
                return new Sid("RN" + uuid);
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return this.id;
    }

    public static enum Type {
        ACCOUNT,
        CONNECTOR,
        ROUTE,
        RANDOM;

    }
}

