/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.call;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.call.CallListener;
import org.restcomm.sbc.media.MediaSession;
import org.restcomm.sbc.media.MediaSessionListener;
import org.restcomm.sbc.media.MediaZone;

public class Call
implements MediaSessionListener {
    private static transient Logger LOG = Logger.getLogger(Call.class);
    private Call parent;
    private Sid sid;
    private CallDetailRecord cdr;
    private MediaSession mediaSession;
    private Status status;
    private Direction direction;
    private String sessionId;
    private EventListenerList listenerList = new EventListenerList();

    protected Call(Call parent, String sessionId, String to, String from, String direction, String callerName) {
        this.parent = parent;
        this.sessionId = sessionId;
        this.sid = Sid.generate(Sid.Type.RANDOM);
        Sid parentCallSid = Sid.generate(Sid.Type.RANDOM);
        DateTime dateCreated = DateTime.now();
        String apiVersion = ConfigurationCache.getApiVersion();
        this.mediaSession = new MediaSession(sessionId);
        this.mediaSession.addMediaSessionListener(this);
        URI uri = null;
        try {
            uri = new URI(apiVersion + "/Calls/" + this.sid.toString());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)"Cannot Create URI");
        }
        this.direction = Direction.getValueOf(direction);
        this.status = Status.INITIATING;
        this.cdr = new CallDetailRecord(this.sid, "", parentCallSid, dateCreated, dateCreated, to, from, this.status.text, dateCreated, dateCreated, 0, new BigDecimal(0), null, direction, null, apiVersion, null, callerName, uri, null, 0, false, false);
    }

    public void addCallListener(CallListener listener) {
        this.listenerList.add(CallListener.class, listener);
    }

    public CallDetailRecord getCdr() {
        return this.cdr;
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public Status getStatus() {
        return this.status;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Sid getSid() {
        return this.sid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected void setStatus(int statusCode, String reasonPhrase) {
        if (statusCode >= 400) {
            this.setStatus(Status.FAILED);
        } else if (statusCode >= 200) {
            this.setStatus(Status.COMPLETED);
        }
    }

    protected void setStatus(Status status) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call was in status " + (Object)((Object)this.getStatus()) + ", now changing to " + status.text));
        }
        this.status = status;
        this.cdr = this.cdr.setStatus(status.text);
        switch (status) {
            case RINGING: {
                this.cdr = this.cdr.setStartTime(DateTime.now());
                break;
            }
            case BRIDGED: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Datecreated " + this.cdr.getDateCreated()));
                    LOG.trace((Object)("StartTime   " + this.cdr.getStartTime()));
                }
                this.cdr = this.cdr.setRingDuration((int)this.cdr.getStartTime().minus(this.cdr.getDateCreated().getMillis()).getMillis() / 1000);
                break;
            }
            case COMPLETED: {
                this.cdr = this.cdr.setEndTime(DateTime.now());
                this.cdr = this.cdr.setDuration((int)this.cdr.getEndTime().minus(this.cdr.getStartTime().getMillis()).getMillis() / 1000);
                break;
            }
            case FAILED: {
                this.cdr = this.cdr.setEndTime(DateTime.now());
                this.cdr = this.cdr.setDuration((int)this.cdr.getEndTime().minus(this.cdr.getStartTime().getMillis()).getMillis() / 1000);
                break;
            }
        }
    }

    public boolean equals(Object call) {
        Call otherCall = (Call)call;
        if (!(call instanceof Call)) {
            return false;
        }
        return otherCall.getSessionId().equals(this.getSessionId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = prime * result + (this.sid == null ? 0 : this.sid.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public Call getParent() {
        return this.parent;
    }

    public EventListenerList getListeners() {
        return this.listenerList;
    }

    @Override
    public void onMediaTimeout(MediaSession session, MediaZone zone) {
        if (LOG.isInfoEnabled()) {
            LOG.warn((Object)("Force ending media on " + zone.toPrint()));
        }
    }

    @Override
    public void onMediaTerminated(MediaSession mediaSession, MediaZone mediaZone) {
        if (mediaSession.isActive()) {
            mediaSession.finalize();
        }
    }

    @Override
    public void onMediaFailed(MediaSession mediaSession, MediaZone mediaZone) {
        LOG.error((Object)"MediaSession/Zone Failed!");
        if (mediaSession.isActive()) {
            mediaSession.finalize();
        }
    }

    @Override
    public void onMediaReady(MediaSession mediaSession, MediaZone mediaZone) {
        try {
            if (!mediaSession.isActive()) {
                mediaSession.start();
            }
            if (!mediaZone.isRunning()) {
                mediaZone.start();
            }
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Cannot start MediaSession/Zone", (Throwable)e);
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private final String text;

        private Direction(String text) {
            this.text = text;
        }

        public static Direction getValueOf(String text) {
            Direction[] values;
            for (Direction value : values = Direction.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid call direction.");
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Status {
        INITIATING("initiating"),
        BRIDGED("bridged"),
        COMPLETED("completed"),
        FAILED("failed"),
        RINGING("ringing"),
        ALERTING("alerting");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public static Status getValueOf(String text) {
            Status[] values;
            for (Status value : values = Status.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid call status.");
        }

        public String toString() {
            return this.text;
        }
    }
}

