/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.managers.RouteManager;

public class B2BUABuilderProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(B2BUABuilderProcessor.class);
    private LocationManager locationManager;
    private SipFactory sipFactory;
    private SipApplicationSession aSession;

    public B2BUABuilderProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
        this.locationManager = LocationManager.getLocationManager();
        this.sipFactory = ConfigurationCache.getSipFactory();
    }

    public B2BUABuilderProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processRequest(SIPMutableMessage message) {
        String route;
        SipURI toURI;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processRequest()");
        }
        SipServletRequest request = (SipServletRequest)message.getContent();
        B2buaHelper helper = request.getB2buaHelper();
        SipServletRequest newRequest = null;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        SipURI newSipToUri = toURI = (SipURI)request.getTo().getURI();
        SipURI contactURI = null;
        RouteManager routeManager = RouteManager.getRouteManager();
        Connector connector = null;
        InetSocketAddress outBoundInterface = null;
        if (message.getDirection() == 0) {
            message.setTarget(1);
            try {
                connector = routeManager.getRouteToMZ(request.getLocalAddr(), request.getLocalPort(), request.getInitialTransport());
                outBoundInterface = connector.getOutboundInterface();
                contactURI = routeManager.getContactAddress(fromURI.getUser(), fromURI.getTransportParam(), outBoundInterface);
                contactURI.setTransportParam(connector.getTransport().toString());
            }
            catch (Exception e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
            if (LOG.isTraceEnabled()) {
                headers.put(MessageUtil.B2BUA_FINGERPRINT_HEADER, Arrays.asList("Made in RequestBuilder to MZ"));
            }
            message.setTargetLocalAddress(connector.getHost());
            message.setTargetRemoteAddress(ConfigurationCache.getTargetHost());
            message.setTargetTransport(connector.getTransport().toString());
            route = "sip:" + ConfigurationCache.getTargetHost();
        } else {
            message.setTarget(0);
            Location location = null;
            try {
                location = this.locationManager.getLocation(toURI.getUser() + "@" + ConfigurationCache.getDomain());
                outBoundInterface = new InetSocketAddress(ConfigurationCache.getDomain(), request.getLocalPort());
                contactURI = routeManager.getContactAddress(fromURI.getUser(), fromURI.getTransportParam(), outBoundInterface);
                contactURI.setTransportParam(location.getTransport());
                message.setTargetLocalAddress(ConfigurationCache.getIpOfDomain());
                message.setTargetRemoteAddress(location.getHost());
                message.setTargetTransport(location.getTransport().toUpperCase());
            }
            catch (LocationNotFoundException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.error((Object)e);
                }
                SipServletResponse response = request.createResponse(403);
                try {
                    response.send();
                }
                catch (IOException e1) {
                    LOG.error((Object)"ERROR", (Throwable)e);
                }
                message.abort();
                return;
            }
            catch (NoRouteToHostException e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
            newSipToUri = this.sipFactory.createSipURI(toURI.getUser(), location.getHost());
            newSipToUri.setPort(location.getPort());
            newSipToUri.setTransportParam(location.getTransport());
            route = null;
        }
        try {
            if (request.isInitial()) {
                headers.put("Contact", Arrays.asList(contactURI.toString()));
                if (LOG.isTraceEnabled() && this.aSession != null && this.aSession.isValid()) {
                    LOG.trace((Object)("LNK " + this.aSession.getAttribute(request.getSession().getCallId())));
                }
                SipServletRequest usedRequest = null;
                if (this.aSession != null && this.aSession.isValid()) {
                    usedRequest = (SipServletRequest)this.aSession.getAttribute(request.getSession().getCallId());
                }
                if (usedRequest != null && usedRequest.getSession().isValid()) {
                    LOG.trace((Object)("REUSING SESSION REQ " + usedRequest.getCallId() + ":" + usedRequest.getHeader("CSeq")));
                    newRequest = helper.createRequest(usedRequest.getSession(), request, headers);
                    newRequest.getApplicationSession().setExpires(0);
                } else {
                    newRequest = helper.createRequest(request, true, headers);
                    newRequest.getApplicationSession().setExpires(0);
                    this.aSession = this.sipFactory.createApplicationSession();
                    this.aSession.setAttribute(request.getSession().getCallId(), (Object)newRequest);
                }
                newRequest.getSession().setOutboundInterface(outBoundInterface);
                if (route != null) {
                    newRequest.pushRoute(this.sipFactory.createAddress(route));
                } else {
                    newRequest.setRequestURI((URI)newSipToUri);
                }
            } else {
                SipSession session = request.getSession();
                SipSession linkedSession = helper.getLinkedSession(session);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("NOT Initial Request " + request.getMethod()));
                    LOG.trace((Object)("SES " + session.toString()));
                    LOG.trace((Object)("LNK " + linkedSession.toString()));
                }
                if (linkedSession == null) {
                    LOG.warn((Object)("No linked session for request " + request.getMethod()));
                    linkedSession = session;
                }
                if (request.getMethod().equals("BYE")) {
                    newRequest = linkedSession.createRequest("BYE");
                } else if (request.getMethod().equals("INVITE")) {
                    newRequest = linkedSession.createRequest("INVITE");
                } else if (request.getMethod().equals("ACK")) {
                    newRequest = linkedSession.createRequest("ACK");
                } else if (request.getMethod().equals("INFO")) {
                    newRequest = linkedSession.createRequest("INFO");
                    newRequest.setContent(request.getContent(), request.getContentType());
                } else if (request.getMethod().equals("CANCEL")) {
                    SipServletRequest originalRequest = (SipServletRequest)linkedSession.getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
                    newRequest = helper.getLinkedSipServletRequest(originalRequest).createCancel();
                } else {
                    LOG.error((Object)(request.getMethod() + " not implemented!"));
                }
            }
            newRequest.getSession().setAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR, (Object)request);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Initial Request " + request.getMethod() + " on session " + newRequest.getSession().getId()));
                LOG.trace((Object)("Routing thru outboundInterface " + outBoundInterface.toString()));
                LOG.trace((Object)("Routing To " + route));
                LOG.trace((Object)("Contact back " + contactURI.toString()));
                LOG.trace((Object)("Sending Message: \n " + newRequest.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (TooManyHopsException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (ServletParseException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        message.setContent(newRequest);
    }

    private void processResponse(SIPMutableMessage message) {
        SipServletResponse mzResponse;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
        }
        if (message.getDirection() == 0) {
            message.setTarget(1);
        } else {
            message.setTarget(0);
        }
        SipServletResponse dmzResponse = (SipServletResponse)message.getContent();
        B2buaHelper helper = dmzResponse.getRequest().getB2buaHelper();
        int statusResponse = dmzResponse.getStatus();
        String reasonResponse = dmzResponse.getReasonPhrase();
        if (dmzResponse.getStatus() == 180 && LOG.isTraceEnabled()) {
            LOG.trace((Object)"180 Detected->183");
        }
        if (dmzResponse.getStatus() == 200 && dmzResponse.getMethod().equals("REGISTER")) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Final Response Discarding dialog");
            }
            this.aSession = null;
        }
        SipServletRequest linked = helper.getLinkedSipServletRequest(dmzResponse.getRequest());
        SipSession originalSession = helper.getLinkedSession(dmzResponse.getSession());
        if (linked != null) {
            message.setTargetLocalAddress(linked.getLocalAddr());
            message.setTargetRemoteAddress(linked.getRemoteAddr());
            message.setTargetTransport(linked.getTransport().toUpperCase());
            mzResponse = linked.createResponse(statusResponse, reasonResponse);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Reusing linked session");
            }
        } else {
            message.setTargetLocalAddress(dmzResponse.getLocalAddr());
            message.setTargetRemoteAddress(dmzResponse.getRemoteAddr());
            message.setTargetTransport(dmzResponse.getTransport().toUpperCase());
            mzResponse = helper.createResponseToOriginalRequest(originalSession, statusResponse, reasonResponse);
            LOG.warn((Object)">>>>>>>>>>>>Must Abort Message flow?, No linked Session available.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("mz Response created for session " + originalSession.getId()));
        }
        try {
            if (dmzResponse.getContent() != null) {
                mzResponse.setContent(dmzResponse.getContent(), dmzResponse.getContentType());
            }
            mzResponse.setHeaderForm(dmzResponse.getHeaderForm());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        if (dmzResponse.getStatus() == 407) {
            mzResponse.setHeader("Proxy-Authenticate", dmzResponse.getHeader("Proxy-Authenticate"));
        } else if (dmzResponse.getStatus() == 401) {
            mzResponse.setHeader("WWW-Authenticate", dmzResponse.getHeader("WWW-Authenticate"));
        }
        mzResponse.getSession().setAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR, (Object)dmzResponse.getRequest());
        message.setContent(mzResponse);
    }

    @Override
    public String getName() {
        return "B2BUA leg builder Processor";
    }

    @Override
    public int getId() {
        return this.hashCode();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = (SipServletMessage)message.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("-------" + sm.getLocalAddr() + "->" + sm.getRemoteAddr()));
            LOG.trace((Object)("-------Receiving message: \n" + sm));
        }
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

