/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.io.IOException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.call.CallManager;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.managers.RouteManager;
import org.restcomm.sbc.media.MediaSession;

public class IncomingDPIProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(IncomingDPIProcessor.class);

    public IncomingDPIProcessor(ProcessorChain callback) {
        super(callback);
    }

    public IncomingDPIProcessor(String name, ProcessorChain callback) {
        super(name, callback);
    }

    @Override
    public String getName() {
        return "Incoming DPI Processor";
    }

    @Override
    public int getId() {
        return this.hashCode();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void processMessage(SIPMutableMessage message) {
        if (RouteManager.isFromDMZ(message.getContent())) {
            message.setDirection(0);
        } else {
            message.setDirection(1);
        }
        message.setTarget(2);
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        m.setSourceLocalAddress(sm.getLocalAddr());
        m.setSourceRemoteAddress(sm.getRemoteAddr());
        m.setSourceTransport(sm.getTransport() == null ? "UDP" : sm.getTransport().toUpperCase());
        if (sm.getContentLength() > 0 && sm.getContentType().equals("application/sdp")) {
            try {
                MediaSession mediaSession;
                if (sm instanceof SipServletRequest) {
                    mediaSession = CallManager.getCallManager().getMediaSession(sm.getSession().getId());
                    mediaSession.buildOffer(new String(sm.getRawContent()));
                } else {
                    SipServletResponse response = (SipServletResponse)sm;
                    String callSessionId = this.getCallSessionId(response.getRequest());
                    mediaSession = CallManager.getCallManager().getMediaSession(callSessionId);
                    mediaSession.buildAnswer(new String(sm.getRawContent()));
                }
                m.setMetadata(mediaSession);
            }
            catch (IOException | SdpException e) {
                LOG.error((Object)"Invalid MediaMetadata!", e);
            }
        }
        this.processMessage(m);
    }

    private String getCallSessionId(SipServletRequest currentRequest) {
        SipServletRequest oRequest = (SipServletRequest)currentRequest.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        return oRequest.getSession().getId();
    }
}

