/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.util.List;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.managers.LocationManager;

public class NATHelperProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(NATHelperProcessor.class);
    private LocationManager locationManager = LocationManager.getLocationManager();

    public NATHelperProcessor(ProcessorChain callback) {
        super(callback);
    }

    public NATHelperProcessor(String name, ProcessorChain callback) {
        super(name, callback);
    }

    @Override
    public String getName() {
        return "NAT Helper Processor";
    }

    @Override
    public int getId() {
        return this.hashCode();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void processResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        SipServletRequest request = response.getRequest();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
            LOG.trace((Object)(">> request Coming from host: " + request.getRemoteHost()));
            LOG.trace((Object)(">> request Coming from port: " + request.getRemotePort()));
        }
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        SipURI contactURI = null;
        if (this.isRoutedAddress(request.getRemoteHost())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("RouteAddress " + request.getRemoteHost() + " MUST not be fixed " + fromURI.toString()));
            }
            return;
        }
        contactURI = ConfigurationCache.getSipFactory().createSipURI(fromURI.getUser(), request.getRemoteHost());
        contactURI.setPort(request.getRemotePort());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Patching NATed Contact Address to: " + contactURI.toString()));
        }
        try {
            if (response.getMethod().equals("REGISTER")) {
                if (!response.getAddressHeaders("Contact").hasNext()) {
                    response.setAddressHeader("Contact", ConfigurationCache.getSipFactory().createAddress((URI)contactURI));
                } else {
                    LOG.warn((Object)("Contact address exists, CANNOT patch NATed Contact Address to: " + contactURI.toString()));
                }
            }
        }
        catch (ServletParseException e) {
            LOG.error((Object)("CANNOT Patch NATed Contact Address to: " + contactURI.toString()), (Throwable)e);
        }
        message.setContent(response);
    }

    private void processRequest(SIPMutableMessage message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)message.toString());
        }
        SipServletRequest request = (SipServletRequest)message.getContent();
        SipURI toURI = (SipURI)request.getTo().getURI();
        if (!request.isInitial() && message.getDirection() == 1) {
            Location location = null;
            try {
                location = this.locationManager.getLocation(toURI.getUser(), ConfigurationCache.getDomain());
            }
            catch (LocationNotFoundException e) {
                LOG.error((Object)"User not found!", (Throwable)e);
                return;
            }
            if (this.isRoutedAddress(request.getRemoteHost())) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("RouteAddress " + location.getHost() + " MUST not be fixed " + location.getHost()));
                }
                return;
            }
            toURI.setHost(location.getHost());
            toURI.setPort(location.getPort());
            toURI.setTransportParam(location.getTransport());
            request.setRequestURI((URI)toURI);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Patching NATed Contact requestURI: " + toURI.toString()));
            }
        }
        message.setContent(request);
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    private boolean isRoutedAddress(String ipAddress) {
        List<String> localNetworks = ConfigurationCache.getLocalNetworks();
        for (String localNetwork : localNetworks) {
            SubnetUtils utils;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Traversing localNetworks " + localNetwork));
            }
            if ((utils = new SubnetUtils(localNetwork)).getInfo().isInRange(ipAddress)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ipAddress " + ipAddress + " Is in network " + localNetwork));
                }
                return true;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("ipAddress " + ipAddress + " Is NOT in network " + localNetwork));
        }
        return false;
    }
}

