/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.options;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.managers.RouteManager;

public class OptionsProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(OptionsProcessor.class);
    private String name = "OPTIONS Processor";

    public OptionsProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public OptionsProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        LocationManager locationManager = LocationManager.getLocationManager();
        String user = RouteManager.isFromDMZ((SipServletMessage)request) ? ((SipURI)request.getFrom().getURI()).getUser() : ((SipURI)request.getTo().getURI()).getUser();
        SipServletResponse response = !locationManager.exists(user, ConfigurationCache.getDomain()) ? request.createResponse(404, "Not found") : request.createResponse(200, "Ok");
        message.setContent(response);
    }

    private void processResponse(SIPMutableMessage message) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.hashCode();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> doProcess()");
        }
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

