/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.BlackListDao;
import org.restcomm.sbc.dao.CallDetailRecordsDao;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.NetworkPointsDao;
import org.restcomm.sbc.dao.RoutesDao;
import org.restcomm.sbc.dao.StatisticsDao;
import org.restcomm.sbc.dao.WhiteListDao;
import org.restcomm.sbc.dao.mybatis.MybatisAccountsDao;
import org.restcomm.sbc.dao.mybatis.MybatisBlackListDao;
import org.restcomm.sbc.dao.mybatis.MybatisCallDetailRecordsDao;
import org.restcomm.sbc.dao.mybatis.MybatisConnectorsDao;
import org.restcomm.sbc.dao.mybatis.MybatisNetworkPointsDao;
import org.restcomm.sbc.dao.mybatis.MybatisRoutesDao;
import org.restcomm.sbc.dao.mybatis.MybatisStatisticsDao;
import org.restcomm.sbc.dao.mybatis.MybatisWhiteListDao;

@ThreadSafe
public final class MybatisDaoManager
implements DaoManager {
    private Configuration configuration;
    private AccountsDao accountsDao;
    private CallDetailRecordsDao callDetailRecordsDao;
    private WhiteListDao whiteListDao;
    private BlackListDao blackListDao;
    private NetworkPointsDao networkPointDao;
    private ConnectorsDao connectorDao;
    private RoutesDao routesDao;
    private StatisticsDao statisticsDao;

    @Override
    public RoutesDao getRoutesDao() {
        return this.routesDao;
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public AccountsDao getAccountsDao() {
        return this.accountsDao;
    }

    @Override
    public CallDetailRecordsDao getCallDetailRecordsDao() {
        return this.callDetailRecordsDao;
    }

    @Override
    public WhiteListDao getWhiteListDao() {
        return this.whiteListDao;
    }

    @Override
    public BlackListDao getBlackListDao() {
        return this.blackListDao;
    }

    @Override
    public NetworkPointsDao getNetworkPointDao() {
        return this.networkPointDao;
    }

    @Override
    public ConnectorsDao getConnectorsDao() {
        return this.connectorDao;
    }

    @Override
    public StatisticsDao getStatisticsDao() {
        return this.statisticsDao;
    }

    public void shutdown() {
    }

    public void start() throws RuntimeException {
        LogFactory.useLog4JLogging();
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        String path = this.configuration.getString("configuration-file");
        FileReader reader = null;
        try {
            reader = new FileReader(path);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        Properties properties = new Properties();
        String dataFiles = this.configuration.getString("data-files");
        String sqlFiles = this.configuration.getString("sql-files");
        properties.setProperty("data", dataFiles);
        properties.setProperty("sql", sqlFiles);
        SqlSessionFactory sessions = builder.build((Reader)reader, properties);
        this.start(sessions);
    }

    public void start(SqlSessionFactory sessions) {
        this.accountsDao = new MybatisAccountsDao(sessions);
        this.callDetailRecordsDao = new MybatisCallDetailRecordsDao(sessions);
        this.whiteListDao = new MybatisWhiteListDao(sessions);
        this.blackListDao = new MybatisBlackListDao(sessions);
        this.networkPointDao = new MybatisNetworkPointsDao(sessions);
        this.connectorDao = new MybatisConnectorsDao(sessions);
        this.routesDao = new MybatisRoutesDao(sessions);
        this.statisticsDao = new MybatisStatisticsDao(sessions);
    }
}

