/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.crypto.CipherSuite;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionDescriptionParser;
import org.mobicents.media.server.io.sdp.attributes.RtpMapAttribute;
import org.mobicents.media.server.io.sdp.fields.ConnectionField;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.fields.OriginField;
import org.mobicents.media.server.io.sdp.fields.SessionNameField;
import org.mobicents.media.server.io.sdp.format.AVProfile;
import org.mobicents.media.server.io.sdp.format.RTPFormat;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.media.CryptoMediaZone;
import org.restcomm.sbc.media.MediaSession;
import org.restcomm.sbc.media.MediaZone;

public class MediaController {
    private static transient Logger LOG = Logger.getLogger(MediaController.class);
    public static final String MEDIATYPE_AUDIO = "audio";
    public static final String MEDIATYPE_VIDEO = "video";
    public static final String MEDIATYPE_MESSAGE = "message";
    static String[] supportedMediaTypes = new String[]{"audio", "video", "message"};
    private SessionDescription sdp;
    private MediaZone.Direction direction;
    private MediaSession mediaSession;
    private ConcurrentHashMap<String, MediaZone> mediaZones = new ConcurrentHashMap();
    private SessionDescription secureSdp;

    public SessionDescription getSdp() {
        return this.sdp;
    }

    public MediaController(MediaSession session, MediaZone.Direction direction, String sdpText) throws SdpException, UnknownHostException {
        this.mediaSession = session;
        this.sdp = SessionDescriptionParser.parse((String)sdpText);
        this.direction = direction;
        this.buildMediaZones();
    }

    public String toPrint() {
        return "[MediaController MS:" + this.mediaSession.getSessionId() + " (" + (Object)((Object)this.direction) + ")]";
    }

    private void buildMediaZones() throws UnknownHostException, SdpException {
        for (int type = 0; type < supportedMediaTypes.length; ++type) {
            MediaZone mediaZone;
            MediaDescriptionField mediaDescription = this.sdp.getMediaDescription(supportedMediaTypes[type]);
            if (mediaDescription == null) {
                LOG.warn((Object)("No media type " + supportedMediaTypes[type]));
                continue;
            }
            boolean canMux = mediaDescription.isRtcpMux();
            int rtpPort = mediaDescription.getPort();
            int rtcpPort = mediaDescription.getRtcpPort();
            if (rtpPort == 0) continue;
            String ip = this.sdp.getConnection() != null ? this.sdp.getConnection().getAddress() : mediaDescription.getConnection().getAddress();
            if (mediaDescription.getProtocol().equals("RTP/AVP")) {
                mediaZone = new MediaZone(this, this.direction, supportedMediaTypes[type], ip, rtpPort, rtcpPort, canMux, this.mediaSession.proxyPorts[type]);
            } else {
                if (!supportedMediaTypes[type].equals(MEDIATYPE_AUDIO)) continue;
                mediaZone = new CryptoMediaZone(this, this.direction, supportedMediaTypes[type], ip, rtpPort, rtcpPort, canMux, this.mediaSession.proxyPorts[type]);
            }
            this.mediaZones.put(supportedMediaTypes[type], mediaZone);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Adding MediaZone " + mediaZone.toPrint()));
        }
    }

    public boolean isOffer() {
        return this.direction == MediaZone.Direction.OFFER;
    }

    public boolean isSecure(String mediaType) {
        return !this.sdp.getMediaDescription(mediaType).getProtocol().equals("RTP/AVP");
    }

    public boolean isSecure() {
        return this.isSecure(MEDIATYPE_AUDIO);
    }

    public void attach(MediaController peerController) {
        for (MediaZone zone : this.mediaZones.values()) {
            MediaZone peerZone = peerController.getMediaZone(zone.getMediaType());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Attaching " + zone.toPrint()));
                LOG.trace((Object)("with      " + peerZone.toPrint()));
            }
            zone.attach(peerZone);
        }
    }

    public MediaZone checkStreaming() {
        for (MediaZone zone : this.mediaZones.values()) {
            if (zone.isStreaming()) continue;
            return zone;
        }
        return null;
    }

    public synchronized void finalize() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finalizing " + this.toPrint()));
        }
        for (MediaZone zone : this.mediaZones.values()) {
            this.finalize(zone);
        }
        this.mediaZones.clear();
    }

    public synchronized void finalize(MediaZone zone) {
        zone.finalize();
        this.mediaZones.remove(zone.getMediaType());
    }

    public MediaZone getMediaZone(String mediaType) {
        return this.mediaZones.get(mediaType);
    }

    public void setLocalProxy(String proxyHost) throws UnknownHostException, SocketException {
        for (MediaZone zone : this.mediaZones.values()) {
            zone.setLocalProxy(proxyHost);
        }
    }

    public String getProxySdp(String proxyHost) throws SdpException {
        return this.patchIPAddressAndPort(false, this.sdp.toString(), proxyHost);
    }

    public String getUnsecureProxySdp(String proxyHost) throws SdpException {
        if (ConfigurationCache.isMediaDecodingEnabled()) {
            return this.patchIPAddressAndPort(true, this.sdp.toString(), proxyHost);
        }
        return this.patchIPAddressAndPort(false, this.sdp.toString(), proxyHost);
    }

    public String getSecureProxySdp(String proxyHost) throws SdpException {
        return this.getSecureSdp().toString().trim().concat("\n");
    }

    public String getUnsecureSdp() throws SdpException {
        if (ConfigurationCache.isMediaDecodingEnabled()) {
            return this.patchIPAddressAndPort(true, this.sdp.toString(), null);
        }
        return this.patchIPAddressAndPort(false, this.sdp.toString(), null);
    }

    public MediaController getOtherParty() {
        if (this.direction == MediaZone.Direction.ANSWER) {
            return this.mediaSession.getOffer();
        }
        return this.mediaSession.getAnswer();
    }

    private String patchIPAddressAndPort(boolean unsecure, String sdp2Patch, String ip) throws SdpException {
        SessionDescription psdp = SessionDescriptionParser.parse((String)sdp2Patch);
        OriginField origin = psdp.getOrigin();
        if (ip != null) {
            origin.setAddress(ip);
        }
        psdp.setOrigin(origin);
        SessionNameField sessionName = new SessionNameField("SBC Call " + (unsecure ? "unsecure " : "secure "));
        psdp.setSessionName(sessionName);
        ConnectionField connection = new ConnectionField();
        if (ip != null) {
            connection.setAddress(ip);
        }
        if (psdp.getConnection() != null && ip != null) {
            psdp.setConnection(connection);
        }
        for (int type = 0; type < supportedMediaTypes.length; ++type) {
            MediaZone zone = this.mediaZones.get(supportedMediaTypes[type]);
            if (zone == null) {
                LOG.warn((Object)("skipping MediaZone " + supportedMediaTypes[type]));
                continue;
            }
            MediaDescriptionField mediaDescription = psdp.getMediaDescription(supportedMediaTypes[type]);
            if (mediaDescription == null) continue;
            if (unsecure) {
                mediaDescription.removeAllCandidates();
                mediaDescription.setProtocol("RTP/AVP");
            }
            if (ip != null) {
                mediaDescription.setConnection(connection);
            }
            if (zone.getProxyPort() == 0) {
                LOG.warn((Object)"Cannot Patch ProxyPort == 0 ");
            }
            if (mediaDescription.getPort() == 0) continue;
            mediaDescription.setPort(zone.getProxyPort());
        }
        return psdp.toString().trim().concat("\n");
    }

    public RTPFormats getNegociatedFormats() {
        RTPFormats rtpFormats = new RTPFormats();
        MediaDescriptionField description = this.sdp.getMediaDescription(MEDIATYPE_AUDIO);
        RtpMapAttribute[] formats = description.getFormats();
        for (int index = 0; index < formats.length; ++index) {
            RTPFormat f = AVProfile.audio.find(formats[index].getPayloadType());
            if (f == null) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Adding mediaFormat " + f.toString()));
            }
            rtpFormats.add(f);
        }
        return rtpFormats;
    }

    public void setSecureSdp(SessionDescription sd) {
        this.secureSdp = sd;
    }

    public SessionDescription getSecureSdp() {
        return this.secureSdp;
    }

    public boolean equals(Object controller) {
        MediaController otherController = (MediaController)controller;
        if (!(controller instanceof MediaController)) {
            return false;
        }
        return otherController.getSdp().equals(this.getSdp()) && otherController.getMediaSession().equals(this.getMediaSession()) && otherController.direction.equals((Object)this.direction);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.mediaSession == null ? 0 : this.mediaSession.hashCode());
        result = prime * result + (this.sdp == null ? 0 : this.sdp.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public static void main(String[] argv) {
        String sdpText = "v=0\no=12-jitsi.org 0 0 IN IP4 192.168.88.3\ns=SBC Call\nc=IN IP4 192.168.88.3\nt=0 0\nm=audio 5020 UDP/TLS/RTP/SAVP 96 97 98 9 100 102 0 8 103 3 104 4 101\na=rtpmap:96 opus/48000/2\na=fmtp:96 usedtx=1\na=rtpmap:97 SILK/24000\na=rtpmap:98 SILK/16000\na=rtpmap:9 G722/8000\na=rtpmap:100 speex/32000\na=rtpmap:102 speex/16000\na=rtpmap:0 PCMU/8000\na=rtpmap:8 PCMA/8000\na=rtpmap:103 iLBC/8000\na=rtpmap:3 GSM/8000\na=rtpmap:104 speex/8000\na=rtpmap:4 G723/8000\na=fmtp:4 annexa=no;bitrate=6.3\na=rtpmap:101 telephone-event/8000\na=extmap:1 urn:ietf:params:rtp-hdrext:csrc-audio-level\na=extmap:2 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=rtcp-xr:voip-metrics\na=setup:actpass\na=fingerprint:sha-1 31:1A:85:0F:02:85:58:C4:1B:35:E9:BB:E2:D8:79:27:18:AD:E0:5F\nm=audio 5020 RTP/SAVPF 96 97 98 9 100 102 0 8 103 3 104 4 101\na=rtpmap:96 opus/48000/2\na=fmtp:96 usedtx=1\na=rtpmap:97 SILK/24000\na=rtpmap:98 SILK/16000\na=rtpmap:9 G722/8000\na=rtpmap:100 speex/32000\na=rtpmap:102 speex/16000\na=rtpmap:0 PCMU/8000\na=rtpmap:8 PCMA/8000\na=rtpmap:103 iLBC/8000\na=rtpmap:3 GSM/8000\na=rtpmap:104 speex/8000\na=rtpmap:4 G723/8000\na=fmtp:4 annexa=no;bitrate=6.3\na=rtpmap:101 telephone-event/8000\na=extmap:1 urn:ietf:params:rtp-hdrext:csrc-audio-level\na=extmap:2 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=rtcp-xr:voip-metrics\na=setup:actpass\na=fingerprint:sha-1 31:1A:85:0F:02:85:58:C4:1B:35:E9:BB:E2:D8:79:27:18:AD:E0:5F\nm=video 5022 UDP/TLS/RTP/SAVP 105 99 106 107 108 109\na=recvonly\na=rtpmap:105 H264/90000\na=fmtp:105 profile-level-id=4DE01f;packetization-mode=1\na=imageattr:105 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:99 H264/90000\na=fmtp:99 profile-level-id=4DE01f\na=imageattr:99 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:106 H263-1998/90000\na=fmtp:106 CUSTOM=1680,1050,2;VGA=2;CIF=1;QCIF=1\na=rtpmap:107 red/90000\na=rtpmap:108 ulpfec/90000\na=rtpmap:109 VP8/90000\na=setup:actpass\na=fingerprint:sha-1 E6:CE:47:0E:64:5D:EF:9B:08:B3:34:D1:72:3E:46:48:BD:6E:62:47\nm=video 5022 RTP/SAVPF 105 99 106 107 108 109\na=recvonly\na=rtpmap:105 H264/90000\na=fmtp:105 profile-level-id=4DE01f;packetization-mode=1\na=imageattr:105 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:99 H264/90000\na=fmtp:99 profile-level-id=4DE01f\na=imageattr:99 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:106 H263-1998/90000\na=fmtp:106 CUSTOM=1680,1050,2;VGA=2;CIF=1;QCIF=1\na=rtpmap:107 red/90000\na=rtpmap:108 ulpfec/90000\na=rtpmap:109 VP8/90000\na=setup:actpass\na=fingerprint:sha-1 E6:CE:47:0E:64:5D:EF:9B:08:B3:34:D1:72:3E:46:48:BD:6E:62:47";
        try {
            MediaSession session = new MediaSession("ID");
            String sdpOffer = "v=0\no=22-jitsi.org 0 0 IN IP4 10.0.0.10\ns=- \nc=IN IP4 10.0.0.10\nt=0 0\nm=audio 5082 RTP/AVP 8 96 97 98 9 100 102 103 3 104 101\na=rtpmap:8 PCMA/8000\na=rtpmap:96 opus/48000/2\na=fmtp:96 usedtx=1\na=rtpmap:97 SILK/24000\na=rtpmap:98 SILK/16000\na=rtpmap:9 G722/8000\na=rtpmap:100 speex/32000\na=rtpmap:102 speex/16000\na=rtpmap:103 iLBC/8000\na=rtpmap:3 GSM/8000\na=rtpmap:104 speex/8000\na=rtpmap:101 telephone-event/8000\na=extmap:1 urn:ietf:params:rtp-hdrext:csrc-audio-level\na=extmap:2 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=rtcp-xr:voip-metrics\nm=video 5084 RTP/AVP 105 99 106\na=rtpmap:105 H264/90000\na=fmtp:105 profile-level-id=4DE01f;packetization-mode=1\na=imageattr:105 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:99 H264/90000\na=fmtp:99 profile-level-id=4DE01f\na=imageattr:99 send * recv [x=[0-1680],y=[0-1050]]\na=rtpmap:106 H263-1998/90000\na=fmtp:106 CUSTOM=1680,1050,2;VGA=2;CIF=1;QCIF=1\n";
            MediaController offer = session.buildOffer(sdpOffer);
            String sdpAnswer = "v=0\no=root 1373078659 1373078659 IN IP4 192.168.120.96\ns=eolosCM-2.6\nc=IN IP4 192.168.120.96\nb=CT:384\nt=0 0\nm=audio 17252 RTP/AVP 8 3\na=rtpmap:8 PCMA/8000\na=rtpmap:3 GSM/8000\na=ptime:20\na=sendrecv\nm=video 14906 RTP/AVP 106 99\na=rtpmap:106 h263-1998/90000\na=rtpmap:99 H264/90000\na=sendrecv\n";
            MediaController answer = session.buildAnswer(sdpAnswer);
            offer.setLocalProxy("127.0.0.1");
            String sdpContent = offer.getProxySdp("1.1.1.1");
            session.attach();
            answer.setLocalProxy("192.168.88.3");
            sdpContent = answer.getProxySdp("2.2.2.2");
            System.out.println(answer.getMediaZone(MEDIATYPE_AUDIO).toPrint());
            System.out.println(answer.getMediaZone(MEDIATYPE_VIDEO).toPrint());
            System.out.println(offer.getMediaZone(MEDIATYPE_AUDIO).toPrint());
            System.out.println(offer.getMediaZone(MEDIATYPE_VIDEO).toPrint());
            System.out.println("---------------original-------------------");
            System.out.println(offer.getSdp().toString());
            String unsecure = offer.getUnsecureSdp();
            System.out.println("---------------unsecure-------------------");
            System.out.println(unsecure);
            String upatched = offer.getUnsecureProxySdp("201.216.233.187");
            System.out.println("---------------unsecure patched---------------------");
            System.out.println(upatched);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    class Crypto {
        private int tag;
        private CipherSuite cryptoSuite;
        private String keyParams;

        Crypto(String line) {
            String[] fields = line.split("inline:");
            this.keyParams = fields[1];
            String[] crypto = fields[0].split(" ");
            this.tag = Integer.parseInt(crypto[0]);
            this.cryptoSuite = CipherSuite.TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
        }

        public int getTag() {
            return this.tag;
        }

        public void setTag(int tag) {
            this.tag = tag;
        }

        public CipherSuite getCryptoSuite() {
            return this.cryptoSuite;
        }

        public void setCryptoSuite(CipherSuite cryptoSuite) {
            this.cryptoSuite = cryptoSuite;
        }

        public String getKeyParams() {
            return this.keyParams;
        }

        public void setKeyParams(String keyParams) {
            this.keyParams = keyParams;
        }

        public String toString() {
            return "Crypto [tag=" + this.tag + ", crypto-suite=" + this.cryptoSuite + ", key=" + this.keyParams + "]";
        }
    }
}

