/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import org.mobicents.media.server.io.sdp.MediaProfile;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionLevelAccessor;
import org.mobicents.media.server.io.sdp.attributes.ConnectionModeAttribute;
import org.mobicents.media.server.io.sdp.attributes.FormatParameterAttribute;
import org.mobicents.media.server.io.sdp.attributes.PacketTimeAttribute;
import org.mobicents.media.server.io.sdp.attributes.RtpMapAttribute;
import org.mobicents.media.server.io.sdp.attributes.SsrcAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.SetupAttribute;
import org.mobicents.media.server.io.sdp.fields.ConnectionField;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.fields.OriginField;
import org.mobicents.media.server.io.sdp.fields.SessionNameField;
import org.mobicents.media.server.io.sdp.fields.TimingField;
import org.mobicents.media.server.io.sdp.fields.VersionField;
import org.mobicents.media.server.io.sdp.format.AVProfile;
import org.mobicents.media.server.io.sdp.format.RTPFormat;
import org.mobicents.media.server.io.sdp.ice.attributes.CandidateAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceLiteAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IcePwdAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceUfragAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpMuxAttribute;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.restcomm.sbc.media.MediaChannel;

public class SdpFactory {
    public static SessionDescription buildSdp(boolean offer, String localAddress, String externalAddress, MediaChannel ... channels) {
        SessionDescription sd = new SessionDescription();
        sd.setVersion(new VersionField(0));
        String originAddress = externalAddress == null || externalAddress.isEmpty() ? localAddress : externalAddress;
        sd.setOrigin(new OriginField("-", String.valueOf(System.currentTimeMillis()), "1", "IN", "IP4", originAddress));
        sd.setSessionName(new SessionNameField("SBC Media Server"));
        sd.setConnection(new ConnectionField("IN", "IP4", originAddress));
        sd.setTiming(new TimingField(0, 0));
        boolean ice = false;
        for (MediaChannel channel : channels) {
            MediaDescriptionField md = SdpFactory.buildMediaDescription(channel, offer);
            md.setSession((SessionLevelAccessor)sd);
            sd.addMediaDescription(md);
            if (!md.containsIce()) continue;
            sd.getConnection().setAddress(md.getConnection().getAddress());
            ice = true;
        }
        if (ice) {
            sd.setIceLite(new IceLiteAttribute());
        }
        return sd;
    }

    public static void rejectMediaField(SessionDescription answer, MediaDescriptionField media) {
        MediaDescriptionField rejected = new MediaDescriptionField();
        rejected.setMedia(media.getMedia());
        rejected.setPort(0);
        rejected.setProtocol(media.getProtocol());
        rejected.setPayloadTypes(media.getPayloadTypes());
        rejected.setSession((SessionLevelAccessor)answer);
        answer.addMediaDescription(rejected);
    }

    public static MediaDescriptionField buildMediaDescription(MediaChannel channel, boolean offer) {
        MediaDescriptionField md = new MediaDescriptionField();
        md.setMedia(channel.getMediaType());
        md.setPort(channel.getRtpPort());
        MediaProfile profile = channel.isDtlsEnabled() ? MediaProfile.RTP_SAVPF : MediaProfile.RTP_AVP;
        md.setProtocol(profile.getProfile());
        String externalAddress = channel.getExternalAddress() == null || channel.getExternalAddress().isEmpty() ? null : channel.getExternalAddress();
        md.setConnection(new ConnectionField("IN", "IP4", externalAddress != null ? externalAddress : channel.getRtpAddress()));
        md.setPtime(new PacketTimeAttribute(20));
        md.setRtcp(new RtcpAttribute(channel.getRtcpPort(), "IN", "IP4", externalAddress != null ? externalAddress : channel.getRtcpAddress()));
        if (channel.isRtcpMux()) {
            md.setRtcpMux(new RtcpMuxAttribute());
        }
        if (channel.isIceEnabled()) {
            md.setIceUfrag(new IceUfragAttribute(channel.getIceUfrag()));
            md.setIcePwd(new IcePwdAttribute(channel.getIcePwd()));
            md.getConnection().setAddress(externalAddress != null ? externalAddress : channel.getRtpAddress());
            md.setPort(channel.getRtpPort());
            if (channel.isRtcpMux()) {
                md.getRtcp().setAddress(externalAddress != null ? externalAddress : channel.getRtpAddress());
                md.getRtcp().setPort(channel.getRtpPort());
            }
            md.addCandidate(SdpFactory.processHostCandidate(channel, (short)1));
            if (!channel.isRtcpMux()) {
                md.addCandidate(SdpFactory.processHostCandidate(channel, (short)2));
            }
            if (channel.getExternalAddress() != null && !channel.getExternalAddress().isEmpty()) {
                md.addCandidate(SdpFactory.processSrflxCandidate(channel, (short)1));
                if (!channel.isRtcpMux()) {
                    md.addCandidate(SdpFactory.processSrflxCandidate(channel, (short)2));
                }
            }
        }
        RTPFormat[] negotiatedFormats = channel.getFormats().toArray();
        for (int index = 0; index < negotiatedFormats.length; ++index) {
            RTPFormat f = negotiatedFormats[index];
            if (offer && AVProfile.isDtmf((RTPFormat)f) && !AVProfile.isDefaultDtmf((RTPFormat)f)) continue;
            RtpMapAttribute rtpMap = new RtpMapAttribute();
            rtpMap.setPayloadType(f.getID());
            rtpMap.setCodec(f.getFormat().getName().toString());
            rtpMap.setClockRate(f.getClockRate());
            switch (channel.getMediaType()) {
                case "audio": {
                    AudioFormat audioFormat = (AudioFormat)f.getFormat();
                    if (audioFormat.getChannels() > 1) {
                        rtpMap.setCodecParams(audioFormat.getChannels());
                    }
                    if (audioFormat.getOptions() == null) break;
                    rtpMap.setParameters(new FormatParameterAttribute(f.getID(), audioFormat.getOptions().toString()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Media type " + channel.getMediaType() + " not supported.");
                }
            }
            md.addPayloadType(f.getID());
            md.addFormat(rtpMap);
        }
        if (channel.isDtlsEnabled()) {
            md.setSetup(new SetupAttribute(offer ? "actpass" : "passive"));
            String fingerprint = channel.getDtlsFingerprint();
            int whitespace = fingerprint.indexOf(" ");
            String fingerprintHash = fingerprint.substring(0, whitespace);
            String fingerprintValue = fingerprint.substring(whitespace + 1);
            md.setFingerprint(new FingerprintAttribute(fingerprintHash, fingerprintValue));
        }
        md.setConnectionMode(new ConnectionModeAttribute("sendrecv"));
        SsrcAttribute ssrcAttribute = new SsrcAttribute(Long.toString(channel.getSsrc()));
        ssrcAttribute.addAttribute("cname", channel.getCname());
        md.setSsrc(ssrcAttribute);
        return md;
    }

    private static CandidateAttribute processHostCandidate(MediaChannel candidate, short componentId) {
        CandidateAttribute candidateSdp = new CandidateAttribute();
        candidateSdp.setFoundation("11111111");
        candidateSdp.setComponentId(componentId);
        candidateSdp.setProtocol("udp");
        candidateSdp.setPriority(1L);
        switch (componentId) {
            case 1: {
                candidateSdp.setAddress(candidate.getRtpAddress());
                candidateSdp.setPort(candidate.getRtpPort());
                break;
            }
            case 2: {
                candidateSdp.setAddress(candidate.getRtcpAddress());
                candidateSdp.setPort(candidate.getRtcpPort());
                break;
            }
        }
        candidateSdp.setCandidateType("host");
        candidateSdp.setGeneration(0);
        return candidateSdp;
    }

    private static CandidateAttribute processSrflxCandidate(MediaChannel candidate, short componentId) {
        CandidateAttribute candidateSdp = SdpFactory.processHostCandidate(candidate, componentId);
        candidateSdp.setCandidateType("srflx");
        candidateSdp.setAddress(candidate.getExternalAddress());
        switch (componentId) {
            case 1: {
                candidateSdp.setRelatedAddress(candidate.getRtpAddress());
                candidateSdp.setRelatedPort(candidate.getRtpPort());
                break;
            }
            case 2: {
                candidateSdp.setRelatedPort(candidate.getRtcpPort());
                candidateSdp.setRelatedPort(candidate.getRtcpPort());
                break;
            }
        }
        return candidateSdp;
    }
}

