/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.dtls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsECCUtils;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.UseSRTPData;
import org.bouncycastle.util.Arrays;
import org.mobicents.media.server.impl.rtp.crypto.AlgorithmCertificate;
import org.mobicents.media.server.impl.rtp.crypto.CipherSuite;
import org.mobicents.media.server.impl.rtp.crypto.SRTPParameters;
import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;
import org.restcomm.sbc.media.dtls.TlsUtils;

public class DtlsSrtpServer
extends DefaultTlsServer {
    private static final Logger LOGGER = Logger.getLogger(DtlsSrtpServer.class);
    private final String[] certificateResources;
    private final String keyResource;
    private final AlgorithmCertificate algorithmCertificate;
    private String hashFunction = "";
    private UseSRTPData serverSrtpData;
    private byte[] srtpMasterClientKey;
    private byte[] srtpMasterServerKey;
    private byte[] srtpMasterClientSalt;
    private byte[] srtpMasterServerSalt;
    private SRTPPolicy srtpPolicy;
    private SRTPPolicy srtcpPolicy;
    private final ProtocolVersion minVersion;
    private final ProtocolVersion maxVersion;
    private final CipherSuite[] cipherSuites;

    public DtlsSrtpServer(ProtocolVersion minVersion, ProtocolVersion maxVersion, CipherSuite[] cipherSuites, String[] certificatesPath, String keyPath, AlgorithmCertificate algorithmCertificate) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.cipherSuites = cipherSuites;
        this.certificateResources = certificatesPath;
        this.keyResource = keyPath;
        this.algorithmCertificate = algorithmCertificate;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        Level logLevel = alertLevel == 2 ? Level.ERROR : Level.WARN;
        LOGGER.log((Priority)logLevel, (Object)String.format("DTLS server raised alert (AlertLevel.%d, AlertDescription.%d, message='%s')", alertLevel, alertDescription, message), (Throwable)cause);
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level logLevel = alertLevel == 2 ? Level.ERROR : Level.WARN;
        LOGGER.log((Priority)logLevel, (Object)String.format("DTLS server received alert (AlertLevel.%d, AlertDescription.%d)", alertLevel, alertDescription));
    }

    public int getSelectedCipherSuite() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getSelectedCipherSuite()");
        }
        boolean eccCipherSuitesEnabled = this.supportsClientECCCapabilities(this.namedCurves, this.clientECPointFormats);
        int[] cipherSuites = this.getCipherSuites();
        for (int i = 0; i < cipherSuites.length; ++i) {
            int cipherSuite = cipherSuites[i];
            if (!Arrays.contains((int[])this.offeredCipherSuites, (int)cipherSuite) || !eccCipherSuitesEnabled && TlsECCUtils.isECCCipherSuite((int)cipherSuite) || !org.bouncycastle.crypto.tls.TlsUtils.isValidCipherSuiteForVersion((int)cipherSuite, (ProtocolVersion)this.serverVersion)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("> SelectedCipherSuite=" + cipherSuite));
            }
            this.selectedCipherSuite = cipherSuite;
            return this.selectedCipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    public CertificateRequest getCertificateRequest() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getCertificateRequest()");
        }
        Vector<SignatureAndHashAlgorithm> serverSigAlgs = null;
        if (org.bouncycastle.crypto.tls.TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.serverVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{this.algorithmCertificate.getSignatureAlgorithm(), 3};
            serverSigAlgs = new Vector<SignatureAndHashAlgorithm>();
            for (int i = 0; i < hashAlgorithms.length; ++i) {
                for (int j = 0; j < signatureAlgorithms.length; ++j) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("CertificateRequest, hash=" + hashAlgorithms[i] + ", sign=" + signatureAlgorithms[j]));
                    }
                    serverSigAlgs.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                }
            }
        }
        CertificateRequest cRequest = new CertificateRequest(new short[]{this.algorithmCertificate.getClientCertificate()}, serverSigAlgs, null);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("> CertificateRequest=" + this.algorithmCertificate.getClientCertificate()));
        }
        return cRequest;
    }

    public void notifyClientCertificate(org.bouncycastle.crypto.tls.Certificate clientCertificate) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("> notifyClientCertificate(" + clientCertificate + ")"));
        }
        Certificate[] chain = clientCertificate.getCertificateList();
        LOGGER.info((Object)String.format("Received client certificate chain of length %d", chain.length));
        for (int i = 0; i != chain.length; ++i) {
            Certificate entry = chain[i];
            LOGGER.info((Object)String.format("WebRTC Client certificate fingerprint:%s (%s)", TlsUtils.fingerprint(this.hashFunction, entry), entry.getSubject()));
        }
    }

    protected ProtocolVersion getMaximumVersion() {
        return this.maxVersion;
    }

    protected ProtocolVersion getMinimumVersion() {
        return this.minVersion;
    }

    protected TlsSignerCredentials getECDSASignerCredentials() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getECDSASignerCredentials()");
            LOGGER.trace((Object)("> context        =" + this.context.getServerVersion()));
            LOGGER.trace((Object)("> CERT resources =" + this.certificateResources.length));
            LOGGER.trace((Object)("> KEY  resource  =" + this.keyResource));
        }
        TlsSignerCredentials ecdsaCredentials = TlsUtils.loadSignerCredentials(this.context, this.certificateResources, this.keyResource, new SignatureAndHashAlgorithm(4, 3));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("> ECDSASignerCredentials=" + ecdsaCredentials.toString()));
        }
        return ecdsaCredentials;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getRSAEncryptionCredentials()");
        }
        return TlsUtils.loadEncryptionCredentials((TlsContext)this.context, this.certificateResources, this.keyResource);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getRASignerCredentials()");
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        if (sigAlgs != null) {
            for (int i = 0; i < sigAlgs.size(); ++i) {
                SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                if (sigAlg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = sigAlg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        return TlsUtils.loadSignerCredentials(this.context, this.certificateResources, this.keyResource, signatureAndHashAlgorithm);
    }

    public Hashtable<Integer, byte[]> getServerExtensions() throws IOException {
        Hashtable serverExtensions;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> getServerExtensions()");
        }
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)(serverExtensions = super.getServerExtensions())) == null) {
            if (serverExtensions == null) {
                serverExtensions = new Hashtable();
            }
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, (UseSRTPData)this.serverSrtpData);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("ServerExtensions(size)=" + serverExtensions.size()));
        }
        return serverExtensions;
    }

    public void processClientExtensions(Hashtable newClientExtensions) throws IOException {
        super.processClientExtensions(newClientExtensions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> processClientExtensions()");
        }
        int chosenProfile = 1;
        UseSRTPData clientSrtpData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)newClientExtensions);
        block3: for (int profile : clientSrtpData.getProtectionProfiles()) {
            switch (profile) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    chosenProfile = profile;
                    continue block3;
                }
            }
        }
        int[] protectionProfiles = new int[]{chosenProfile};
        this.serverSrtpData = new UseSRTPData(protectionProfiles, clientSrtpData.getMki());
    }

    public byte[] getKeyingMaterial(int length) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("> getKeyingMaterial(len)=" + length));
        }
        return this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, length);
    }

    public void prepareSrtpSharedSecret() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"> prepareSrtpSharedSecret()");
        }
        SRTPParameters srtpParams = SRTPParameters.getSrtpParametersForProfile((int)this.serverSrtpData.getProtectionProfiles()[0]);
        int keyLen = srtpParams.getCipherKeyLength();
        int saltLen = srtpParams.getCipherSaltLength();
        this.srtpPolicy = srtpParams.getSrtpPolicy();
        this.srtcpPolicy = srtpParams.getSrtcpPolicy();
        this.srtpMasterClientKey = new byte[keyLen];
        this.srtpMasterServerKey = new byte[keyLen];
        this.srtpMasterClientSalt = new byte[saltLen];
        this.srtpMasterServerSalt = new byte[saltLen];
        byte[] sharedSecret = this.getKeyingMaterial(2 * (keyLen + saltLen));
        System.arraycopy(sharedSecret, 0, this.srtpMasterClientKey, 0, keyLen);
        System.arraycopy(sharedSecret, keyLen, this.srtpMasterServerKey, 0, keyLen);
        System.arraycopy(sharedSecret, 2 * keyLen, this.srtpMasterClientSalt, 0, saltLen);
        System.arraycopy(sharedSecret, 2 * keyLen + saltLen, this.srtpMasterServerSalt, 0, saltLen);
    }

    public SRTPPolicy getSrtpPolicy() {
        return this.srtpPolicy;
    }

    public SRTPPolicy getSrtcpPolicy() {
        return this.srtcpPolicy;
    }

    public byte[] getSrtpMasterServerKey() {
        return this.srtpMasterServerKey;
    }

    public byte[] getSrtpMasterServerSalt() {
        return this.srtpMasterServerSalt;
    }

    public byte[] getSrtpMasterClientKey() {
        return this.srtpMasterClientKey;
    }

    public byte[] getSrtpMasterClientSalt() {
        return this.srtpMasterClientSalt;
    }

    public String generateFingerprint(String hashFunction) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("> generateFingerPrint(" + hashFunction + ")"));
        }
        try {
            this.hashFunction = hashFunction;
            org.bouncycastle.crypto.tls.Certificate chain = TlsUtils.loadCertificateChain(this.certificateResources);
            Certificate certificate = chain.getCertificateAt(0);
            return TlsUtils.fingerprint(this.hashFunction, certificate);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Could not get local fingerprint: " + e.getMessage()));
            return "";
        }
    }

    public int[] getCipherSuites() {
        int[] cipherSuites = new int[this.cipherSuites.length];
        for (int i = 0; i < this.cipherSuites.length; ++i) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("> getCipherSuites(" + this.cipherSuites[i].name() + ")"));
            }
            cipherSuites[i] = this.cipherSuites[i].getValue();
        }
        return cipherSuites;
    }
}

