/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.dtls;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.tls.DefaultTlsAgreementCredentials;
import org.bouncycastle.crypto.tls.DefaultTlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAgreementCredentials;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsServerContext;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class TlsUtils {
    private static final Logger LOGGER = Logger.getLogger(TlsUtils.class);
    private static final String SHA_1 = "sha-1";
    private static final String SHA_256 = "sha-256";
    private static final String SHA_512 = "sha-512";
    static final byte[] rsaCertData = Base64.decode((String)"MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA2MDIwNVoXDTEzMDIyNTA2MDM0NVowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCBSAwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAHU55NczeglREcTg54YLUlGWu2WOYWhit/iM1eeq8Kivro7q98eW52jTuMI3CI5ulqd0hYzshQKQaZ5GDzErMyM=");
    static final byte[] dudRsaCertData = Base64.decode((String)"MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA1NDcyOFoXDTEzMDIyNTA1NDkwOFowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCAAEwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAJg55PBSweg6obRUKF4FF6fCrWFi6oCYSQ99LWcAeupc5BofW5MstFMhCOaEucuGVqunwT5G7/DweazzCIrSzB0=");

    static String fingerprint(String hashFunction, Certificate c) throws IOException {
        byte[] der = c.getEncoded();
        byte[] sha1 = TlsUtils.digestOf(hashFunction, der);
        byte[] hexBytes = Hex.encode((byte[])sha1);
        String hex = new String(hexBytes, "ASCII").toUpperCase();
        StringBuffer fp = new StringBuffer();
        int i = 0;
        fp.append(hex.substring(i, i + 2));
        while ((i += 2) < hex.length()) {
            fp.append(':');
            fp.append(hex.substring(i, i + 2));
        }
        switch (hashFunction) {
            case "sha-1": {
                return "sha-1 " + fp.toString();
            }
            case "sha-512": {
                return "sha-512 " + fp.toString();
            }
        }
        return "sha-256 " + fp.toString();
    }

    static byte[] digestOf(String hashFunction, byte[] input) {
        SHA1Digest d;
        switch (hashFunction) {
            case "sha-1": {
                d = new SHA1Digest();
                break;
            }
            case "sha-512": {
                d = new SHA512Digest();
                break;
            }
            default: {
                d = new SHA256Digest();
            }
        }
        d.update(input, 0, input.length);
        byte[] result = new byte[d.getDigestSize()];
        d.doFinal(result, 0);
        return result;
    }

    static TlsAgreementCredentials loadAgreementCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        org.bouncycastle.crypto.tls.Certificate certificate = TlsUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsAgreementCredentials(certificate, privateKey);
    }

    static TlsEncryptionCredentials loadEncryptionCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        org.bouncycastle.crypto.tls.Certificate certificate = TlsUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsEncryptionCredentials(context, certificate, privateKey);
    }

    static TlsSignerCredentials loadSignerCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        org.bouncycastle.crypto.tls.Certificate certificate = TlsUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsSignerCredentials(context, certificate, privateKey);
    }

    static TlsSignerCredentials loadSignerCredentials(TlsServerContext context, String[] certResources, String keyResource, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        org.bouncycastle.crypto.tls.Certificate certificate = TlsUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsSignerCredentials((TlsContext)context, certificate, privateKey, signatureAndHashAlgorithm);
    }

    static org.bouncycastle.crypto.tls.Certificate loadCertificateChain(String[] resources) throws IOException {
        Certificate[] chain = new Certificate[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            chain[i] = TlsUtils.loadCertificateResource(resources[i]);
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace((Object)("load Certificate Chain =" + chain[i].toString() + " from " + resources[i]));
        }
        return new org.bouncycastle.crypto.tls.Certificate(chain);
    }

    static Certificate loadCertificateResource(String resource) throws IOException {
        PemObject pem = TlsUtils.loadPemResource(resource);
        if (pem.getType().endsWith("CERTIFICATE")) {
            return Certificate.getInstance((Object)pem.getContent());
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid certificate");
    }

    static AsymmetricKeyParameter loadPrivateKeyResource(String resource) throws IOException {
        PemObject pem = TlsUtils.loadPemResource(resource);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("load Private key =" + resource));
            LOGGER.trace((Object)("type             =" + pem.getType()));
        }
        if (pem.getType().endsWith("RSA PRIVATE KEY")) {
            RSAPrivateKey rsa = RSAPrivateKey.getInstance((Object)pem.getContent());
            return new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
        }
        if (pem.getType().endsWith("PRIVATE KEY")) {
            AsymmetricKeyParameter pKey = PrivateKeyFactory.createKey((byte[])pem.getContent());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("key =" + pKey.isPrivate()));
                LOGGER.trace((Object)pKey.toString());
            }
            return pKey;
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid private key");
    }

    static PemObject loadPemResource(String resource) throws IOException {
        FileInputStream s = new FileInputStream(resource);
        try (PemReader p = new PemReader((Reader)new InputStreamReader(s));){
            PemObject o;
            PemObject pemObject = o = p.readPemObject();
            return pemObject;
        }
    }
}

